/*
 * Decompiled with CFR 0.152.
 */
package minestrapteam.minestrappolation.entity;

import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class EntityThrowableExplosive
extends EntityThrowable {
    protected int fuse = 60;
    protected double bounceFactor = 0.5;
    protected float explosionRange = 4.0f;

    public EntityThrowableExplosive(World world) {
        super(world);
    }

    public EntityThrowableExplosive(World world, EntityLivingBase thrower) {
        super(world, thrower);
    }

    public EntityThrowableExplosive(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public void func_70071_h_() {
        Vec3 dest;
        Vec3 src;
        MovingObjectPosition impact;
        double prevVelX = this.field_70159_w;
        double prevVelY = this.field_70181_x;
        double prevVelZ = this.field_70179_y;
        this.func_70091_d(prevVelX, prevVelY, prevVelZ);
        if (this.field_70159_w != prevVelX) {
            this.field_70159_w = -this.bounceFactor * prevVelX;
        }
        if (this.field_70181_x != prevVelY) {
            this.field_70181_x = -this.bounceFactor * prevVelY;
        }
        if (this.field_70179_y != prevVelZ) {
            this.field_70179_y = -this.bounceFactor * prevVelZ;
        }
        if (this.isImpacted(impact = this.field_70170_p.func_72933_a(src = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v), dest = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y))))) {
            this.func_70184_a(impact);
        }
        this.field_70181_x -= 0.04;
        this.field_70159_w *= 0.9;
        this.field_70181_x *= 0.9;
        this.field_70179_y *= 0.9;
        this.updateFuse();
    }

    protected final void updateFuse() {
        this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0);
        if (this.fuse-- <= 0 && !this.field_70170_p.field_72995_K) {
            this.explode();
        }
    }

    protected void explode() {
        this.field_70170_p.func_72876_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.explosionRange, true);
        AxisAlignedBB axisalignedbb = this.field_70121_D.func_72314_b((double)this.explosionRange, (double)this.explosionRange, (double)this.explosionRange);
        List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
        for (EntityLivingBase living : list) {
            this.affectEntity(living);
        }
        this.func_70106_y();
    }

    public boolean isImpacted(MovingObjectPosition impact) {
        if (impact == null) {
            return false;
        }
        switch (impact.field_72313_a) {
            case MISS: {
                return false;
            }
            case BLOCK: {
                return this.field_70170_p.func_147439_a(impact.field_72311_b, impact.field_72312_c, impact.field_72309_d).func_149662_c();
            }
            case ENTITY: {
                return true;
            }
        }
        return false;
    }

    public abstract void affectEntity(EntityLivingBase var1);

    protected void func_70184_a(MovingObjectPosition impact) {
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74777_a("Fuse", (short)this.fuse);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.fuse = nbt.func_74765_d("Fuse");
    }
}

