/*
 * Decompiled with CFR 0.152.
 */
package minestrapteam.minestrappolation.crafting.sawmill;

import clashsoft.cslib.minecraft.stack.CSStacks;
import java.util.HashMap;
import minestrapteam.minestrappolation.crafting.sawmill.ISawingRecipe;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ShapedSawingRecipe
implements ISawingRecipe {
    public final int recipeWidth;
    public final int recipeHeight;
    public final ItemStack[] recipeItems;
    public final ItemStack recipeOutput;
    protected boolean hasNBTResult;

    public ShapedSawingRecipe(ItemStack output, Object ... data) {
        String s = "";
        int index = 0;
        int width = 0;
        int height = 0;
        if (data[index] instanceof String[]) {
            String[] strings;
            for (String s1 : strings = (String[])data[index++]) {
                ++height;
                width = s1.length();
                s = s + s1;
            }
        } else {
            while (data[index] instanceof String) {
                String s1 = (String)data[index++];
                ++height;
                width = s1.length();
                s = s + s1;
            }
        }
        HashMap<Character, ItemStack> map = new HashMap<Character, ItemStack>();
        while (index < data.length) {
            Character c = (Character)data[index];
            int index1 = index + 1;
            ItemStack stack1 = null;
            if (data[index1] instanceof Item) {
                stack1 = new ItemStack((Item)data[index1]);
            } else if (data[index1] instanceof Block) {
                stack1 = new ItemStack((Block)data[index1], 1, Short.MAX_VALUE);
            } else if (data[index1] instanceof ItemStack) {
                stack1 = (ItemStack)data[index1];
            }
            map.put(c, stack1);
            index += 2;
        }
        int len = width * height;
        ItemStack[] stacks = new ItemStack[len];
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            stacks[i] = map.containsKey(Character.valueOf(c)) ? ((ItemStack)map.get(Character.valueOf(c))).func_77946_l() : null;
        }
        this.recipeWidth = width;
        this.recipeHeight = height;
        this.recipeItems = stacks;
        this.recipeOutput = output;
    }

    public ShapedSawingRecipe(ItemStack output, int width, int height, ItemStack[] data) {
        this.recipeOutput = output;
        this.recipeWidth = width;
        this.recipeHeight = height;
        this.recipeItems = data;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    @Override
    public boolean matches(InventoryCrafting inventory, World world) {
        for (int i = 0; i <= 3 - this.recipeWidth; ++i) {
            for (int j = 0; j <= 3 - this.recipeHeight; ++j) {
                if (this.checkMatch(inventory, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(inventory, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting inventory, int x, int y, boolean mirror) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack stack2;
                int i1 = i - x;
                int j1 = j - y;
                ItemStack stack1 = null;
                if (i1 >= 0 && j1 >= 0 && i1 < this.recipeWidth && j1 < this.recipeHeight) {
                    stack1 = mirror ? this.recipeItems[this.recipeWidth - i1 - 1 + j1 * this.recipeWidth] : this.recipeItems[i1 + j1 * this.recipeWidth];
                }
                if ((stack2 = inventory.func_70463_b(i, j)) == null && stack1 == null || CSStacks.equals(stack1, (ItemStack)stack2)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting inventory) {
        ItemStack stack = this.getRecipeOutput().func_77946_l();
        if (this.hasNBTResult) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack1 = inventory.func_70301_a(i);
                if (stack1 == null || !stack1.func_77942_o()) continue;
                stack.func_77982_d((NBTTagCompound)stack1.field_77990_d.func_74737_b());
            }
        }
        return stack;
    }

    @Override
    public int getRecipeSize() {
        return this.recipeWidth * this.recipeHeight;
    }

    public ShapedSawingRecipe setHasNBTResult(boolean hasNBTResult) {
        this.hasNBTResult = hasNBTResult;
        return this;
    }
}

