/*
 * Decompiled with CFR 0.152.
 */
package minestrapteam.minestrappolation.block;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import minestrapteam.minestrappolation.Minestrappolation;
import minestrapteam.minestrappolation.common.MCommonProxy;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MBlockCustom2
extends Block {
    public String[] types;
    public String name;
    public float baseHardness;
    public float baseResistance;
    public int harvestLevel;
    public String harvestTool;
    public Map<String, IIcon> iconMap = new HashMap<String, IIcon>();
    public boolean slabSided;
    public boolean rawSlabUnsided;
    public boolean netherrack;
    public boolean redSandstone;
    public boolean enderDragonCantDestroy;
    public boolean beaconBase;

    public MBlockCustom2(String[] types, String name) {
        this(types, name, 1.0f, 5.0f, 0, Material.field_151576_e);
    }

    public MBlockCustom2(String[] types, String name, Material mat) {
        this(types, name, 1.0f, 5.0f, 0, mat);
    }

    public MBlockCustom2(String[] types, String name, float baseHardness, float baseResistance, int harvestLevel, Material mat) {
        super(mat);
        this.func_149647_a(Minestrappolation.tabStoneDecor);
        this.name = name;
        this.baseHardness = baseHardness;
        this.baseResistance = baseResistance;
        this.harvestLevel = harvestLevel;
        this.types = types;
    }

    public MBlockCustom2 setEnderDragonCantDestroy() {
        this.enderDragonCantDestroy = true;
        return this;
    }

    public MBlockCustom2 setBeaconBase() {
        this.beaconBase = true;
        return this;
    }

    public MBlockCustom2 setRawSlabUnsided() {
        this.rawSlabUnsided = true;
        return this;
    }

    public MBlockCustom2 setIsNetherrack() {
        this.netherrack = true;
        return this;
    }

    public MBlockCustom2 setIsRedSandstone() {
        this.redSandstone = true;
        return this;
    }

    public MBlockCustom2 setSlabSided() {
        this.slabSided = true;
        return this;
    }

    public MBlockCustom2 setHarvestTool(String harvestTool) {
        this.harvestTool = harvestTool;
        return this;
    }

    public ItemStack toStack(String type) {
        return this.toStack(type, 1);
    }

    public ItemStack toStack(String type, int size) {
        int i = Arrays.binarySearch(this.types, type);
        return new ItemStack((Block)this, size, i);
    }

    public String getType(int metadata) {
        if ((metadata /= 3) < 0 || metadata >= this.types.length) {
            return null;
        }
        return this.types[metadata];
    }

    public String getUnlocalizedName(int metadata) {
        return "tile." + this.name + "." + this.getType(metadata);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.setBlockBounds(world.func_72805_g(x, y, z));
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        super.func_149743_a(world, x, y, z, aabb, list, entity);
    }

    public void setBlockBounds(int metadata) {
        if ("pillar".equals(this.getType(metadata))) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            int model = metadata % 3;
            if (model == 0) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
            } else if (model == 1) {
                this.func_149676_a(0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f);
            } else {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if ("pillar".equals(this.getType(metadata))) {
            if (side == 0 || side == 1) {
                return 0;
            }
            if (side == 2 || side == 3) {
                return 1;
            }
            if (side == 4 || side == 5) {
                return 2;
            }
        } else if (side == 0 || side != 1 && (double)hitY > 0.5) {
            return metadata + 1;
        }
        return metadata;
    }

    public int limitToValidMetadata(int metadata) {
        return metadata - metadata % 3;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        if (!"pillar".equals(this.getType(meta))) {
            return meta % 3 == 2 ? 2 : 1;
        }
        return 1;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return this.limitToValidMetadata(world.func_72805_g(x, y, z));
    }

    public int func_149692_a(int metadata) {
        return this.limitToValidMetadata(metadata);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return this.getHardness(world.func_72805_g(x, y, z));
    }

    public float getHardness(int metadata) {
        return this.baseHardness;
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return this.baseResistance;
    }

    public String getHarvestTool(int metadata) {
        return this.harvestTool;
    }

    public int getHarvestLevel(int metadata) {
        return this.harvestLevel;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        String textureName = this.func_149641_N();
        this.iconMap.clear();
        for (String type : this.types) {
            if (type == null) continue;
            if ("pillar".equals(type)) {
                this.iconMap.put("pillar_top", iconRegister.func_94245_a(textureName + "_pillar_top"));
                this.iconMap.put("pillar_side", iconRegister.func_94245_a(textureName + "_pillar_side"));
                continue;
            }
            if ("raw_slab".equals(type)) {
                if (this.redSandstone) {
                    this.iconMap.put("top", iconRegister.func_94245_a(textureName + "_top"));
                    this.iconMap.put("side", iconRegister.func_94245_a(textureName + "_side"));
                    this.iconMap.put("bottom", iconRegister.func_94245_a(textureName + "_bottom"));
                    continue;
                }
                if (this.rawSlabUnsided) {
                    this.iconMap.put("raw", iconRegister.func_94245_a(textureName));
                    continue;
                }
                this.iconMap.put("raw_slab_top", iconRegister.func_94245_a(textureName + "_slab_top"));
                this.iconMap.put("raw_slab_side", iconRegister.func_94245_a(textureName + "_slab_side"));
                continue;
            }
            if ("refined_slab".equals(type)) {
                if (this.redSandstone) {
                    this.iconMap.put("refined_slab_side", iconRegister.func_94245_a(textureName + "_refined"));
                    continue;
                }
                this.iconMap.put("refined_slab_top", iconRegister.func_94245_a(textureName + "_refined"));
                this.iconMap.put("refined_slab_side", iconRegister.func_94245_a(textureName + "_refined_slab_side"));
                continue;
            }
            if ("tile_slab".equals(type)) {
                this.iconMap.put("tile_slab_top", iconRegister.func_94245_a(textureName + "_tiles"));
                if (!this.slabSided) continue;
                this.iconMap.put("tile_slab_side", iconRegister.func_94245_a(textureName + "_tile_slab_side"));
                continue;
            }
            if ("brick_slab".equals(type)) {
                this.iconMap.put("brick_slab_top", iconRegister.func_94245_a(textureName + "_bricks"));
                if (!this.slabSided) continue;
                this.iconMap.put("brick_slab_side", iconRegister.func_94245_a(textureName + "_brick_slab_side"));
                continue;
            }
            int i = type.indexOf("_slab");
            String type1 = type;
            if (i != -1) {
                type1 = type.substring(0, i);
            }
            this.iconMap.put(type, iconRegister.func_94245_a(textureName + "_" + type1));
        }
    }

    public IIcon func_149691_a(int side, int metadata) {
        int m = metadata % 3;
        String type = this.getType(metadata);
        if (type == null) {
            return this.field_149761_L;
        }
        if ("pillar".equals(type)) {
            if (m == 0 && (side == 0 || side == 1) || m == 1 && (side == 2 || side == 3) || m == 2 && (side == 4 || side == 5)) {
                return this.iconMap.get("pillar_top");
            }
            return this.iconMap.get("pillar_side");
        }
        if ("raw_slab".equals(type)) {
            if (this.redSandstone) {
                return side == 0 ? this.iconMap.get("bottom") : (side == 1 ? this.iconMap.get("top") : this.iconMap.get("side"));
            }
            if (this.rawSlabUnsided) {
                return this.iconMap.get("raw");
            }
            if (side > 1) {
                return this.iconMap.get("raw_slab_side");
            }
            return this.iconMap.get("raw_slab_top");
        }
        if ("refined_slab".equals(type)) {
            if (this.redSandstone) {
                return side == 0 || side == 1 ? this.iconMap.get("top") : this.iconMap.get("refined_slab_side");
            }
            if (side > 1) {
                return this.iconMap.get("refined_slab_side");
            }
            return this.iconMap.get("refined_slab_top");
        }
        if ("tile_slab".equals(type)) {
            if (side > 1 && this.slabSided) {
                return this.iconMap.get("tile_slab_side");
            }
            return this.iconMap.get("tile_slab_top");
        }
        if ("brick_slab".equals(type)) {
            if (side > 1 && this.slabSided) {
                return this.iconMap.get("brick_slab_side");
            }
            return this.iconMap.get("brick_slab_top");
        }
        return this.iconMap.get(type);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return MCommonProxy.custom2RenderID;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] == null) continue;
            list.add(new ItemStack(item, 1, i * 3));
        }
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        if (this.enderDragonCantDestroy) {
            return false;
        }
        return super.canEntityDestroy(world, x, y, z, entity);
    }

    public boolean isBeaconBase(IBlockAccess world, int x, int y, int z, int beaconX, int beaconY, int beaconZ) {
        int metadata = world.func_72805_g(x, y, z);
        if ("pillar".equals(this.getType(metadata))) {
            return this.beaconBase;
        }
        return false;
    }

    public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
        return this.netherrack && this.isSideSolid((IBlockAccess)world, x, y, z, side);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int metadata = world.func_72805_g(x, y, z);
        String type = this.getType(metadata);
        int model = metadata % 3;
        if ("pillar".equals(type) || model == 2) {
            return true;
        }
        System.out.println(type);
        return model == 0 && side == ForgeDirection.DOWN || model == 1 && side == ForgeDirection.UP;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (this.func_149688_o() == Material.field_151575_d) {
            int metadata = world.func_72805_g(x, y, z);
            if ("pillar".equals(this.getType(metadata))) {
                return 300;
            }
            return 150;
        }
        return super.getFlammability(world, x, y, z, face);
    }
}

