/*
 * Decompiled with CFR 0.152.
 */
package minestrapteam.minestrappolation.block;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import minestrapteam.minestrappolation.lib.MBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MBlockCustom
extends Block {
    public String[] types;
    public String name;
    public float baseHardness;
    public float baseResistance;
    public int harvestLevel;
    public String harvestTool;
    public Map<String, IIcon> iconMap = new HashMap<String, IIcon>();
    public boolean chiseledSided;
    public boolean clay;
    public boolean stone;
    public boolean netherrack;
    public boolean redSandstone;
    public boolean enderDragonCantDestroy;
    public boolean beaconBase;
    public float walkSpeed = 1.0f;

    public MBlockCustom(String[] types, String name) {
        this(types, name, 1.0f, 5.0f, 0, Material.field_151576_e);
    }

    public MBlockCustom(String[] types, String name, Material mat) {
        this(types, name, 1.0f, 5.0f, 0, mat);
    }

    public MBlockCustom(String[] types, String name, float baseHardness, float baseResistance, int harvestLevel, Material mat) {
        super(mat);
        this.name = name;
        this.baseHardness = baseHardness;
        this.baseResistance = baseResistance;
        this.harvestLevel = harvestLevel;
        this.types = types;
    }

    public MBlockCustom setEnderDragonCantDestroy() {
        this.enderDragonCantDestroy = true;
        return this;
    }

    public MBlockCustom setBeaconBase() {
        this.beaconBase = true;
        return this;
    }

    public MBlockCustom setRoadWalkSpeed(float percent) {
        this.walkSpeed = percent;
        return this;
    }

    public MBlockCustom setIsRedSandstone() {
        this.redSandstone = true;
        return this;
    }

    public MBlockCustom setChiseledSided() {
        this.chiseledSided = true;
        return this;
    }

    public MBlockCustom setIsClay() {
        this.clay = true;
        return this;
    }

    public MBlockCustom setIsStone() {
        this.stone = true;
        return this;
    }

    public MBlockCustom setIsNetherrack() {
        this.netherrack = true;
        return this;
    }

    public MBlockCustom setHarvestTool(String tool) {
        this.harvestTool = tool;
        return this;
    }

    public ItemStack toStack(String type) {
        return this.toStack(type, 1);
    }

    public ItemStack toStack(String type, int size) {
        int i = Arrays.binarySearch(this.types, type);
        return new ItemStack((Block)this, size, i);
    }

    public String getType(int metadata) {
        if (metadata < 0 || metadata >= this.types.length) {
            return null;
        }
        return this.types[metadata];
    }

    public String getUnlocalizedName(int metadata) {
        return "tile." + this.name + "." + this.getType(metadata);
    }

    public boolean func_149700_E() {
        return true;
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        if (this == MBlocks.endstone && metadata == 0) {
            return Item.func_150898_a((Block)Blocks.field_150377_bs);
        }
        if (this.getType(metadata).contains("rotten")) {
            return Items.field_151055_y;
        }
        return super.func_149650_a(metadata, random, fortune);
    }

    public int func_149692_a(int metadata) {
        if (this.getType(metadata).contains("rotten")) {
            return 0;
        }
        return metadata;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public int quantityDropped(int metadata, int fortune, Random random) {
        if (this.getType(metadata).contains("rotten")) {
            return MathHelper.func_76125_a((int)(2 + random.nextInt(fortune + 3)), (int)1, (int)4);
        }
        return 1;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return this.getHardness(world.func_72805_g(x, y, z));
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return this.getResistance(world.func_72805_g(x, y, z));
    }

    public String getHarvestTool(int metadata) {
        return this.harvestTool;
    }

    public int getHarvestLevel(int metadata) {
        return this.harvestLevel;
    }

    public float getHardness(int metadata) {
        float f = this.baseHardness;
        String type = this.getType(metadata);
        if (type == null || "raw".equals(type)) {
            return f;
        }
        if ("bricks".equals(type)) {
            if (this.netherrack) {
                return f + 1.6f;
            }
            if (this.clay) {
                return f + 0.75f;
            }
        } else if ("pattern_bricks".equals(type)) {
            if (this.netherrack) {
                return f + 1.6f;
            }
            if (this.clay) {
                return f + 0.75f;
            }
        } else {
            if ("refined".equals(type)) {
                if (this.netherrack) {
                    return (f + 1.6f) * 0.6666667f;
                }
                if (this.clay) {
                    return (f + 0.75f) * 0.6666667f;
                }
                return f * 0.6666667f;
            }
            if ("cracked".equals(type)) {
                if (this.stone) {
                    return f * 1.3333334f;
                }
            } else if ("mossy".equals(type)) {
                if (this.stone) {
                    return f * 1.3333334f;
                }
            } else {
                if (type.contains("lamp")) {
                    return f * 0.8f;
                }
                if (type.contains("rotten")) {
                    return f * 0.9f;
                }
            }
        }
        return f;
    }

    public float getResistance(int metadata) {
        float f = this.baseResistance;
        String type = this.getType(metadata);
        if (type == null || "raw".equals(type)) {
            return f;
        }
        if ("bricks".equals(type)) {
            if (this.netherrack) {
                return f + 1.6f;
            }
            if (this.clay) {
                return f + 0.75f;
            }
        } else if ("pattern_bricks".equals(type)) {
            if (this.netherrack) {
                return f + 1.6f;
            }
            if (this.clay) {
                return f + 0.75f;
            }
        } else {
            if ("refined".equals(type)) {
                if (this.netherrack) {
                    return (f + 1.6f) * 0.6666667f;
                }
                if (this.clay) {
                    return (f + 0.75f) * 0.6666667f;
                }
                return f * 0.6666667f;
            }
            if ("cracked".equals(type)) {
                if (this.stone) {
                    return f * 1.3333334f;
                }
            } else if ("mossy".equals(type)) {
                if (this.stone) {
                    return f * 1.3333334f;
                }
            } else {
                if (type.contains("lamp")) {
                    return f * 0.8f;
                }
                if (type.contains("rotten")) {
                    return f * 0.9f;
                }
            }
        }
        return f;
    }

    public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
        if (this.netherrack && side == ForgeDirection.UP) {
            String type = this.getType(world.func_72805_g(x, y, z));
            return !"road".equals(type) && !"pattern_bricks".equals(type);
        }
        return false;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        String type = this.getType(metadata);
        if ("glowstone_lamp".equals(type)) {
            return Blocks.field_150426_aN.func_149750_m();
        }
        if (type.contains("lamp")) {
            return 15;
        }
        return super.getLightValue(world, x, y, z);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        String textureName = this.func_149641_N();
        this.iconMap.clear();
        for (String type : this.types) {
            if (type == null) continue;
            if ("raw".equals(type)) {
                if (this.redSandstone) {
                    this.iconMap.put("top", iconRegister.func_94245_a(textureName + "_top"));
                    this.iconMap.put("side", iconRegister.func_94245_a(textureName + "_side"));
                    this.iconMap.put("bottom", iconRegister.func_94245_a(textureName + "_bottom"));
                    continue;
                }
                this.field_149761_L = iconRegister.func_94245_a(textureName);
                continue;
            }
            if ("road".equals(type)) {
                this.iconMap.put("road_top", iconRegister.func_94245_a(textureName + "_pattern_bricks"));
                this.iconMap.put("road_side", iconRegister.func_94245_a(textureName + "_road_side"));
                this.iconMap.put("road_bottom", iconRegister.func_94245_a(textureName + "_road_bottom"));
                continue;
            }
            if ("chiseled".equals(type)) {
                if (this.clay) {
                    this.iconMap.put("chiseled", iconRegister.func_94245_a(textureName + "_refined"));
                    this.iconMap.put("chiseled_side", iconRegister.func_94245_a(textureName + "_chiseled_side"));
                    continue;
                }
                this.iconMap.put("chiseled", iconRegister.func_94245_a(textureName + "_chiseled"));
                if (!this.chiseledSided) continue;
                this.iconMap.put("chiseled_side", iconRegister.func_94245_a(textureName + "_chiseled_side"));
                continue;
            }
            this.iconMap.put(type, iconRegister.func_94245_a(textureName + "_" + type));
        }
    }

    public IIcon func_149691_a(int side, int metadata) {
        String type = this.getType(metadata);
        if (type == null || "raw".equals(type)) {
            if (this.redSandstone) {
                return side == 0 ? this.iconMap.get("bottom") : (side == 1 ? this.iconMap.get("top") : this.iconMap.get("side"));
            }
            return this.field_149761_L;
        }
        if ("refined".equals(type)) {
            if (this.redSandstone) {
                return side == 0 || side == 1 ? this.iconMap.get("top") : this.iconMap.get("refined");
            }
            return this.iconMap.get("refined");
        }
        if ("road".equals(type)) {
            if (side == 0) {
                return this.iconMap.get("road_bottom");
            }
            if (side == 1) {
                return this.iconMap.get("road_top");
            }
            return this.iconMap.get("road_side");
        }
        if ("chiseled".equals(type)) {
            if (this.redSandstone) {
                if (side == 0) {
                    return this.iconMap.get("bottom");
                }
                if (side == 1) {
                    return this.iconMap.get("top");
                }
                return this.iconMap.get("chiseled");
            }
            if (side > 1 && (this.clay || this.chiseledSided)) {
                return this.iconMap.get("chiseled_side");
            }
            return this.iconMap.get("chiseled");
        }
        if ("gilded".equals(type)) {
            return this.iconMap.get("gilded");
        }
        return this.iconMap.get(type);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] == null) continue;
            list.add(new ItemStack(item, 1, i));
        }
    }

    public void func_149724_b(World world, int x, int y, int z, Entity entityWalking) {
        String type = this.getType(world.func_72805_g(x, y, z));
        if (type == null) {
            return;
        }
        if ("road".equals(type)) {
            entityWalking.field_70159_w *= (double)this.walkSpeed;
            entityWalking.field_70181_x *= (double)this.walkSpeed;
            entityWalking.field_70179_y *= (double)this.walkSpeed;
        } else if (type.contains("rotten") && !world.field_72995_K) {
            world.func_147480_a(x, y, z, true);
        }
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return !this.enderDragonCantDestroy && super.canEntityDestroy(world, x, y, z, entity);
    }

    public boolean isBeaconBase(IBlockAccess worldObj, int x, int y, int z, int beaconX, int beaconY, int beaconZ) {
        if (!"road".equals(this.getType(worldObj.func_72805_g(x, y, z)))) {
            return this.beaconBase;
        }
        return false;
    }
}

