/*
 * Decompiled with CFR 0.152.
 */
package argo.jdom;

import argo.jdom.JsonNode;
import argo.jdom.JsonStringNode;

public final class JsonField {
    private final JsonStringNode name;
    private final JsonNode value;

    public JsonField(JsonStringNode name, JsonNode value) {
        if (name == null) {
            throw new NullPointerException("Attempt to construct a JsonField with a null name.");
        }
        this.name = name;
        if (value == null) {
            throw new NullPointerException("Attempt to construct a JsonField with a null value.");
        }
        this.value = value;
    }

    public JsonStringNode getName() {
        return this.name;
    }

    public JsonNode getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonField jsonField = (JsonField)o;
        return this.name.equals(jsonField.name) && this.value.equals(jsonField.value);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return "JsonField{name=" + this.name + ", value=" + this.value + '}';
    }
}

