#version 120

/* DRAWBUFFERS:0N2N4 */


vec4 watercolor = vec4(0.12,0.29,0.48,0.75);

uniform sampler2D texture;

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;

varying vec4 position;
varying vec3 wpos;

varying vec3 tangent;
varying vec3 normal;
varying vec3 binormal;
varying vec3 viewVector;

varying float iswater;

uniform float frameTimeCounter;


const float PI = 3.141592653589793;


void main() {	
	
vec4 tex = texture2D(texture, texcoord.xy);
 if (iswater > 0.9) tex = watercolor;

	vec3 indlmap = mix(pow(min(lmcoord.t+0.1,1.0),2.0),1.0,lmcoord.s)*tex.rgb*color.rgb;
	gl_FragData[0] = vec4(indlmap,tex.a);

		vec4 frag2;
				frag2 = vec4((normal) * 0.5f + 0.5f, 1.0f);			


	
	gl_FragData[2] = frag2;	
	gl_FragData[4] = vec4(0.0, mix(1.0,0.05,iswater), lmcoord.s, 1.0);
	
}