/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.heraldry.tools;

import mods.battlegear2.api.heraldry.ITool;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;

public class PenTool
implements ITool {
    private int last_x = 16;
    private int last_y = 16;

    @Override
    public String getToolName() {
        return "tool.pen";
    }

    @Override
    public ResourceLocation getToolImage() {
        return new ResourceLocation("battlegear2:textures/" + this.getToolName() + ".png");
    }

    @Override
    public void drawOverlay(int x, int y, int[] pixelsCurrent, DynamicTexture overlay, int rgb, boolean shift) {
        int[] pixelsOverlay = overlay.func_110565_c();
        for (int i = 0; i < pixelsOverlay.length; ++i) {
            pixelsOverlay[i] = pixelsCurrent[i];
        }
        if (shift) {
            this.drawLine(x, this.last_x, y, this.last_y, pixelsOverlay, rgb);
        } else if (x > -1 && x < 32 && y > -1 && y < 32) {
            pixelsOverlay[x + 32 * y] = rgb;
        }
        overlay.func_110564_a();
    }

    @Override
    public void draw(int x, int y, int[] pixelsCurrent, int rgb, boolean shift) {
        if (shift) {
            this.drawLine(x, this.last_x, y, this.last_y, pixelsCurrent, rgb);
        } else if (x > -1 && x < 32 && y > -1 && y < 32) {
            pixelsCurrent[x + 32 * y] = rgb;
        }
        this.last_x = x;
        this.last_y = y;
    }

    private void drawLine(int x0, int x1, int y0, int y1, int[] pixelsCurrent, int rgb) {
        int dx = Math.abs(x1 - x0);
        int dy = Math.abs(y1 - y0);
        int sx = x0 < x1 ? 1 : -1;
        int sy = y0 < y1 ? 1 : -1;
        int err = dx - dy;
        boolean done = false;
        while (!done) {
            int e2;
            if (x0 > -1 && x0 < 32 && y0 > -1 && y0 < 32) {
                pixelsCurrent[x0 + 32 * y0] = rgb;
            }
            if (x0 == x1 && y0 == y1) {
                done = true;
            }
            if ((e2 = 2 * err) > -dy && !done) {
                err -= dy;
                x0 += sx;
            }
            if (x0 == x1 && y0 == y1 && !done) {
                if (x0 > -1 && x0 < 32 && y0 > -1 && y0 < 32) {
                    pixelsCurrent[x0 + 32 * y0] = rgb;
                }
                done = true;
            }
            if (e2 >= dx || done) continue;
            err += dx;
            y0 += sy;
        }
    }
}

