/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.heraldry.tools;

import mods.battlegear2.api.heraldry.ITool;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;

public class FloodFillTool
implements ITool {
    public int threshold = 0;

    @Override
    public String getToolName() {
        return "tool.flood";
    }

    @Override
    public ResourceLocation getToolImage() {
        return new ResourceLocation("battlegear2:textures/" + this.getToolName() + ".png");
    }

    @Override
    public void drawOverlay(int x, int y, int[] pixelsCurrent, DynamicTexture overlay, int rgb, boolean shift) {
        int[] pixelsOverlay = overlay.func_110565_c();
        for (int i = 0; i < pixelsOverlay.length; ++i) {
            pixelsOverlay[i] = pixelsCurrent[i];
        }
        if (x > -1 && x < 32 && y > -1 && y < 32) {
            pixelsOverlay[x + 32 * y] = rgb;
        }
        overlay.func_110564_a();
    }

    @Override
    public void draw(int x, int y, int[] pixelsCurrent, int rgb, boolean shift) {
        if (x > -1 && x < 32 && y > -1 && y < 32) {
            if (shift) {
                for (int i = 0; i < pixelsCurrent.length; ++i) {
                    pixelsCurrent[i] = rgb;
                }
            } else {
                int targetColour = pixelsCurrent[x + 32 * y];
                if (rgb != targetColour) {
                    this.floodFill(x, y, pixelsCurrent, targetColour, rgb);
                }
            }
        }
    }

    private void floodFill(int x, int y, int[] pixals, int targetColour, int newColour) {
        if (x > -1 && x < 32 && y > -1 && y < 32 && pixals[x + 32 * y] != newColour && this.isSame(pixals[x + 32 * y], targetColour)) {
            pixals[x + 32 * y] = newColour;
            this.floodFill(x + 1, y, pixals, targetColour, newColour);
            this.floodFill(x - 1, y, pixals, targetColour, newColour);
            this.floodFill(x, y + 1, pixals, targetColour, newColour);
            this.floodFill(x, y - 1, pixals, targetColour, newColour);
        }
    }

    private boolean isSame(int rgb1, int rgb2) {
        return rgb1 == rgb2;
    }
}

