/*
 * Decompiled with CFR 0.152.
 */
package mwinstaller;

import argo.format.PrettyJsonFormatter;
import argo.jdom.JdomParser;
import argo.jdom.JsonField;
import argo.jdom.JsonNode;
import argo.jdom.JsonNodeFactories;
import argo.jdom.JsonRootNode;
import argo.jdom.JsonStringNode;
import argo.saj.InvalidSyntaxException;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import cpw.mods.fml.installer.VersionInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;

public class MinecraftProfileUpdater {
    public void run(AbstractUIProcessHandler handler, String[] args) {
        String selectedProfile;
        JsonNode selectedProfileNode;
        handler.logOutput("Updating launcher profile...", false);
        File launcherProfile = new File(args[0], "launcher_profiles.json");
        if (!launcherProfile.exists()) {
            handler.emitError("Profiles file not found!", "Could not find launcher_profiles.json");
            return;
        }
        JdomParser parser = new JdomParser();
        JsonRootNode jsonProfileData = null;
        try {
            jsonProfileData = parser.parse(Files.newReader(launcherProfile, Charsets.UTF_8));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidSyntaxException e) {
            handler.emitError("Invalid Syntax Error", "launcher_profiles.json is corrupted.");
            e.printStackTrace();
            return;
        }
        String newProfileName = "MetaWorlds";
        HashMap<JsonStringNode, JsonNode> profileCopy = Maps.newHashMap(jsonProfileData.getNode("profiles").getFields());
        HashMap<JsonStringNode, JsonNode> rootCopy = Maps.newHashMap(jsonProfileData.getFields());
        boolean makeCleanProfile = true;
        if (rootCopy.containsKey(JsonNodeFactories.string("selectedProfile")) && (selectedProfileNode = profileCopy.get(JsonNodeFactories.string(selectedProfile = jsonProfileData.getStringValue("selectedProfile")))) != null) {
            HashMap<JsonStringNode, JsonNode> selectedProfileCopy = Maps.newHashMap(selectedProfileNode.getFields());
            selectedProfileCopy.put(JsonNodeFactories.string("name"), JsonNodeFactories.string(newProfileName));
            selectedProfileCopy.put(JsonNodeFactories.string("lastVersionId"), JsonNodeFactories.string(VersionInfo.getVersionTarget()));
            profileCopy.put(JsonNodeFactories.string(newProfileName), JsonNodeFactories.object(selectedProfileCopy));
            makeCleanProfile = false;
        }
        if (makeCleanProfile) {
            JsonField[] fields = new JsonField[]{JsonNodeFactories.field("name", (JsonNode)JsonNodeFactories.string(newProfileName)), JsonNodeFactories.field("lastVersionId", (JsonNode)JsonNodeFactories.string(VersionInfo.getVersionTarget()))};
            profileCopy.put(JsonNodeFactories.string(newProfileName), JsonNodeFactories.object(fields));
        }
        rootCopy.put(JsonNodeFactories.string("selectedProfile"), JsonNodeFactories.string(newProfileName));
        rootCopy.put(JsonNodeFactories.string("profiles"), JsonNodeFactories.object(profileCopy));
        jsonProfileData = JsonNodeFactories.object(rootCopy);
        try {
            BufferedWriter newWriter = Files.newWriter(launcherProfile, Charsets.UTF_8);
            PrettyJsonFormatter.fieldOrderPreservingPrettyJsonFormatter().format(jsonProfileData, newWriter);
            newWriter.close();
        }
        catch (Exception e) {
            handler.emitError("Launcher Error", "There was a problem writing the launch profile,  is it write protected?");
            return;
        }
        handler.logOutput("Finised!", false);
    }
}

