/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.xmlmerge.config;

import com.izforge.izpack.util.xmlmerge.Action;
import com.izforge.izpack.util.xmlmerge.ConfigurationException;
import com.izforge.izpack.util.xmlmerge.Configurer;
import com.izforge.izpack.util.xmlmerge.Mapper;
import com.izforge.izpack.util.xmlmerge.Matcher;
import com.izforge.izpack.util.xmlmerge.MergeAction;
import com.izforge.izpack.util.xmlmerge.Operation;
import com.izforge.izpack.util.xmlmerge.XmlMerge;
import com.izforge.izpack.util.xmlmerge.action.FullMergeAction;
import com.izforge.izpack.util.xmlmerge.action.StandardActions;
import com.izforge.izpack.util.xmlmerge.factory.OperationResolver;
import com.izforge.izpack.util.xmlmerge.factory.XPathOperationFactory;
import com.izforge.izpack.util.xmlmerge.mapper.IdentityMapper;
import com.izforge.izpack.util.xmlmerge.mapper.StandardMappers;
import com.izforge.izpack.util.xmlmerge.matcher.AttributeMatcher;
import com.izforge.izpack.util.xmlmerge.matcher.StandardMatchers;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractXPathConfigurer
implements Configurer {
    OperationResolver m_matcherResolver = new OperationResolver(StandardMatchers.class);
    OperationResolver m_actionResolver = new OperationResolver(StandardActions.class);
    OperationResolver m_mapperResolver = new OperationResolver(StandardMappers.class);
    MergeAction m_rootMergeAction = new FullMergeAction();
    Matcher m_defaultMatcher = new AttributeMatcher();
    Mapper m_defaultMapper = new IdentityMapper();
    Action m_defaultAction = new FullMergeAction();
    Map<String, Operation> m_matchers = new LinkedHashMap<String, Operation>();
    Map<String, Operation> m_actions = new LinkedHashMap<String, Operation>();
    Map<String, Operation> m_mappers = new LinkedHashMap<String, Operation>();

    protected final void setDefaultMatcher(String matcherName) throws ConfigurationException {
        this.m_defaultMatcher = (Matcher)this.m_matcherResolver.resolve(matcherName);
    }

    protected final void setDefaultMapper(String mapperName) throws ConfigurationException {
        this.m_defaultMapper = (Mapper)this.m_mapperResolver.resolve(mapperName);
    }

    protected final void setDefaultAction(String actionName) throws ConfigurationException {
        this.m_defaultAction = (Action)this.m_actionResolver.resolve(actionName);
    }

    protected final void setRootMergeAction(String actionName) throws ConfigurationException {
        this.m_rootMergeAction = (MergeAction)this.m_actionResolver.resolve(actionName);
    }

    protected final void addMatcher(String xPath, String matcherName) throws ConfigurationException {
        this.m_matchers.put(xPath, this.m_matcherResolver.resolve(matcherName));
    }

    protected final void addAction(String xPath, String actionName) throws ConfigurationException {
        this.m_actions.put(xPath, this.m_actionResolver.resolve(actionName));
    }

    protected final void addMapper(String xPath, String mapperName) throws ConfigurationException {
        this.m_mappers.put(xPath, this.m_mapperResolver.resolve(mapperName));
    }

    @Override
    public final void configure(XmlMerge xmlMerge) throws ConfigurationException {
        this.readConfiguration();
        XPathOperationFactory matcherFactory = new XPathOperationFactory();
        matcherFactory.setDefaultOperation(this.m_defaultMatcher);
        matcherFactory.setOperationMap(this.m_matchers);
        this.m_rootMergeAction.setMatcherFactory(matcherFactory);
        XPathOperationFactory mapperFactory = new XPathOperationFactory();
        mapperFactory.setDefaultOperation(this.m_defaultMapper);
        mapperFactory.setOperationMap(this.m_mappers);
        this.m_rootMergeAction.setMapperFactory(mapperFactory);
        XPathOperationFactory actionFactory = new XPathOperationFactory();
        actionFactory.setDefaultOperation(this.m_defaultAction);
        actionFactory.setOperationMap(this.m_actions);
        this.m_rootMergeAction.setActionFactory(actionFactory);
        xmlMerge.setRootMergeActionFactory(actionFactory);
    }

    protected abstract void readConfiguration() throws ConfigurationException;

    public void setActionResolver(OperationResolver actionResolver) {
        this.m_actionResolver = actionResolver;
    }

    public void setMapperResolver(OperationResolver mapperResolver) {
        this.m_mapperResolver = mapperResolver;
    }

    public void setMatcherResolver(OperationResolver matcherResolver) {
        this.m_matcherResolver = matcherResolver;
    }
}

