/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.LogFormatter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class LogHandler
extends StreamHandler {
    private void configure() {
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        String formatterName = manager.getProperty(cname + ".formatter");
        Formatter formatter = null;
        try {
            if (formatterName != null) {
                Class<?> formatterClass = ClassLoader.getSystemClassLoader().loadClass(formatterName);
                formatter = (Formatter)formatterClass.newInstance();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (formatter == null) {
            formatter = new LogFormatter();
        }
        this.setFormatter(formatter);
        if (Debug.isDEBUG()) {
            this.setLevel(Level.FINE);
        } else {
            this.setLevel(Level.INFO);
        }
    }

    public LogHandler() {
        this.configure();
        this.setOutputStream(System.err);
    }

    @Override
    public void publish(LogRecord record) {
        super.publish(record);
        this.flush();
    }

    @Override
    public void close() {
        this.flush();
    }
}

