/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.shortcut;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.MultiLineLabel;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.event.InstallerListeners;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.panels.shortcut.ShortcutPanelLogic;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.PlatformModelMatcher;
import com.izforge.izpack.util.TargetFactory;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ShortcutPanel
extends IzPanel
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 3256722870838112311L;
    private static final String TEXT_FILE_NAME = "Shortcuts.txt";
    private boolean initialised = false;
    private boolean isRootUser;
    private JList groupList;
    private JTextField programGroup;
    private JButton defaultButton;
    private JButton saveButton;
    private JCheckBox allowDesktopShortcut;
    private JCheckBox createShortcuts;
    private JRadioButton currentUser;
    private JRadioButton allUsers;
    private GridBagLayout layout = (GridBagLayout)super.getLayout();
    private GridBagConstraints constraints;
    private ShortcutPanelLogic shortcutPanelLogic;
    private static final Logger logger = Logger.getLogger(ShortcutPanel.class.getName());

    public ShortcutPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, UninstallData uninstallData, Housekeeper housekeeper, TargetFactory factory, InstallerListeners listeners, PlatformModelMatcher matcher) {
        super(panel, parent, installData, "link16x16", resources);
        Object con = this.getLayoutHelper().getDefaultConstraints();
        this.constraints = con instanceof GridBagConstraints ? (GridBagConstraints)con : new GridBagConstraints();
        this.setLayout(super.getLayout());
        try {
            this.shortcutPanelLogic = new ShortcutPanelLogic(installData, resources, uninstallData, housekeeper, factory, listeners, matcher);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to initialise shortcuts: " + exception.getMessage(), exception);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object eventSource = event.getSource();
        if (eventSource.equals(this.currentUser)) {
            if (this.groupList != null) {
                this.groupList.setListData(this.shortcutPanelLogic.getProgramGroups(1).toArray());
            }
            this.programGroup.setText(this.shortcutPanelLogic.getSuggestedProgramGroup());
            this.shortcutPanelLogic.setUserType(1);
        } else if (eventSource.equals(this.allUsers)) {
            if (this.groupList != null) {
                this.groupList.setListData(this.shortcutPanelLogic.getProgramGroups(2).toArray());
            }
            this.programGroup.setText(this.shortcutPanelLogic.getSuggestedProgramGroup());
            this.shortcutPanelLogic.setUserType(2);
        } else if (eventSource.equals(this.defaultButton)) {
            if (this.groupList != null && this.groupList.getSelectionModel() != null) {
                this.groupList.getSelectionModel().clearSelection();
            }
            this.programGroup.setText(this.shortcutPanelLogic.getSuggestedProgramGroup());
        } else if (eventSource.equals(this.saveButton)) {
            this.saveToFile();
        } else if (eventSource.equals(this.createShortcuts)) {
            boolean create = this.createShortcuts.isSelected();
            if (this.groupList != null) {
                this.groupList.setEnabled(create);
            }
            this.programGroup.setEnabled(create);
            this.currentUser.setEnabled(create);
            this.defaultButton.setEnabled(create);
            if (this.allowDesktopShortcut != null) {
                this.allowDesktopShortcut.setEnabled(create);
            }
            if (this.isRootUser) {
                this.allUsers.setEnabled(create);
            }
        }
    }

    @Override
    public boolean isValidated() {
        this.shortcutPanelLogic.setGroupName(this.programGroup.getText());
        if (this.allowDesktopShortcut != null) {
            this.shortcutPanelLogic.setCreateDesktopShortcuts(this.allowDesktopShortcut.isSelected());
        }
        this.shortcutPanelLogic.setCreateShortcuts(this.createShortcuts.isSelected());
        if (this.shortcutPanelLogic.isCreateShortcutsImmediately()) {
            try {
                this.shortcutPanelLogic.createAndRegisterShortcuts();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return true;
    }

    @Override
    public void panelActivate() {
        if (this.shortcutPanelLogic != null) {
            if (!this.initialised) {
                this.initialised = true;
                if (this.shortcutPanelLogic.isSupported()) {
                    this.isRootUser = this.shortcutPanelLogic.initUserType();
                    this.buildUI(this.shortcutPanelLogic.getProgramsFolder(this.shortcutPanelLogic.getUserType()));
                } else if (this.shortcutPanelLogic.isSkipIfNotSupported()) {
                    this.parent.skipPanel();
                } else {
                    this.buildAlternateUI();
                }
            }
        } else {
            this.parent.skipPanel();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (this.programGroup == null) {
            return;
        }
        String value = "";
        try {
            value = (String)this.groupList.getSelectedValue();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (value == null) {
            value = "";
        }
        this.programGroup.setText(value + File.separator + this.shortcutPanelLogic.getSuggestedProgramGroup());
    }

    private void buildUI(File programsFolder) {
        int line = 0;
        int col = 0;
        this.constraints.insets = new Insets(10, 10, 0, 0);
        this.createShortcuts = new JCheckBox(this.shortcutPanelLogic.getCreateShortcutsPrompt(), true);
        this.createShortcuts.setName(GuiId.SHORTCUT_CREATE_CHECK_BOX.id);
        this.createShortcuts.addActionListener(this);
        this.constraints.gridx = col;
        this.constraints.gridy = line + 1;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 2;
        this.constraints.anchor = 18;
        this.layout.addLayoutComponent(this.createShortcuts, this.constraints);
        this.add(this.createShortcuts);
        this.constraints.insets = new Insets(0, 10, 0, 0);
        if (this.shortcutPanelLogic.hasDesktopShortcuts()) {
            boolean initialAllowedFlag = this.shortcutPanelLogic.isDesktopShortcutCheckboxSelected();
            this.allowDesktopShortcut = new JCheckBox(this.shortcutPanelLogic.getCreateDesktopShortcutsPrompt(), initialAllowedFlag);
            this.constraints.gridx = col;
            this.constraints.gridy = line + 2;
            this.constraints.gridwidth = 1;
            this.constraints.gridheight = 1;
            this.layout.addLayoutComponent(this.allowDesktopShortcut, this.constraints);
            this.add(this.allowDesktopShortcut);
        }
        JLabel listLabel = LabelFactory.create(this.getString("ShortcutPanel.regular.list"), 10);
        Platform platform = this.installData.getPlatform();
        if (platform.isA(Platform.Name.WINDOWS)) {
            this.constraints.gridx = col;
            this.constraints.gridy = line + 3;
            this.constraints.gridwidth = 1;
            this.constraints.gridheight = 1;
            this.constraints.insets = new Insets(10, 10, 0, 0);
            this.constraints.fill = 2;
            this.constraints.anchor = 18;
        } else {
            this.constraints.gridx = col;
            this.constraints.gridy = line + 4;
            this.constraints.gridwidth = 1;
            this.constraints.gridheight = 1;
            this.constraints.insets = new Insets(10, 10, 0, 0);
            this.constraints.fill = 2;
            this.constraints.anchor = 16;
        }
        this.layout.addLayoutComponent(listLabel, this.constraints);
        this.add(listLabel);
        Vector<String> dirEntries = new Vector<String>();
        File[] entries = programsFolder.listFiles();
        if (entries != null && !platform.isA(Platform.Name.UNIX)) {
            for (File entry : entries) {
                if (!entry.isDirectory()) continue;
                dirEntries.add(entry.getName());
            }
        }
        if (platform.isA(Platform.Name.WINDOWS)) {
            if (this.groupList == null) {
                this.groupList = new JList();
            }
            this.groupList = this.addList(dirEntries, 0, this.groupList, col, line + 4, 1, 1, 1);
        }
        if (this.shortcutPanelLogic.isSupportingMultipleUsers()) {
            boolean rUserFlag = !this.shortcutPanelLogic.isDefaultCurrentUserFlag() && this.isRootUser;
            JPanel usersPanel = new JPanel(new GridLayout(2, 1));
            ButtonGroup usersGroup = new ButtonGroup();
            this.currentUser = new JRadioButton(this.shortcutPanelLogic.getCreateForCurrentUserPrompt(), !rUserFlag);
            this.currentUser.addActionListener(this);
            usersGroup.add(this.currentUser);
            usersPanel.add(this.currentUser);
            this.allUsers = new JRadioButton(this.shortcutPanelLogic.getCreateForAllUsersPrompt(), rUserFlag);
            logger.fine("allUsers.setEnabled(), am I root?: " + this.isRootUser);
            this.allUsers.setEnabled(this.isRootUser);
            this.allUsers.addActionListener(this);
            usersGroup.add(this.allUsers);
            usersPanel.add(this.allUsers);
            TitledBorder border = new TitledBorder(new EmptyBorder(2, 2, 2, 2), this.shortcutPanelLogic.getCreateForUserPrompt());
            usersPanel.setBorder(border);
            if (platform.isA(Platform.Name.WINDOWS)) {
                this.constraints.gridx = col + 1;
                this.constraints.gridy = line + 4;
                this.constraints.gridwidth = 1;
                this.constraints.gridheight = 1;
            } else {
                this.constraints.insets = new Insets(10, 10, 20, 0);
                this.constraints.gridx = col;
                this.constraints.gridy = line + 4;
                this.constraints.gridwidth = 2;
                this.constraints.gridheight = 1;
                this.constraints.anchor = 13;
            }
            this.constraints.fill = 2;
            this.layout.addLayoutComponent(usersPanel, this.constraints);
            this.add(usersPanel);
        }
        String suggestedProgramGroup = this.shortcutPanelLogic.getSuggestedProgramGroup();
        this.programGroup = new JTextField(suggestedProgramGroup, 40);
        this.constraints.gridx = col;
        this.constraints.gridy = line + 5;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 2;
        this.layout.addLayoutComponent(this.programGroup, this.constraints);
        this.add(this.programGroup);
        this.defaultButton = ButtonFactory.createButton(this.getString("ShortcutPanel.regular.default"), this.installData.buttonsHColor);
        this.defaultButton.addActionListener(this);
        this.constraints.gridx = col + 1;
        this.constraints.gridy = line + 5;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 2;
        this.layout.addLayoutComponent(this.defaultButton, this.constraints);
        this.add(this.defaultButton);
        if (suggestedProgramGroup == null || "".equals(suggestedProgramGroup)) {
            this.programGroup.setVisible(false);
            this.defaultButton.setVisible(false);
            listLabel.setVisible(false);
        }
    }

    private JList addList(Vector<String> Entries, int ListModel2, JList aJList, int aGridx, int aGridy, int aGridwidth, int aGridheight, int aFill) {
        if (aJList == null) {
            aJList = new JList<String>(Entries);
        } else {
            aJList.setListData(Entries);
        }
        aJList.setSelectionMode(ListModel2);
        aJList.getSelectionModel().addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(aJList);
        this.constraints.gridx = aGridx;
        this.constraints.gridy = aGridy;
        this.constraints.gridwidth = aGridwidth;
        this.constraints.gridheight = aGridheight;
        this.constraints.weightx = 2.0;
        this.constraints.weighty = 1.5;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.constraints.fill = aFill;
        this.layout.addLayoutComponent(scrollPane, this.constraints);
        this.add(scrollPane);
        return aJList;
    }

    private void buildAlternateUI() {
        this.layout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.setLayout(this.layout);
        MultiLineLabel apologyLabel = new MultiLineLabel(this.getString("ShortcutPanel.alternate.apology"), 0, 0);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.layout.addLayoutComponent(apologyLabel, this.constraints);
        this.add(apologyLabel);
        MultiLineLabel listLabel = new MultiLineLabel(this.getString("ShortcutPanel.alternate.targetsLabel"), 0, 0);
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.layout.addLayoutComponent(listLabel, this.constraints);
        this.add(listLabel);
        Vector<String> targets = new Vector<String>();
        if (this.shortcutPanelLogic != null) {
            targets.addAll(this.shortcutPanelLogic.getTargets());
        }
        JList targetList = new JList(targets);
        JScrollPane scrollPane = new JScrollPane(targetList);
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.fill = 1;
        this.layout.addLayoutComponent(scrollPane, this.constraints);
        this.add(scrollPane);
        MultiLineLabel fileExplanation = new MultiLineLabel(this.getString("ShortcutPanel.alternate.textFileExplanation"), 0, 0);
        this.constraints.gridx = 0;
        this.constraints.gridy = 3;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.fill = 2;
        this.layout.addLayoutComponent(fileExplanation, this.constraints);
        this.add(fileExplanation);
        this.saveButton = ButtonFactory.createButton(this.getString("ShortcutPanel.alternate.saveButton"), this.installData.buttonsHColor);
        this.saveButton.addActionListener(this);
        this.constraints.gridx = 0;
        this.constraints.gridy = 4;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.layout.addLayoutComponent(this.saveButton, this.constraints);
        this.add(this.saveButton);
    }

    @Override
    public Dimension getSize() {
        Dimension size = this.getParent().getSize();
        Insets insets = this.getInsets();
        Border border = this.getBorder();
        Insets borderInsets = new Insets(0, 0, 0, 0);
        if (border != null) {
            borderInsets = border.getBorderInsets(this);
        }
        size.height = size.height - insets.top - insets.bottom - borderInsets.top - borderInsets.bottom - 50;
        size.width = size.width - insets.left - insets.right - borderInsets.left - borderInsets.right - 50;
        return size;
    }

    private void saveToFile() {
        JFileChooser fileDialog = new JFileChooser(this.installData.getInstallPath());
        fileDialog.setSelectedFile(new File(TEXT_FILE_NAME));
        if (fileDialog.showSaveDialog(this) != 0) {
            return;
        }
        File file = fileDialog.getSelectedFile();
        this.shortcutPanelLogic.saveToFile(file);
    }

    @Override
    public void makeXMLData(IXMLElement panelRoot) {
        List<IXMLElement> autoinstallXMLData = this.shortcutPanelLogic.getAutoinstallXMLData(panelRoot);
        for (IXMLElement element : autoinstallXMLData) {
            panelRoot.addChild(element);
        }
    }
}

