/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.shortcut;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.event.InstallerListeners;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.panels.shortcut.ShortcutPanelLogic;
import com.izforge.izpack.util.Console;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.PlatformModelMatcher;
import com.izforge.izpack.util.TargetFactory;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShortcutConsolePanel
extends AbstractConsolePanel {
    private final ShortcutPanelLogic logic;
    private final Prompt prompt;
    private static final Logger logger = Logger.getLogger(ShortcutConsolePanel.class.getName());

    public ShortcutConsolePanel(InstallData installData, Resources resources, UninstallData uninstallData, Housekeeper housekeeper, TargetFactory factory, InstallerListeners listeners, PlatformModelMatcher matcher, Prompt prompt, PanelView<Console> panel) {
        super(panel);
        ShortcutPanelLogic logic = null;
        try {
            logic = new ShortcutPanelLogic(installData, resources, uninstallData, housekeeper, factory, listeners, matcher);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to initialise shortcuts: " + exception.getMessage(), exception);
        }
        this.logic = logic;
        this.prompt = prompt;
    }

    @Override
    public boolean run(InstallData installData, Properties properties) {
        boolean result = false;
        if (this.logic != null && !this.logic.isSupported() && this.logic.isSkipIfNotSupported()) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        boolean result = true;
        if (this.logic != null) {
            if (this.logic.isSupported()) {
                if (this.prompt.confirm(Prompt.Type.QUESTION, this.logic.getCreateShortcutsPrompt(), Prompt.Options.YES_NO) == Prompt.Option.YES) {
                    result = this.createShortcuts(installData, console);
                }
            } else if (!this.logic.isSkipIfNotSupported()) {
                Messages messages = installData.getMessages();
                String message = messages.get("ShortcutPanel.alternate.apology", new Object[0]);
                this.prompt.message(Prompt.Type.INFORMATION, message);
            }
        }
        return result;
    }

    private boolean createShortcuts(InstallData installData, Console console) {
        boolean selected;
        Messages messages = installData.getMessages();
        boolean isAdmin = this.logic.initUserType();
        boolean createDesktopShortcuts = false;
        boolean allUsers = false;
        String programGroup = this.logic.getSuggestedProgramGroup();
        if (this.logic.hasDesktopShortcuts()) {
            selected = this.logic.isDesktopShortcutCheckboxSelected();
            if (this.prompt.confirm(Prompt.Type.QUESTION, this.logic.getCreateDesktopShortcutsPrompt(), Prompt.Options.YES_NO, selected ? Prompt.Option.YES : Prompt.Option.NO) == Prompt.Option.YES) {
                createDesktopShortcuts = true;
            }
        }
        if (isAdmin && this.logic.isSupportingMultipleUsers()) {
            selected = !this.logic.isDefaultCurrentUserFlag();
            String message = this.logic.getCreateForUserPrompt() + " " + this.logic.getCreateForAllUsersPrompt();
            if (this.prompt.confirm(Prompt.Type.QUESTION, message, Prompt.Options.YES_NO, selected ? Prompt.Option.YES : Prompt.Option.NO) == Prompt.Option.YES) {
                allUsers = true;
            }
        }
        if (programGroup != null && "".equals(programGroup) && (programGroup = console.prompt(messages.get("ShortcutPanel.regular.list", new Object[0]), null)) == null) {
            return false;
        }
        this.logic.setGroupName(programGroup);
        this.logic.setCreateDesktopShortcuts(createDesktopShortcuts);
        this.logic.setCreateShortcuts(true);
        this.logic.setUserType(allUsers ? 2 : 1);
        if (this.logic.isCreateShortcutsImmediately()) {
            try {
                this.logic.createAndRegisterShortcuts();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return true;
    }
}

