/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.path;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.panels.path.PathSelectionPanel;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.Platforms;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PathInputPanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3257566217698292531L;
    private static final transient Logger logger = Logger.getLogger(PathInputPanel.class.getName());
    protected boolean mustExist = false;
    protected String[] existFiles = null;
    protected PathSelectionPanel pathSelectionPanel;
    protected String emptyTargetMsg = this.getI18nStringForClass("empty_target", "TargetPanel");
    protected String warnMsg = this.getI18nStringForClass("warn", "TargetPanel");

    public PathInputPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        super(panel, parent, installData, new IzPanelLayout(log), resources);
        String introText = this.getI18nStringForClass("extendedIntro", "PathInputPanel");
        if ((introText == null || introText.endsWith("extendedIntro") || introText.indexOf(36) > -1) && ((introText = this.getI18nStringForClass("intro", "PathInputPanel")) == null || introText.endsWith("intro"))) {
            introText = "";
        }
        this.add(this.createMultiLineLabel(introText));
        this.add(IzPanelLayout.createParagraphGap());
        this.add((Component)this.createLabel("info", "TargetPanel", "open", 2, true), "nextLine");
        this.pathSelectionPanel = new PathSelectionPanel(this, installData, log);
        this.add((Component)this.pathSelectionPanel, "nextLine");
        this.createLayoutBottom();
        this.getLayoutHelper().completeLayout();
    }

    public String getPath() {
        String chosenPath = this.pathSelectionPanel.getPath();
        if (chosenPath == null) {
            chosenPath = "";
        }
        if (chosenPath.startsWith("~") && this.installData.getPlatform().isA(Platform.Name.UNIX)) {
            String home = System.getProperty("user.home");
            chosenPath = home + chosenPath.substring(1);
        }
        return chosenPath;
    }

    public void createLayoutBottom() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.pathSelectionPanel.getPathInputField()) {
            this.parent.navigateNext();
        }
    }

    @Override
    public boolean isValidated() {
        String path = this.getPath();
        if (path.length() == 0 && !this.checkEmptyPath()) {
            return false;
        }
        File file = new File(path).getAbsoluteFile();
        this.pathSelectionPanel.setPath(file.toString());
        if (this.isMustExist()) {
            if (!this.checkExists(file) || !this.pathIsValid() || this.modifyInstallation() && !this.checkInstallationInformation(file)) {
                return false;
            }
        } else {
            if (!this.checkWritable(file)) {
                return false;
            }
            if (file.exists() ? !this.checkOverwrite(file) : !this.checkCreateDirectory(file)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void panelActivate() {
        super.panelActivate();
        if (this.modifyInstallation()) {
            this.mustExist = true;
        }
    }

    public boolean isMustExist() {
        return this.mustExist;
    }

    public void setMustExist(boolean mustExist) {
        this.mustExist = mustExist;
    }

    public String[] getExistFiles() {
        return this.existFiles;
    }

    public void setExistFiles(String[] strings) {
        this.existFiles = strings;
    }

    public boolean isWriteable() {
        String path = this.getPath();
        return this.isWriteable(new File(path));
    }

    protected boolean isWriteable(File path) {
        boolean result = false;
        File existParent = IoHelper.existingParent(path);
        if (existParent != null) {
            if (this.installData.getPlatform().isA(Platforms.WINDOWS)) {
                try {
                    File tmpFile = File.createTempFile("izWrTe", ".tmp", existParent);
                    result = true;
                    if (!tmpFile.delete()) {
                        tmpFile.deleteOnExit();
                    }
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, e.toString(), e);
                }
            } else {
                result = existParent.canWrite();
            }
        }
        return result;
    }

    protected boolean checkExists(File file) {
        if (!file.exists()) {
            this.emitError(this.getString("installer.error"), this.getString(this.getI18nStringForClass("required", "PathInputPanel")));
            return false;
        }
        return true;
    }

    protected boolean checkEmptyPath() {
        if (this.isMustExist()) {
            this.emitError(this.getString("installer.error"), this.getI18nStringForClass("required", "PathInputPanel"));
            return false;
        }
        return this.emitWarning(this.getString("installer.warning"), this.emptyTargetMsg);
    }

    protected boolean checkWritable(File file) {
        if (!this.isWriteable(file)) {
            this.emitError(this.getString("installer.error"), this.getI18nStringForClass("notwritable", "TargetPanel"));
            return false;
        }
        return true;
    }

    protected boolean checkInstallationInformation(File path) {
        File info = new File(path, ".installationinformation");
        if (!info.exists()) {
            this.emitError(this.getString("installer.error"), this.getString("PathInputPanel.required.forModificationInstallation"));
            return false;
        }
        return true;
    }

    protected boolean checkRequiredFilesExist(String path) {
        if (this.existFiles == null || path == null || path.isEmpty()) {
            return true;
        }
        for (String existFile : this.existFiles) {
            File file = new File(path, existFile).getAbsoluteFile();
            if (file.exists()) continue;
            this.emitError(this.getString("installer.error"), this.getString(this.getI18nStringForClass("notValid", "PathInputPanel")));
            return false;
        }
        return true;
    }

    protected boolean checkCreateDirectory(File dir) {
        boolean result = true;
        String show = this.installData.getVariable("ShowCreateDirectoryMessage");
        if (show == null || Boolean.getBoolean(show)) {
            result = this.emitNotificationFeedback(this.getI18nStringForClass("createdir", "TargetPanel") + "\n" + dir);
        }
        return result;
    }

    protected boolean checkOverwrite(File dir) {
        return this.askQuestion(this.getString("installer.warning"), this.warnMsg, 37, 47) == 47;
    }

    protected boolean modifyInstallation() {
        return Boolean.valueOf(this.installData.getVariable("modify.izpack.install"));
    }

    protected boolean pathIsValid() {
        return this.checkRequiredFilesExist(this.getPath());
    }
}

