/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.packs;

import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackColor;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.util.PackHelper;
import com.izforge.izpack.panels.packs.PacksPanelInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;

public class PacksModel
extends AbstractTableModel {
    private static final long serialVersionUID = 3258128076746733110L;
    private static final transient Logger logger = Logger.getLogger(PacksModel.class.getName());
    private static final String INITAL_PACKSELECTION = "initial.pack.selection";
    private List<Pack> packs;
    private List<Pack> hiddenPacks;
    private List<Pack> packsToInstall;
    private Map<String, Pack> installedpacks;
    private boolean modifyinstallation;
    private PacksPanelInterface panel;
    private Messages messages;
    private int[] checkValues;
    Map<String, Pack> namesObj;
    Map<String, Integer> namesPos;
    private RulesEngine rules;
    private Variables variables;
    private GUIInstallData idata;

    public PacksModel(PacksPanelInterface panel, GUIInstallData idata, RulesEngine rules) {
        this.idata = idata;
        this.modifyinstallation = Boolean.valueOf(idata.getVariable("modify.izpack.install"));
        this.installedpacks = new HashMap<String, Pack>();
        if (this.modifyinstallation) {
            try {
                FileInputStream fin = new FileInputStream(new File(idata.getInstallPath() + File.separator + ".installationinformation"));
                ObjectInputStream oin = new ObjectInputStream(fin);
                List packsinstalled = (List)oin.readObject();
                for (Pack installedpack : packsinstalled) {
                    this.installedpacks.put(installedpack.getName(), installedpack);
                }
                this.removeAlreadyInstalledPacks(idata.getSelectedPacks());
                logger.fine("Found " + packsinstalled.size() + " installed packs");
                Properties variables = (Properties)oin.readObject();
                for (Object key : variables.keySet()) {
                    idata.setVariable((String)key, (String)variables.get(key));
                }
                fin.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.rules = rules;
        this.packs = new ArrayList<Pack>();
        this.hiddenPacks = new ArrayList<Pack>();
        for (Pack availablePack : idata.getAvailablePacks()) {
            if (!availablePack.isHidden()) {
                this.packs.add(availablePack);
                continue;
            }
            this.hiddenPacks.add(availablePack);
        }
        this.packsToInstall = idata.getSelectedPacks();
        this.panel = panel;
        this.variables = idata.getVariables();
        this.variables.set(INITAL_PACKSELECTION, Boolean.toString(true));
        this.messages = panel.getMessages();
        this.checkValues = new int[this.packs.size()];
        this.reverseDeps();
        this.initvalues();
        this.updateConditions(true);
        this.refreshPacksToInstall();
        this.variables.set(INITAL_PACKSELECTION, Boolean.toString(false));
    }

    public Pack getPackAtRow(int row) {
        return this.packs.get(row);
    }

    private void removeAlreadyInstalledPacks(List<Pack> selectedpacks) {
        ArrayList<Pack> removepacks = new ArrayList<Pack>();
        for (Pack selectedpack : selectedpacks) {
            if (!this.installedpacks.containsKey(selectedpack.getName())) continue;
            removepacks.add(selectedpack);
        }
        for (Pack removepack : removepacks) {
            selectedpacks.remove(removepack);
        }
    }

    public void updateConditions() {
        this.updateConditions(false);
    }

    private void updateConditions(boolean initial) {
        boolean changes = true;
        while (changes) {
            changes = false;
            for (Pack pack : this.packs) {
                int pos = this.getPos(pack.getName());
                logger.fine("Conditions fulfilled for: " + pack.getName() + "?");
                if (this.rules.canInstallPack(pack.getName(), this.variables)) continue;
                logger.fine("no");
                if (this.rules.canInstallPackOptional(pack.getName(), this.variables)) {
                    logger.fine("optional");
                    logger.fine(pack.getName() + " can be installed optionally.");
                    if (!initial || this.checkValues[pos] == 0) continue;
                    this.checkValues[pos] = 0;
                    changes = true;
                    break;
                }
                logger.fine("Pack" + pack.getName() + " cannot be installed");
                if (this.checkValues[pos] == -2) continue;
                this.checkValues[pos] = -2;
                changes = true;
                break;
            }
            this.refreshPacksToInstall();
        }
    }

    private void reverseDeps() {
        this.namesObj = new HashMap<String, Pack>();
        for (Pack pack : this.packs) {
            this.namesObj.put(pack.getName(), pack);
        }
        for (Pack pack : this.packs) {
            List<String> deps = pack.getDependencies();
            for (int j = 0; deps != null && j < deps.size(); ++j) {
                String name = deps.get(j);
                Pack parent = this.namesObj.get(name);
                parent.addDependant(pack.getName());
            }
        }
    }

    private void initvalues() {
        Pack pack2;
        int i;
        this.namesPos = new HashMap<String, Integer>();
        for (i = 0; i < this.packs.size(); ++i) {
            pack2 = this.packs.get(i);
            this.namesPos.put(pack2.getName(), i);
        }
        for (i = 0; i < this.packs.size(); ++i) {
            pack2 = this.packs.get(i);
            if (!this.packsToInstall.contains(pack2)) continue;
            this.checkValues[i] = 1;
        }
        for (i = 0; i < this.packs.size(); ++i) {
            pack2 = this.packs.get(i);
            if (this.checkValues[i] == 0) {
                List<String> deps = pack2.getDependants();
                for (int j = 0; deps != null && j < deps.size(); ++j) {
                    String name = deps.get(j);
                    int pos = this.getPos(name);
                    this.checkValues[pos] = -2;
                }
            }
            if (this.checkValues[i] <= 0 || pack2.getExcludeGroup() == null) continue;
            for (int q = 0; q < this.packs.size(); ++q) {
                if (q == i) continue;
                Pack otherpack = this.packs.get(q);
                if (!pack2.getExcludeGroup().equals(otherpack.getExcludeGroup()) || this.checkValues[q] != 1) continue;
                this.checkValues[q] = 0;
            }
        }
        for (Pack pack2 : this.packs) {
            if (!pack2.isRequired()) continue;
            this.propRequirement(pack2.getName());
        }
        this.refreshPacksToInstall();
    }

    private void propRequirement(String name) {
        int pos = this.getPos(name);
        this.checkValues[pos] = -1;
        List<String> deps = this.packs.get(pos).getDependencies();
        for (int i = 0; deps != null && i < deps.size(); ++i) {
            String s = deps.get(i);
            this.propRequirement(s);
        }
    }

    private int getPos(String name) {
        return this.namesPos.get(name);
    }

    @Override
    public int getRowCount() {
        return this.packs.size();
    }

    @Override
    public int getColumnCount() {
        boolean doNotShowPackSize = Boolean.parseBoolean(this.idata.guiPrefs.modifier.get("doNotShowPackSizeColumn"));
        int result = !doNotShowPackSize ? 3 : 2;
        return result;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Integer.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.checkValues[rowIndex] < 0) {
            return false;
        }
        return columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Pack pack = this.packs.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return this.checkValues[rowIndex];
            }
            case 1: {
                return PackHelper.getPackName(pack, this.messages);
            }
            case 2: {
                return Pack.toByteUnitsString(pack.getSize());
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0 && aValue instanceof Integer) {
            boolean added;
            Pack pack = this.packs.get(rowIndex);
            if ((Integer)aValue == 1) {
                added = true;
                String name = pack.getName();
                if (this.rules.canInstallPack(name, this.variables) || this.rules.canInstallPackOptional(name, this.variables)) {
                    this.checkValues[rowIndex] = pack.isRequired() ? -1 : 1;
                }
            } else {
                added = false;
                this.checkValues[rowIndex] = 0;
            }
            this.updateExcludes(rowIndex);
            this.updateDeps();
            if (added) {
                if (this.panel.getDebugger() != null) {
                    this.panel.getDebugger().packSelectionChanged("after adding pack " + pack.getName());
                }
                this.packsToInstall.add(pack);
            } else {
                if (this.panel.getDebugger() != null) {
                    this.panel.getDebugger().packSelectionChanged("after removing pack " + pack.getName());
                }
                this.packsToInstall.remove(pack);
            }
            this.updateConditions();
            if (added) {
                this.packsToInstall.remove(pack);
            } else {
                this.packsToInstall.add(pack);
            }
            this.refreshPacksToInstall();
            this.updateBytes();
            this.fireTableDataChanged();
            this.panel.showSpaceRequired();
        }
    }

    private void refreshPacksToInstall() {
        Pack pack;
        int i;
        this.packsToInstall.clear();
        for (i = 0; i < this.packs.size(); ++i) {
            pack = this.packs.get(i);
            if (Math.abs(this.checkValues[i]) != 1 || this.installedpacks.containsKey(pack.getName())) continue;
            this.packsToInstall.add(pack);
        }
        for (i = 0; i < this.packs.size(); ++i) {
            pack = this.packs.get(i);
            if (!this.installedpacks.containsKey(pack.getName())) continue;
            this.checkValues[i] = -3;
        }
        for (Pack hiddenpack : this.hiddenPacks) {
            if (!this.rules.canInstallPack(hiddenpack.getName(), this.variables)) continue;
            this.packsToInstall.add(hiddenpack);
        }
    }

    private void updateDeps() {
        int i;
        int[] statusArray = new int[this.packs.size()];
        for (i = 0; i < statusArray.length; ++i) {
            statusArray[i] = 0;
        }
        this.dfs(statusArray);
        for (i = 0; i < statusArray.length; ++i) {
            if (statusArray[i] == 0 && this.checkValues[i] < 0) {
                int n = i;
                this.checkValues[n] = this.checkValues[n] + 2;
            }
            if (statusArray[i] != 1 || this.checkValues[i] < 0) continue;
            this.checkValues[i] = -2;
        }
        for (Pack pack : this.packs) {
            String name;
            if (!pack.isRequired() || !this.rules.canInstallPack(name = pack.getName(), this.variables) && this.rules.canInstallPackOptional(name, this.variables)) continue;
            this.propRequirement(name);
        }
    }

    private void updateExcludes(int rowindex) {
        int value = this.checkValues[rowindex];
        Pack pack = this.packs.get(rowindex);
        if (value > 0 && pack.getExcludeGroup() != null) {
            for (int q = 0; q < this.packs.size(); ++q) {
                if (rowindex == q) continue;
                Pack otherpack = this.packs.get(q);
                String name1 = otherpack.getExcludeGroup();
                String name2 = pack.getExcludeGroup();
                if (!name2.equals(name1) || this.checkValues[q] != 1) continue;
                this.checkValues[q] = 0;
            }
        }
    }

    private void updateBytes() {
        long bytes = 0L;
        for (int q = 0; q < this.packs.size(); ++q) {
            if (Math.abs(this.checkValues[q]) != 1) continue;
            Pack pack = this.packs.get(q);
            bytes += pack.getSize();
        }
        for (Pack hidden : this.hiddenPacks) {
            if (!this.rules.canInstallPack(hidden.getName(), this.variables)) continue;
            bytes += hidden.getSize();
        }
        this.panel.setBytes(bytes);
    }

    private int dfs(int[] status) {
        HashMap<String, PackColor> colours = new HashMap<String, PackColor>();
        for (int i = 0; i < this.packs.size(); ++i) {
            boolean wipe;
            for (Pack pack : this.packs) {
                colours.put(pack.getName(), PackColor.WHITE);
            }
            Pack pack = this.packs.get(i);
            if (this.dfsVisit(pack, status, wipe = false, colours) == 0) continue;
            return -1;
        }
        return 0;
    }

    private int dfsVisit(Pack u, int[] status, boolean wipe, Map<String, PackColor> colours) {
        List<String> deps;
        colours.put(u.getName(), PackColor.GREY);
        int check = this.checkValues[this.getPos(u.getName())];
        if (Math.abs(check) != 1) {
            wipe = true;
        }
        if ((deps = u.getDependants()) != null) {
            for (String name : deps) {
                int result;
                Pack v = this.namesObj.get(name);
                if (wipe) {
                    status[this.getPos((String)v.getName())] = 1;
                }
                if (colours.get(v.getName()) != PackColor.WHITE || (result = this.dfsVisit(v, status, wipe, colours)) == 0) continue;
                return result;
            }
        }
        colours.put(u.getName(), PackColor.BLACK);
        return 0;
    }

    public Map<String, Pack> getInstalledpacks() {
        return this.installedpacks;
    }

    public boolean isModifyinstallation() {
        return this.modifyinstallation;
    }
}

