/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.merge.jar;

import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.exception.MergeException;
import com.izforge.izpack.merge.AbstractMerge;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.IoHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.zip.ZipOutputStream;

public class JarMerge
extends AbstractMerge {
    private String jarPath;
    private String regexp;
    private String destination;

    public JarMerge(URL resource, String jarPath, Map<OutputStream, List<String>> mergeContent) {
        this.jarPath = jarPath;
        this.mergeContent = mergeContent;
        this.destination = FileUtil.convertUrlToFilePath(resource).replaceAll(this.jarPath, "").replaceAll("file:", "").replaceAll("!/?", "").replaceAll("//", "/");
        StringBuilder builder = new StringBuilder(this.destination.replace("$", "\\$"));
        if (this.destination.endsWith("/")) {
            builder.append("+(.*)");
        } else {
            builder.append("/*(.*)");
        }
        this.regexp = builder.toString();
    }

    public JarMerge(String jarPath, String pathInsideJar, String destination, Map<OutputStream, List<String>> mergeContent) {
        this.jarPath = jarPath;
        this.destination = destination;
        this.mergeContent = mergeContent;
        StringBuilder builder = new StringBuilder().append(pathInsideJar);
        if (pathInsideJar.endsWith("/")) {
            builder.append("+(.*)");
        } else {
            builder.append("/*(.*)");
        }
        this.regexp = builder.toString();
    }

    @Override
    public File find(FileFilter fileFilter) {
        try {
            ArrayList<String> fileNameInZip = this.getFileNameInJar();
            for (String fileName : fileNameInZip) {
                File file = new File(this.jarPath + "!/" + fileName);
                if (!fileFilter.accept(file)) continue;
                return file;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public List<File> recursivelyListFiles(FileFilter fileFilter) {
        try {
            ArrayList<String> fileNameInZip = this.getFileNameInJar();
            ArrayList<File> result = new ArrayList<File>();
            ArrayList<File> filteredResult = new ArrayList<File>();
            for (String fileName : fileNameInZip) {
                result.add(new File(this.jarPath + "!" + fileName));
            }
            for (File file : result) {
                if (!fileFilter.accept(file)) continue;
                filteredResult.add(file);
            }
            return filteredResult;
        }
        catch (IOException e) {
            throw new MergeException(e);
        }
    }

    public ArrayList<String> getFileNameInJar() throws IOException {
        JarFile jarFile = new JarFile(this.jarPath);
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            arrayList.add(jarEntry.getName());
        }
        return arrayList;
    }

    @Override
    public void merge(java.util.zip.ZipOutputStream outputStream) {
        this.mergeImpl(outputStream);
    }

    @Override
    public void merge(ZipOutputStream outJar) {
        this.mergeImpl(outJar);
    }

    private void mergeImpl(OutputStream outputStream) {
        Pattern pattern = Pattern.compile(this.regexp);
        List<String> mergeList = this.getMergeList(outputStream);
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(this.jarPath);
            Enumeration<JarEntry> jarFileEntries = jarFile.entries();
            while (jarFileEntries.hasMoreElements()) {
                Matcher matcher;
                JarEntry jarEntry = jarFileEntries.nextElement();
                if (this.isManifest(jarEntry.getName()) || !(matcher = pattern.matcher(jarEntry.getName())).matches() || this.isSignature(jarEntry.getName()) || mergeList.contains(jarEntry.getName())) continue;
                mergeList.add(jarEntry.getName());
                String matchFile = matcher.group(1);
                StringBuilder dest = new StringBuilder(this.destination);
                if (matchFile != null && matchFile.length() > 0) {
                    if (dest.length() > 0 && dest.charAt(dest.length() - 1) != '/') {
                        dest.append('/');
                    }
                    dest.append(matchFile);
                }
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                if (outputStream instanceof ZipOutputStream) {
                    IoHelper.copyStreamToJar(inputStream, (ZipOutputStream)outputStream, dest.toString().replaceAll("//", "/"), jarEntry.getTime());
                    continue;
                }
                if (!(outputStream instanceof java.util.zip.ZipOutputStream)) continue;
                IoHelper.copyStreamToJar(inputStream, (java.util.zip.ZipOutputStream)outputStream, dest.toString().replaceAll("//", "/"), jarEntry.getTime());
            }
        }
        catch (IOException e) {
            throw new IzPackException(e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public String toString() {
        return "JarMerge{jarPath='" + this.jarPath + '\'' + ", regexp='" + this.regexp + '\'' + ", destination='" + this.destination + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JarMerge jarMerge = (JarMerge)o;
        return this.jarPath != null ? this.jarPath.equals(jarMerge.jarPath) : jarMerge.jarPath == null;
    }

    public int hashCode() {
        return this.jarPath != null ? this.jarPath.hashCode() : 0;
    }

    private boolean isSignature(String name) {
        return name.matches("/META-INF/.*\\.(SF|DSA|RSA)") || name.matches("/META-INF/SIG-.*");
    }

    private boolean isManifest(String name) {
        return name.equals("META-INF/MANIFEST.MF");
    }
}

