/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.container.impl;

import com.izforge.izpack.api.container.Container;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.ContainerException;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.resource.Locales;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.container.AbstractContainer;
import com.izforge.izpack.core.container.PlatformProvider;
import com.izforge.izpack.core.data.DefaultVariables;
import com.izforge.izpack.core.factory.DefaultObjectFactory;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.core.resource.ResourceManager;
import com.izforge.izpack.core.rules.ConditionContainer;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.installer.base.InstallDataConfiguratorWithRules;
import com.izforge.izpack.installer.container.impl.CustomDataLoader;
import com.izforge.izpack.installer.container.provider.LocalesProvider;
import com.izforge.izpack.installer.container.provider.RulesProvider;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.installer.event.InstallerListeners;
import com.izforge.izpack.installer.event.ProgressNotifiersImpl;
import com.izforge.izpack.installer.requirement.InstallerRequirementChecker;
import com.izforge.izpack.installer.requirement.JDKChecker;
import com.izforge.izpack.installer.requirement.JavaVersionChecker;
import com.izforge.izpack.installer.requirement.LangPackChecker;
import com.izforge.izpack.installer.requirement.LockFileChecker;
import com.izforge.izpack.installer.requirement.RequirementsChecker;
import com.izforge.izpack.installer.unpacker.FileQueueFactory;
import com.izforge.izpack.installer.unpacker.IUnpacker;
import com.izforge.izpack.merge.MergeManagerImpl;
import com.izforge.izpack.merge.resolve.MergeableResolver;
import com.izforge.izpack.merge.resolve.PathResolver;
import com.izforge.izpack.util.DefaultTargetPlatformFactory;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.Librarian;
import com.izforge.izpack.util.PlatformModelMatcher;
import com.izforge.izpack.util.Platforms;
import com.izforge.izpack.util.TargetFactory;
import java.util.Properties;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.injectors.ProviderAdapter;
import org.picocontainer.parameters.ComponentParameter;

public abstract class InstallerContainer
extends AbstractContainer {
    public void setLocale(String code) {
        Locales locales = this.getComponent(Locales.class);
        locales.setLocale(code);
    }

    @Override
    protected void fillContainer(MutablePicoContainer container) {
        this.registerComponents(container);
        this.resolveComponents(container);
    }

    protected void registerComponents(MutablePicoContainer pico) {
        pico.addAdapter(new ProviderAdapter(new RulesProvider()));
        pico.addAdapter(new ProviderAdapter(new PlatformProvider()));
        pico.addAdapter(new ProviderAdapter(new LocalesProvider()));
        this.addComponent(InstallDataConfiguratorWithRules.class);
        this.addComponent(InstallerRequirementChecker.class);
        this.addComponent(JavaVersionChecker.class);
        this.addComponent(JDKChecker.class);
        this.addComponent(LangPackChecker.class);
        this.addComponent(RequirementsChecker.class);
        this.addComponent(LockFileChecker.class);
        this.addComponent(MergeManagerImpl.class);
        this.addComponent(UninstallData.class);
        this.addComponent(MutablePicoContainer.class, pico);
        this.addComponent(ConditionContainer.class);
        this.addComponent(Properties.class);
        this.addComponent(DefaultVariables.class);
        this.addComponent(ResourceManager.class);
        this.addComponent(UninstallDataWriter.class);
        this.addComponent(ProgressNotifiersImpl.class);
        this.addComponent(InstallerListeners.class);
        this.addComponent(CustomDataLoader.class);
        this.addComponent(Container.class, this);
        this.addComponent(RegistryDefaultHandler.class);
        this.addComponent(Housekeeper.class);
        this.addComponent(Librarian.class);
        this.addComponent(FileQueueFactory.class);
        this.addComponent(TargetFactory.class);
        this.addComponent(DefaultTargetPlatformFactory.class);
        this.addComponent(DefaultObjectFactory.class);
        this.addComponent(PathResolver.class);
        this.addComponent(MergeableResolver.class);
        this.addComponent(Platforms.class);
        this.addComponent(PlatformModelMatcher.class);
        pico.addComponent(VariableSubstitutor.class, VariableSubstitutorImpl.class, new ComponentParameter(DefaultVariables.class));
    }

    protected void resolveComponents(MutablePicoContainer pico) {
        InstallData installData = pico.getComponent(InstallData.class);
        String className = installData.getInfo().getUnpackerClassName();
        Class<IUnpacker> unpackerClass = this.getClass(className, IUnpacker.class);
        pico.addComponent(IUnpacker.class, unpackerClass, new Parameter[0]);
        CustomDataLoader customDataLoader = pico.getComponent(CustomDataLoader.class);
        try {
            customDataLoader.loadCustomData();
        }
        catch (InstallerException exception) {
            throw new ContainerException(exception);
        }
    }
}

