/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.console;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.util.Console;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public abstract class AbstractTextConsolePanel
extends AbstractConsolePanel {
    private static final Logger logger = Logger.getLogger(AbstractTextConsolePanel.class.getName());

    public AbstractTextConsolePanel(PanelView<Console> panel) {
        super(panel);
    }

    @Override
    public boolean run(InstallData installData, Properties properties) {
        return true;
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        boolean result;
        String text = this.getText();
        if (text != null) {
            result = this.paginateText(text, console);
        } else {
            logger.warning("No text to display");
            result = false;
        }
        return result && this.promptEndPanel(installData, console);
    }

    protected abstract String getText();

    protected boolean paginateText(String text, Console console) {
        boolean result = true;
        int lines = 22;
        int line = 0;
        StringTokenizer tokens = new StringTokenizer(text, "\n");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            console.println(token);
            if (++line < lines || !tokens.hasMoreTokens()) continue;
            if (!this.promptContinue(console)) {
                result = false;
                break;
            }
            line = 0;
        }
        return result;
    }

    protected boolean promptContinue(Console console) {
        String value = console.prompt("\nPress Enter to continue, X to exit", "x");
        console.println();
        return !value.equalsIgnoreCase("x");
    }

    protected String removeHTML(String text) {
        String result = "";
        if (text != null) {
            result = text.replaceAll("\r", " ");
            result = result.replaceAll("\t", "");
            result = result.replaceAll("( )+", " ");
            result = result.replaceAll("<( )*head([^>])*>", "<head>");
            result = result.replaceAll("(<( )*(/)( )*head( )*>)", "</head>");
            result = result.replaceAll("(<head>).*(</head>)", "");
            result = result.replaceAll("<( )*script([^>])*>", "<script>");
            result = result.replaceAll("(<( )*(/)( )*script( )*>)", "</script>");
            result = result.replaceAll("(<script>).*(</script>)", "");
            result = result.replaceAll("<( )*style([^>])*>", "<style>");
            result = result.replaceAll("(<( )*(/)( )*style( )*>)", "</style>");
            result = result.replaceAll("(<style>).*(</style>)", "");
            result = result.replaceAll("(<( )*(/)( )*sup( )*>)", "</sup>");
            result = result.replaceAll("<( )*sup([^>])*>", "<sup>");
            result = result.replaceAll("(<sup>).*(</sup>)", "");
            result = result.replaceAll("<( )*td([^>])*>", "\t");
            result = result.replaceAll("<( )*br( )*>", "\r");
            result = result.replaceAll("<( )*li( )*>", "\r");
            result = result.replaceAll("<( )*div([^>])*>", "\r\r");
            result = result.replaceAll("<( )*tr([^>])*>", "\r\r");
            result = result.replaceAll("(<) h (\\w+) >", "\r");
            result = result.replaceAll("(\\b) (</) h (\\w+) (>) (\\b)", "");
            result = result.replaceAll("<( )*p([^>])*>", "\r\r");
            result = result.replaceAll("<[^>]*>", "");
            result = result.replaceAll("&bull;", " * ");
            result = result.replaceAll("&lsaquo;", "<");
            result = result.replaceAll("&rsaquo;", ">");
            result = result.replaceAll("&trade;", "(tm)");
            result = result.replaceAll("&frasl;", "/");
            result = result.replaceAll("&lt;", "<");
            result = result.replaceAll("&gt;", ">");
            result = result.replaceAll("&copy;", "(c)");
            result = result.replaceAll("&reg;", "(r)");
            result = result.replaceAll("&(.{2,6});", "");
            result = result.replaceAll("(\r)( )+(\r)", "\r\r");
            result = result.replaceAll("(\t)( )+(\t)", "\t\t");
            result = result.replaceAll("(\t)( )+(\r)", "\t\r");
            result = result.replaceAll("(\r)( )+(\t)", "\r\t");
            result = result.replaceAll("(\r)(\t)+(\\r)", "\r\r");
            result = result.replaceAll("(\r)(\t)+", "\r\t");
        }
        return result;
    }
}

