/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.automation;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.installer.automation.AutomatedPanelView;
import com.izforge.izpack.installer.automation.PanelAutomation;
import com.izforge.izpack.installer.panel.AbstractPanels;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AutomatedPanels
extends AbstractPanels<AutomatedPanelView, PanelAutomation> {
    private final InstallData installData;
    private static final Logger logger = Logger.getLogger(AutomatedPanels.class.getName());

    public AutomatedPanels(List<AutomatedPanelView> panels, InstallData installData) {
        super(panels, installData.getVariables());
        this.installData = installData;
    }

    @Override
    protected boolean switchPanel(AutomatedPanelView newPanel, AutomatedPanelView oldPanel) {
        boolean result;
        if (newPanel.getViewClass() == null) {
            logger.warning("AutomationHelper class not found for panel: " + newPanel.getPanel().getClassName());
            result = this.executeValidationActions(newPanel, true);
        } else {
            newPanel.executePreActivationActions();
            PanelAutomation view = (PanelAutomation)newPanel.getView();
            IXMLElement xml = this.getPanelXML(newPanel);
            if (xml != null) {
                view.runAutomated(this.installData, xml);
                result = true;
            } else {
                logger.log(Level.SEVERE, "No configuration for panel: " + newPanel.getPanel().getClassName());
                result = false;
            }
        }
        return result;
    }

    private IXMLElement getPanelXML(AutomatedPanelView panel) {
        IXMLElement result = null;
        String className = panel.getPanel().getClassName();
        List<IXMLElement> panelRoots = this.installData.getXmlData().getChildrenNamed(className);
        if (!panelRoots.isEmpty()) {
            int index = 0;
            for (AutomatedPanelView panelView : this.getPanelViews()) {
                Panel p = panelView.getPanel();
                if (panel.getPanel().equals(p)) break;
                if (!p.getClassName().equals(className)) continue;
                ++index;
            }
            if (index < panelRoots.size()) {
                result = panelRoots.get(index);
            }
        }
        return result;
    }
}

