/*
 * Decompiled with CFR 0.152.
 */
package mwinstaller;

import argo.format.PrettyJsonFormatter;
import argo.jdom.JdomParser;
import argo.jdom.JsonField;
import argo.jdom.JsonNode;
import argo.jdom.JsonNodeFactories;
import argo.jdom.JsonRootNode;
import argo.jdom.JsonStringNode;
import argo.saj.InvalidSyntaxException;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import cpw.mods.fml.installer.VersionInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class JsonLibrariesInstaller {
    public void run(AbstractUIProcessHandler handler, String[] args) {
        handler.logOutput("Adding libraries...", false);
        File versionsRoot = new File(args[0], "versions");
        File forgeVersionDir = new File(versionsRoot, VersionInfo.getVersionTarget());
        File versionJson = new File(forgeVersionDir, VersionInfo.getVersionTarget() + ".json");
        if (!versionJson.exists()) {
            handler.emitError("Version json file not found!", "Could not find " + VersionInfo.getVersionTarget() + ".json");
            return;
        }
        JdomParser parser = new JdomParser();
        JsonRootNode jsonProfileData = null;
        try {
            jsonProfileData = parser.parse(Files.newReader(versionJson, Charsets.UTF_8));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidSyntaxException e) {
            handler.emitError("Invalid Syntax Error", VersionInfo.getVersionTarget() + ".json is corrupted.");
            e.printStackTrace();
            return;
        }
        ArrayList<JsonNode> librariesCopy = Lists.newArrayList(jsonProfileData.getArrayNode("libraries"));
        boolean libraryFound = false;
        for (JsonNode curLibEntry : librariesCopy) {
            String curLibName = curLibEntry.getStringValue("name");
            if (curLibName == null || !curLibName.equals("org.jblas:jblas:1.2.3")) continue;
            libraryFound = true;
            break;
        }
        if (libraryFound) {
            handler.logOutput("Finised!", false);
            return;
        }
        JsonField[] fields = new JsonField[]{JsonNodeFactories.field("name", (JsonNode)JsonNodeFactories.string("org.jblas:jblas:1.2.3")), JsonNodeFactories.field("url", (JsonNode)JsonNodeFactories.string("http://repo1.maven.org/maven2/"))};
        librariesCopy.add(JsonNodeFactories.object(fields));
        HashMap<JsonStringNode, JsonNode> rootCopy = Maps.newHashMap(jsonProfileData.getFields());
        rootCopy.put(JsonNodeFactories.string("libraries"), JsonNodeFactories.array(librariesCopy));
        jsonProfileData = JsonNodeFactories.object(rootCopy);
        try {
            BufferedWriter newWriter = Files.newWriter(versionJson, Charsets.UTF_8);
            PrettyJsonFormatter.fieldOrderPreservingPrettyJsonFormatter().format(jsonProfileData, newWriter);
            newWriter.close();
        }
        catch (Exception e) {
            handler.emitError("Version Json Error", "There was a problem writing the version json,  is it write protected?");
            return;
        }
        handler.logOutput("Finised!", false);
    }
}

