/*
 * Decompiled with CFR 0.152.
 */
package mwinstaller;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import cpw.mods.fml.installer.ClientInstall;
import cpw.mods.fml.installer.DownloadUtils;
import cpw.mods.fml.installer.IMonitor;
import cpw.mods.fml.installer.VersionInfo;
import java.io.File;
import javax.swing.JOptionPane;

public class ForgeInstaller {
    public void run(AbstractUIProcessHandler handler, String[] args) {
        File target = new File(args[0]);
        File versionRootDir = new File(target, "versions");
        File versionTarget = new File(versionRootDir, VersionInfo.getMinecraftVersion());
        if (!versionTarget.mkdirs() && !versionTarget.isDirectory()) {
            if (!versionTarget.delete()) {
                JOptionPane.showMessageDialog(null, "There was a problem with the launcher version data. You will need to clear " + versionTarget.getAbsolutePath() + " manually", "Error", 0);
            } else {
                versionTarget.mkdirs();
            }
        }
        File versionJsonFile = new File(versionTarget, VersionInfo.getMinecraftVersion() + ".json");
        File clientJarFile = new File(versionTarget, VersionInfo.getMinecraftVersion() + ".jar");
        if (!versionJsonFile.exists() || !clientJarFile.exists()) {
            String url;
            IMonitor monitor = DownloadUtils.buildMonitor();
            if (!versionJsonFile.exists() && !clientJarFile.exists()) {
                monitor.setMaximum(4);
            } else {
                monitor.setMaximum(3);
            }
            int progress = 2;
            if (!versionJsonFile.exists()) {
                monitor.setNote("Downloading version " + VersionInfo.getMinecraftVersion() + " json");
                url = "http://s3.amazonaws.com/Minecraft.Download/versions/" + VersionInfo.getMinecraftVersion() + "/" + VersionInfo.getMinecraftVersion() + ".json";
                if (!DownloadUtils.downloadFile(VersionInfo.getMinecraftVersion() + ".json", versionJsonFile, url, null)) {
                    JOptionPane.showMessageDialog(null, "You need to run the version " + VersionInfo.getMinecraftVersion() + " manually at least once", "Error", 0);
                    monitor.close();
                    return;
                }
                monitor.setProgress(progress++);
            }
            if (!clientJarFile.exists()) {
                monitor.setNote("Downloading version " + VersionInfo.getMinecraftVersion() + " jar");
                url = "http://s3.amazonaws.com/Minecraft.Download/versions/" + VersionInfo.getMinecraftVersion() + "/" + VersionInfo.getMinecraftVersion() + ".jar";
                if (!DownloadUtils.downloadFile(VersionInfo.getMinecraftVersion() + ".jar", clientJarFile, url, null)) {
                    JOptionPane.showMessageDialog(null, "You need to run the version " + VersionInfo.getMinecraftVersion() + " manually at least once", "Error", 0);
                    monitor.close();
                    return;
                }
                monitor.setProgress(progress++);
            }
            monitor.close();
        }
        handler.logOutput("Starting MinecraftForge installation...", false);
        ClientInstall forgeInstallClass = new ClientInstall();
        forgeInstallClass.run(target);
        handler.logOutput("Finished!", false);
    }
}

