/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.config.base.spi;

import com.izforge.izpack.util.config.base.Config;
import com.izforge.izpack.util.config.base.Options;
import com.izforge.izpack.util.config.base.spi.OptionsHandler;
import com.izforge.izpack.util.config.base.spi.ServiceFinder;

public class OptionsBuilder
implements OptionsHandler {
    private boolean _header;
    private String _lastComment;
    private int _emptyLines = 0;
    private Options _options;

    public static OptionsBuilder newInstance(Options opts) {
        OptionsBuilder instance = OptionsBuilder.newInstance();
        instance.setOptions(opts);
        return instance;
    }

    public void setOptions(Options value) {
        this._options = value;
    }

    @Override
    public void endOptions() {
        if (this._lastComment != null && this._header) {
            this.setHeaderComment();
        }
    }

    @Override
    public void handleComment(String comment) {
        if (this._lastComment != null && this._header) {
            this.setHeaderComment();
            this._header = false;
        }
        this._lastComment = this._lastComment == null ? comment : this._lastComment + this.getConfig().getLineSeparator() + comment;
    }

    @Override
    public void handleEmptyLine() {
        ++this._emptyLines;
    }

    @Override
    public void handleOption(String name, String value) {
        String newName = name;
        if (this.getConfig().isAutoNumbering() && name.matches("([^\\d]+\\.)+[\\d]+")) {
            String[] parts = name.split("\\.");
            newName = name.substring(0, name.length() - parts[parts.length - 1].length() - 1) + ".";
            int pos = Integer.parseInt(parts[parts.length - 1]);
            if (!this._options.containsKey(newName)) {
                this._options.add(newName, null);
            }
            for (int i = this._options.getAll(newName).size(); i <= pos; ++i) {
                this._options.add(newName, null);
            }
            this._options.put(newName, value, pos);
        } else if (this.getConfig().isMultiOption()) {
            this._options.add(newName, value);
        } else {
            this._options.put(newName, value);
        }
        if (this._emptyLines > 0) {
            if (!this._header) {
                this.putEmptyLines(newName);
            }
            this._emptyLines = 0;
        }
        if (this._lastComment != null) {
            if (this._header) {
                this.setHeaderComment();
            } else {
                this.putComment(newName);
            }
            this._lastComment = null;
        }
        this._header = false;
    }

    @Override
    public void startOptions() {
        if (this.getConfig().isHeaderComment()) {
            this._header = true;
        }
    }

    protected static OptionsBuilder newInstance() {
        return ServiceFinder.findService(OptionsBuilder.class);
    }

    private Config getConfig() {
        return this._options.getConfig();
    }

    private void setHeaderComment() {
        if (this.getConfig().isComment()) {
            this._options.setComment(this._lastComment);
        }
    }

    private void putComment(String key) {
        if (this.getConfig().isComment() && this._lastComment != null) {
            this._options.putComment(key, this._lastComment);
        }
    }

    private void putEmptyLines(String key) {
        if (this.getConfig().isEmptyLines()) {
            for (int i = 0; i < this._emptyLines; ++i) {
                this._options.addEmptyLine(key);
            }
        }
    }
}

