/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.config.base.spi;

import com.izforge.izpack.util.config.base.Config;
import com.izforge.izpack.util.config.base.spi.EscapeTool;
import com.izforge.izpack.util.config.base.spi.HandlerBase;
import java.io.PrintWriter;

abstract class AbstractFormatter
implements HandlerBase {
    private static final char COMMENT = '#';
    private static final char SPACE = ' ';
    private Config _config = Config.getGlobal();
    private boolean _header = true;
    private PrintWriter _output;

    AbstractFormatter() {
    }

    @Override
    public void handleEmptyLine() {
        if (this.getConfig().isEmptyLines()) {
            this.getOutput().print(this.getConfig().getLineSeparator());
        }
    }

    @Override
    public void handleComment(String comment) {
        if (this.getConfig().isComment() && (!this._header || this.getConfig().isHeaderComment()) && comment != null && comment.length() != 0) {
            for (String line : comment.split(this.getConfig().getLineSeparator())) {
                this.getOutput().print('#');
                this.getOutput().print(line);
                this.getOutput().print(this.getConfig().getLineSeparator());
            }
            if (this._header) {
                this.getOutput().print(this.getConfig().getLineSeparator());
            }
        }
        this._header = false;
    }

    @Override
    public void handleOption(String optionName, String optionValue) {
        String operator = this.getConfig().getOperator();
        if (this.getConfig().isStrictOperator()) {
            if (this.getConfig().isEmptyOption() || optionValue != null) {
                this.getOutput().print(this.escapeFilter(optionName));
                this.getOutput().print(operator);
            }
            if (optionValue != null) {
                this.getOutput().print(this.escapeFilter(optionValue));
            }
            if (this.getConfig().isEmptyOption() || optionValue != null) {
                this.getOutput().print(this.getConfig().getLineSeparator());
            }
        } else {
            String value = optionValue == null && this.getConfig().isEmptyOption() ? "" : optionValue;
            boolean isOperatorDefault = operator.equals("=");
            if (value != null) {
                this.getOutput().print(this.escapeFilter(optionName));
                if (isOperatorDefault) {
                    this.getOutput().print(' ');
                }
                this.getOutput().print(operator);
                if (isOperatorDefault) {
                    this.getOutput().print(' ');
                }
                this.getOutput().print(this.escapeFilter(value));
                this.getOutput().print(this.getConfig().getLineSeparator());
            }
        }
        this.setHeader(false);
    }

    protected Config getConfig() {
        return this._config;
    }

    protected void setConfig(Config value) {
        this._config = value;
    }

    protected PrintWriter getOutput() {
        return this._output;
    }

    protected void setOutput(PrintWriter value) {
        this._output = value;
    }

    void setHeader(boolean value) {
        this._header = value;
    }

    String escapeFilter(String input) {
        return this.getConfig().isEscape() ? EscapeTool.getInstance().escape(input) : input;
    }
}

