/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.Debug;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    Date date = new Date();
    private static final String format = "{0,date} {0,time}";
    private final String lineSeparator = System.getProperty("line.separator");
    private MessageFormat formatter;
    private Object[] args = new Object[1];

    @Override
    public synchronized String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        this.date.setTime(record.getMillis());
        this.args[0] = this.date;
        StringBuffer text = new StringBuffer();
        if (this.formatter == null) {
            this.formatter = new MessageFormat(format);
        }
        this.formatter.format(this.args, text, (FieldPosition)null);
        sb.append(text);
        sb.append(" ");
        if (Debug.isDEBUG()) {
            if (record.getSourceClassName() != null) {
                sb.append(record.getSourceClassName());
            } else {
                sb.append(record.getLoggerName());
            }
            if (record.getSourceMethodName() != null) {
                sb.append(" ");
                sb.append(record.getSourceMethodName());
            }
            sb.append(this.lineSeparator);
        }
        String message = this.formatMessage(record);
        sb.append(record.getLevel().getLocalizedName());
        sb.append(": ");
        sb.append(message);
        if (Debug.isSTACKTRACE() && record.getThrown() != null) {
            sb.append(this.lineSeparator);
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        sb.append(this.lineSeparator);
        return sb.toString();
    }
}

