/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.target;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.file.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TargetPanelHelper {
    public static final String TARGET_PANEL_DIR = "TargetPanel.dir";
    private static final String PREFIX = "TargetPanel.dir.";
    private static final Logger logger = Logger.getLogger(TargetPanelHelper.class.getName());

    public static String getPath(InstallData installData) {
        String path;
        String defaultPath = installData.getDefaultInstallPath();
        if (defaultPath == null) {
            defaultPath = installData.getVariable("SYSTEM_user_dir");
        }
        if ((path = TargetPanelHelper.getTargetPanelDir(installData)) != null) {
            path = installData.getVariables().replace(path);
        }
        if (path == null && defaultPath != null) {
            path = installData.getVariables().replace(defaultPath);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isIncompatibleInstallation(String dir) {
        boolean bl;
        boolean result = false;
        File file = new File(dir, ".installationinformation");
        if (!file.exists()) return result;
        FileInputStream input = null;
        ObjectInputStream objectInput = null;
        try {
            input = new FileInputStream(file);
            objectInput = new ObjectInputStream(input);
            List packs = (List)objectInput.readObject();
            for (Object pack : packs) {
                if (pack instanceof Pack) continue;
                bl = true;
            }
        }
        catch (Throwable exception) {
            try {
                logger.log(Level.FINE, "Installation information at path=" + file.getPath() + " failed to deserialize", exception);
                result = true;
            }
            catch (Throwable throwable) {
                FileUtils.close(objectInput);
                FileUtils.close(input);
                throw throwable;
            }
            FileUtils.close(objectInput);
            FileUtils.close(input);
            return result;
        }
        FileUtils.close(objectInput);
        FileUtils.close(input);
        return result;
        FileUtils.close(objectInput);
        FileUtils.close(input);
        return bl;
    }

    private static String getTargetPanelDir(InstallData installData) {
        Platform platform = installData.getPlatform();
        String path = null;
        if (platform.getSymbolicName() != null) {
            path = installData.getVariable(PREFIX + platform.getSymbolicName().toLowerCase());
        }
        if (path == null) {
            path = TargetPanelHelper.getTargetPanelDir(installData, platform.getName());
        }
        if (path == null) {
            path = installData.getVariable(TARGET_PANEL_DIR);
        }
        return path;
    }

    private static String getTargetPanelDir(InstallData installData, Platform.Name name) {
        String path = null;
        ArrayList<Platform.Name> queue = new ArrayList<Platform.Name>();
        queue.add(name);
        while (!queue.isEmpty()) {
            name = (Platform.Name)((Object)queue.remove(0));
            path = installData.getVariable(PREFIX + name.toString().toLowerCase());
            if (path != null) break;
            Collections.addAll(queue, name.getParents());
        }
        return path;
    }
}

