/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.target;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.panels.path.PathInputPanel;
import com.izforge.izpack.panels.target.TargetPanelAutomation;
import com.izforge.izpack.panels.target.TargetPanelHelper;

public class TargetPanel
extends PathInputPanel {
    private static final long serialVersionUID = 3256443616359429170L;

    public TargetPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        super(panel, parent, installData, resources, log);
    }

    @Override
    public void panelActivate() {
        String path = this.installData.getInstallPath();
        if (path == null) {
            path = TargetPanelHelper.getPath(this.installData);
        }
        if (path != null) {
            this.pathSelectionPanel.setPath(path);
        }
        super.panelActivate();
    }

    @Override
    public boolean isValidated() {
        boolean result = false;
        if (TargetPanelHelper.isIncompatibleInstallation(this.getPath())) {
            this.emitError(this.getString("installer.error"), this.getString("TargetPanel.incompatibleInstallation"));
        } else if (super.isValidated()) {
            String path = this.getPath();
            this.installData.setInstallPath(path);
            result = true;
        }
        return result;
    }

    @Override
    public void makeXMLData(IXMLElement panelRoot) {
        new TargetPanelAutomation().makeXMLData(this.installData, panelRoot);
    }

    @Override
    public String getSummaryBody() {
        return this.installData.getInstallPath();
    }
}

