/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.packs;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.util.Console;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class PacksConsolePanel
extends AbstractConsolePanel
implements ConsolePanel {
    private static final String REQUIRED = "required";
    private static final String NOT_SELECTED = "Not Selected";
    private static final String ALREADY_SELECTED = "Already Selected";
    private static final String DONE = "Done!";
    private static final String SPACE = " ";
    private HashMap<String, Pack> names;
    private final Prompt prompt;

    public PacksConsolePanel(PanelView<Console> panel, Prompt prompt) {
        super(panel);
        this.prompt = prompt;
    }

    @Override
    public boolean run(InstallData installData, Properties properties) {
        return true;
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        this.out(Prompt.Type.INFORMATION, "");
        LinkedList<Pack> selectedPacks = new LinkedList<Pack>();
        this.computePacks(installData.getAvailablePacks());
        for (String key : this.names.keySet()) {
            this.drawHelper(key, selectedPacks, installData);
        }
        this.out(Prompt.Type.INFORMATION, DONE);
        installData.setSelectedPacks(selectedPacks);
        if (selectedPacks.size() == 0) {
            this.out(Prompt.Type.WARNING, "You have not selected any packs!");
            this.out(Prompt.Type.WARNING, "Are you sure you want to continue?");
        }
        return this.promptEndPanel(installData, console);
    }

    private void out(Prompt.Type type, String message) {
        this.prompt.message(type, message);
    }

    private void drawHelper(String pack, List<Pack> selectedPacks, InstallData installData) {
        Pack p = this.names.get(pack);
        Boolean conditionSatisfied = this.checkCondition(installData, p);
        Boolean conditionExists = conditionSatisfied != null;
        String packName = p.getName();
        if (conditionExists.booleanValue()) {
            if (conditionSatisfied.booleanValue()) {
                this.out(Prompt.Type.INFORMATION, packName + SPACE + ALREADY_SELECTED);
                selectedPacks.add(p);
            } else {
                this.out(Prompt.Type.INFORMATION, packName + SPACE + NOT_SELECTED);
            }
        } else if (p.isRequired()) {
            this.out(Prompt.Type.INFORMATION, packName + SPACE + REQUIRED);
            selectedPacks.add(p);
        } else if (this.askUser(packName)) {
            selectedPacks.add(p);
        }
    }

    private Boolean checkCondition(InstallData installData, Pack pack) {
        if (pack.hasCondition()) {
            return installData.getRules().isConditionTrue(pack.getCondition());
        }
        return null;
    }

    private boolean askUser(String message) {
        return Prompt.Option.YES == this.prompt.confirm(Prompt.Type.QUESTION, message, Prompt.Options.YES_NO);
    }

    private void computePacks(List<Pack> packs) {
        this.names = new HashMap();
        for (Pack pack : packs) {
            this.names.put(pack.getName(), pack);
        }
    }
}

