/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.finish;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLWriter;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.installer.automation.AutomatedPanelView;
import com.izforge.izpack.installer.automation.AutomatedPanels;
import com.izforge.izpack.installer.automation.PanelAutomation;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanelAutomationHelper;
import com.izforge.izpack.installer.container.provider.AutomatedPanelsProvider;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.util.Console;
import com.izforge.izpack.util.PlatformModelMatcher;
import com.izforge.izpack.util.file.FileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class FinishConsolePanel
extends AbstractConsolePanel {
    private static final Logger LOGGER = Logger.getLogger(FinishConsolePanel.class.getName());
    private static final String AUTO_INSTALL_SCRIPT_NAME = "autoInstall.xml";
    private final Prompt prompt;
    private final ObjectFactory factory;
    private final PlatformModelMatcher matcher;

    public FinishConsolePanel(ObjectFactory factory, PlatformModelMatcher matcher, Prompt prompt, PanelView<Console> panel) {
        super(panel);
        this.prompt = prompt;
        this.factory = factory;
        this.matcher = matcher;
    }

    public FinishConsolePanel(PanelView<Console> panel) {
        this(null, null, null, panel);
    }

    @Override
    public boolean run(InstallData installData, Properties properties) {
        return true;
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        if (this.doGenerateAutoInstallScript()) {
            this.generateAutoInstallScript(installData, console);
        }
        if (installData.isInstallSuccess()) {
            console.println("Installation was successful");
            console.println("application installed on " + installData.getInstallPath());
        } else {
            console.println("Install Failed!!!");
        }
        return true;
    }

    private boolean doGenerateAutoInstallScript() {
        return this.factory != null && this.matcher != null && this.prompt != null;
    }

    private void generateAutoInstallScript(InstallData installData, Console console) {
        Prompt.Option userAnswer = this.prompt.confirm(Prompt.Type.QUESTION, installData.getMessages().get("FinishPanel.auto", new Object[0]), Prompt.Options.YES_NO);
        if (userAnswer == Prompt.Option.YES) {
            String parentPath = installData.getVariable("INSTALL_PATH");
            if (parentPath == null) {
                parentPath = installData.getVariable("USER_HOME");
            }
            File file = new File(parentPath, AUTO_INSTALL_SCRIPT_NAME);
            String filePath = console.prompt("Select the installation script (path must be absolute)[" + file.getAbsolutePath() + "]", file.getAbsolutePath(), null);
            File newFile = new File(filePath);
            if (!newFile.isAbsolute()) {
                console.println("path of the installation script must be absolute");
                this.promptRerunPanel(installData, console);
            } else {
                this.generateAutoInstallScript(newFile, installData, console);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateAutoInstallScript(File file, InstallData installData, Console console) {
        BufferedOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file), 5120);
            XMLWriter writer = new XMLWriter(outputStream);
            IXMLElement root = installData.getXmlData();
            AutomatedPanels automatedPanels = this.getAutomatedPanels(installData);
            List panelViews = automatedPanels.getPanelViews();
            int index = 0;
            for (AutomatedPanelView panelView : panelViews) {
                this.makeXML(panelView, installData, root.getChildAtIndex(index));
                ++index;
            }
            writer.write(root);
            outputStream.flush();
        }
        catch (Exception e) {
            try {
                console.println("failed to save the installation into file [" + file.getAbsolutePath() + "]");
            }
            catch (Throwable throwable) {
                FileUtils.close(outputStream);
                throw throwable;
            }
            FileUtils.close(outputStream);
        }
        FileUtils.close(outputStream);
    }

    protected AutomatedPanels getAutomatedPanels(InstallData aInstallData) {
        AutomatedPanelsProvider provider = new AutomatedPanelsProvider();
        AutomatedPanels automatedPanels = provider.provide(this.factory, (AutomatedInstallData)aInstallData, new ConsolePanelAutomationHelper(), this.matcher);
        return automatedPanels;
    }

    protected void makeXML(AutomatedPanelView panelView, InstallData installData, IXMLElement root) {
        try {
            ((PanelAutomation)panelView.getView()).makeXMLData(installData, root);
        }
        catch (Exception e) {
            LOGGER.warning("Unsupported panel " + panelView.getPanel().getClassName() + ": no automated helper associated?");
            this.prompt.warn(e.getMessage());
        }
    }
}

