/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.language;

import com.izforge.izpack.api.resource.Locales;
import com.izforge.izpack.installer.data.GUIInstallData;
import java.awt.Font;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;

class Languages {
    private DisplayType displayType;
    private final Map<String, String> displayNames = new LinkedHashMap<String, String>();
    private static final Logger logger = Logger.getLogger(Languages.class.getName());

    public Languages(Locales locales, GUIInstallData installData, Font font) {
        this.displayType = this.getDisplayType(installData);
        if (this.displayType == DisplayType.NATIVE && font == null) {
            logger.info("Cannot render native language display names - no font supplied for verification");
            this.displayType = DisplayType.DEFAULT;
        }
        DisplayNameCollector collector = this.displayType == DisplayType.NATIVE ? new NativeDisplayNameCollector(font) : (this.displayType == DisplayType.DEFAULT ? new DefaultDisplayNameCollector() : new ISO3CodeCollector());
        for (String code : locales.getISOCodes()) {
            collector.addDisplayName(code, locales.getLocale(code), this.displayNames);
        }
    }

    public DisplayType getDisplayType() {
        return this.displayType;
    }

    public Map<String, String> getDisplayNames() {
        return this.displayNames;
    }

    private DisplayType getDisplayType(GUIInstallData installData) {
        DisplayType result = DisplayType.DEFAULT;
        Map<String, String> modifier = installData.guiPrefs.modifier;
        String langDisplayType = modifier.get("langDisplayType");
        if (langDisplayType != null && langDisplayType.length() != 0) {
            try {
                result = DisplayType.valueOf(langDisplayType.toUpperCase());
            }
            catch (IllegalArgumentException exception) {
                logger.warning("Invalid langDisplayType: " + langDisplayType);
            }
        }
        return result;
    }

    private class NativeDisplayNameCollector
    implements DisplayNameCollector {
        private final Font font;

        public NativeDisplayNameCollector(Font font) {
            this.font = font;
        }

        @Override
        public void addDisplayName(String code, Locale locale, Map<String, String> displayNames) {
            String name = locale.getDisplayLanguage(locale);
            if (this.font.canDisplayUpTo(name) > -1) {
                name = locale.getDisplayLanguage();
            }
            displayNames.put(code, name);
        }
    }

    private class DefaultDisplayNameCollector
    implements DisplayNameCollector {
        private DefaultDisplayNameCollector() {
        }

        @Override
        public void addDisplayName(String code, Locale locale, Map<String, String> displayNames) {
            displayNames.put(code, locale.getDisplayLanguage());
        }
    }

    private class ISO3CodeCollector
    implements DisplayNameCollector {
        private ISO3CodeCollector() {
        }

        @Override
        public void addDisplayName(String code, Locale locale, Map<String, String> displayNames) {
            displayNames.put(code, code);
        }
    }

    private static interface DisplayNameCollector {
        public void addDisplayName(String var1, Locale var2, Map<String, String> var3);
    }

    static enum DisplayType {
        ISO3,
        NATIVE,
        DEFAULT;

    }
}

