/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.gui;

import com.izforge.izpack.api.container.Container;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.installer.gui.IzPanelView;
import com.izforge.izpack.installer.gui.IzPanelsListener;
import com.izforge.izpack.installer.panel.AbstractPanels;
import java.util.List;

public class IzPanels
extends AbstractPanels<IzPanelView, IzPanel> {
    private final GUIInstallData installData;
    private final Container container;
    private IzPanelsListener listener;
    private boolean isBack = false;

    public IzPanels(List<IzPanelView> panels, Container container, GUIInstallData installData) {
        super(panels, installData.getVariables());
        this.container = container;
        this.installData = installData;
    }

    public void initialise() {
        for (IzPanelView panel : this.getPanelViews()) {
            IzPanel view = (IzPanel)panel.getView();
            this.installData.getPanels().add(view);
            String panelId = panel.getPanelId();
            if (panelId == null) {
                panelId = view.getClass().getName();
            }
            this.container.addComponent(panelId, view);
        }
    }

    public void setListener(IzPanelsListener listener) {
        this.listener = listener;
    }

    public boolean isBack() {
        return this.isBack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean switchPanel(IzPanelView newPanel, IzPanelView oldPanel) {
        boolean result = false;
        try {
            boolean bl = this.isBack = oldPanel != null && newPanel.getIndex() < oldPanel.getIndex();
            if (this.listener != null) {
                this.listener.switchPanel(newPanel, oldPanel);
                result = true;
            }
        }
        finally {
            this.isBack = false;
        }
        return result;
    }
}

