/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.automation;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLParser;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.resource.Locales;
import com.izforge.izpack.installer.automation.AutomatedPanels;
import com.izforge.izpack.installer.base.InstallerBase;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.installer.requirement.RequirementsChecker;
import com.izforge.izpack.util.Housekeeper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Logger;

public class AutomatedInstaller
extends InstallerBase {
    private final AutomatedPanels panels;
    private final AutomatedInstallData installData;
    private RequirementsChecker requirements;
    private UninstallDataWriter uninstallDataWriter;
    private final Locales locales;
    private final Housekeeper housekeeper;
    private static final Logger logger = Logger.getLogger(AutomatedInstaller.class.getName());

    public AutomatedInstaller(AutomatedPanels panels, AutomatedInstallData installData, Locales locales, RequirementsChecker requirements, UninstallDataWriter uninstallDataWriter, Housekeeper housekeeper) {
        this.panels = panels;
        this.installData = installData;
        this.locales = locales;
        this.requirements = requirements;
        this.uninstallDataWriter = uninstallDataWriter;
        this.housekeeper = housekeeper;
    }

    public void init(String inputFilename, String mediaPath) throws Exception {
        File input = new File(inputFilename);
        this.installData.setXmlData(this.getXMLData(input));
        String code = this.installData.getXmlData().getAttribute("langpack", "eng");
        this.locales.setLocale(code);
        this.installData.setMessages(this.locales.getMessages());
        this.installData.setLocale(this.locales.getLocale(), this.locales.getISOCode());
        this.installData.setMediaPath(mediaPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInstall() throws Exception {
        boolean reboot;
        boolean success;
        block27: {
            success = false;
            if (!this.requirements.check()) {
                System.out.println("[ Automated installation FAILED! ]");
                System.exit(-1);
                return;
            }
            System.out.println("[ Starting automated installation ]");
            logger.info("[ Starting automated installation ]");
            try {
                while (this.panels.hasNext() && (success = this.panels.next())) {
                }
                if (success) {
                    success = this.panels.isValid();
                }
                if (success && this.uninstallDataWriter.isUninstallRequired()) {
                    success = this.uninstallDataWriter.write();
                }
                if (success) {
                    System.out.println("[ Automated installation done ]");
                } else {
                    System.out.println("[ Automated installation FAILED! ]");
                }
                reboot = false;
                if (!this.installData.isRebootNecessary()) break block27;
                System.out.println("[ There are file operations pending after reboot ]");
            }
            catch (Exception e) {
                boolean reboot2;
                block28: {
                    try {
                        success = false;
                        System.err.println(e.toString());
                        e.printStackTrace();
                        if (success) {
                            System.out.println("[ Automated installation done ]");
                        } else {
                            System.out.println("[ Automated installation FAILED! ]");
                        }
                        reboot2 = false;
                        if (!this.installData.isRebootNecessary()) break block28;
                        System.out.println("[ There are file operations pending after reboot ]");
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            System.out.println("[ Automated installation done ]");
                        } else {
                            System.out.println("[ Automated installation FAILED! ]");
                        }
                        boolean reboot3 = false;
                        if (this.installData.isRebootNecessary()) {
                            System.out.println("[ There are file operations pending after reboot ]");
                            switch (this.installData.getInfo().getRebootAction()) {
                                case 3: {
                                    reboot3 = true;
                                }
                            }
                            if (reboot3) {
                                System.out.println("[ Rebooting now automatically ]");
                            }
                        }
                        this.housekeeper.shutDown(success ? 0 : 1, reboot3);
                        throw throwable;
                    }
                    switch (this.installData.getInfo().getRebootAction()) {
                        case 3: {
                            reboot2 = true;
                        }
                    }
                    if (reboot2) {
                        System.out.println("[ Rebooting now automatically ]");
                    }
                }
                this.housekeeper.shutDown(success ? 0 : 1, reboot2);
            }
            switch (this.installData.getInfo().getRebootAction()) {
                case 3: {
                    reboot = true;
                }
            }
            if (reboot) {
                System.out.println("[ Rebooting now automatically ]");
            }
        }
        this.housekeeper.shutDown(success ? 0 : 1, reboot);
    }

    private IXMLElement getXMLData(File input) throws IOException {
        FileInputStream in = new FileInputStream(input);
        XMLParser parser = new XMLParser();
        IXMLElement rtn = parser.parse(in, input.getAbsolutePath());
        in.close();
        return rtn;
    }
}

