/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import com.izforge.izpack.api.handler.AbstractPrompt;
import com.izforge.izpack.api.handler.Prompt;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class GUIPrompt
extends AbstractPrompt {
    private final JComponent parent;
    private static final String OK_BUTTON = "OptionPane.okButtonText";
    private static final String CANCEL_BUTTON = "OptionPane.cancelButtonText";
    private static final String YES_BUTTON = "OptionPane.yesButtonText";
    private static final String NO_BUTTON = "OptionPane.noButtonText";

    public GUIPrompt() {
        this(null);
    }

    public GUIPrompt(JComponent parent) {
        this.parent = parent;
    }

    @Override
    public void message(Prompt.Type type, String title, String message) {
        if (title == null) {
            title = this.getTitle(type);
        }
        this.showMessageDialog(this.getMessageType(type), title, message);
    }

    @Override
    public Prompt.Option confirm(Prompt.Type type, String title, String message, Prompt.Options options, Prompt.Option defaultOption) {
        int selected;
        int optionType;
        int messageType = this.getMessageType(type);
        switch (options) {
            case OK_CANCEL: {
                optionType = 2;
                break;
            }
            case YES_NO_CANCEL: {
                optionType = 1;
                break;
            }
            default: {
                optionType = 0;
            }
        }
        if (title == null) {
            title = this.getTitle(type);
        }
        if (defaultOption == null) {
            selected = this.showConfirmDialog(messageType, title, message, optionType);
        } else {
            String initialValue;
            ArrayList<Object> opts = new ArrayList<Object>();
            switch (optionType) {
                case 2: {
                    String ok = UIManager.getString(OK_BUTTON);
                    String cancel = UIManager.getString(CANCEL_BUTTON);
                    opts.add(ok);
                    opts.add(cancel);
                    initialValue = defaultOption == Prompt.Option.OK ? ok : (defaultOption == Prompt.Option.CANCEL ? cancel : null);
                    break;
                }
                case 0: {
                    String yes = UIManager.getString(YES_BUTTON);
                    String no = UIManager.getString(NO_BUTTON);
                    opts.add(yes);
                    opts.add(no);
                    initialValue = defaultOption == Prompt.Option.YES ? yes : (defaultOption == Prompt.Option.NO ? no : null);
                    break;
                }
                case 1: {
                    String yes = UIManager.getString(YES_BUTTON);
                    String no = UIManager.getString(NO_BUTTON);
                    opts.add(yes);
                    opts.add(no);
                    String cancel = UIManager.getString(CANCEL_BUTTON);
                    initialValue = defaultOption == Prompt.Option.YES ? yes : (defaultOption == Prompt.Option.NO ? no : (defaultOption == Prompt.Option.CANCEL ? cancel : null));
                    break;
                }
                default: {
                    initialValue = null;
                }
            }
            selected = this.showOptionDialog(messageType, title, message, optionType, opts, initialValue);
        }
        return this.getSelected(options, selected);
    }

    private void showMessageDialog(final int type, final String title, final String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            JOptionPane.showMessageDialog(this.parent, message, title, type);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(GUIPrompt.this.parent, message, title, type);
                    }
                });
            }
            catch (Throwable exception) {
                throw new IllegalStateException(exception);
            }
        }
    }

    private int showOptionDialog(final int type, final String title, final String message, final int optionType, final List<Object> opts, final Object initialValue) {
        int selected;
        if (SwingUtilities.isEventDispatchThread()) {
            selected = JOptionPane.showOptionDialog(this.parent, message, title, optionType, type, null, opts.toArray(), initialValue);
        } else {
            final int[] handle = new int[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        handle[0] = JOptionPane.showOptionDialog(GUIPrompt.this.parent, message, title, optionType, type, null, opts.toArray(), initialValue);
                    }
                });
            }
            catch (Throwable exception) {
                throw new IllegalStateException(exception);
            }
            selected = handle[0];
        }
        return selected;
    }

    private int showConfirmDialog(final int type, final String title, final String message, final int optionType) {
        int selected;
        if (SwingUtilities.isEventDispatchThread()) {
            selected = JOptionPane.showConfirmDialog(this.parent, message, title, optionType, type);
        } else {
            final int[] handle = new int[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        handle[0] = JOptionPane.showConfirmDialog(GUIPrompt.this.parent, message, title, optionType, type);
                    }
                });
            }
            catch (Throwable exception) {
                throw new IllegalStateException(exception);
            }
            selected = handle[0];
        }
        return selected;
    }

    private Prompt.Option getSelected(Prompt.Options options, int selected) {
        Prompt.Option result;
        switch (selected) {
            case 0: {
                result = options == Prompt.Options.OK_CANCEL ? Prompt.Option.OK : Prompt.Option.YES;
                break;
            }
            case 1: {
                result = Prompt.Option.NO;
                break;
            }
            case 2: {
                result = Prompt.Option.CANCEL;
                break;
            }
            default: {
                result = options == Prompt.Options.YES_NO_CANCEL ? Prompt.Option.CANCEL : Prompt.Option.NO;
            }
        }
        return result;
    }

    private String getTitle(Prompt.Type type) {
        String result;
        switch (type) {
            case INFORMATION: {
                result = "Info";
                break;
            }
            case QUESTION: {
                result = "Question";
                break;
            }
            case WARNING: {
                result = "Warning";
                break;
            }
            default: {
                result = "Error";
            }
        }
        return result;
    }

    private int getMessageType(Prompt.Type type) {
        int result;
        switch (type) {
            case INFORMATION: {
                result = 1;
                break;
            }
            case WARNING: {
                result = 2;
                break;
            }
            case QUESTION: {
                result = 3;
                break;
            }
            default: {
                result = 0;
            }
        }
        return result;
    }
}

