/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.event.AbstractProgressInstallerListener;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.util.SummaryProcessor;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.file.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class SummaryLoggerInstallerListener
extends AbstractProgressInstallerListener {
    public SummaryLoggerInstallerListener(InstallData installData) {
        super(installData);
    }

    @Override
    public void afterPacks(List<Pack> packs, ProgressListener listener) {
        if (this.getInstallData() instanceof GUIInstallData) {
            GUIInstallData installData = (GUIInstallData)this.getInstallData();
            if (!installData.isInstallSuccess()) {
                return;
            }
            if (installData.getPanels().isEmpty()) {
                return;
            }
            String path = installData.getInfo().getSummaryLogFilePath();
            if (path == null) {
                return;
            }
            File parent = new File(path = IoHelper.translatePath(path, installData.getVariables())).getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            String summary = SummaryProcessor.getSummary(installData);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(path);
                ((OutputStream)out).write(summary.getBytes("utf-8"));
            }
            catch (IOException exception) {
                try {
                    throw new IzPackException("Failed to write summary to path: " + path, exception);
                }
                catch (Throwable throwable) {
                    FileUtils.close(out);
                    throw throwable;
                }
            }
            FileUtils.close(out);
        }
    }
}

