/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.metallurgycore.machines;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;

public abstract class TileEntityMetallurgy
extends TileEntity
implements IInventory {
    protected static final int MAXCOOKTIME = 200;
    protected ItemStack[] itemStacks;
    public int burnTime;
    public int currentItemBurnTime;
    public int cookTime;
    private Random random = new Random();

    protected boolean canAcceptStackRange(int[] range, ItemStack itemstack) {
        Boolean retVal = false;
        for (int i : range) {
            boolean itemEqual = this.itemStacks[i].func_77969_a(itemstack);
            if (itemEqual) {
                int stackSize = this.itemStacks[i].field_77994_a + itemstack.field_77994_a;
                retVal = retVal | (stackSize <= this.func_70297_j_() && stackSize <= itemstack.func_77976_d());
                continue;
            }
            retVal = retVal | false;
        }
        return retVal;
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.itemStacks[i] != null) {
            if (this.itemStacks[i].field_77994_a <= j) {
                ItemStack itemstack = this.itemStacks[i];
                this.itemStacks[i] = null;
                return itemstack;
            }
            ItemStack itemstack = this.itemStacks[i].func_77979_a(j);
            if (this.itemStacks[i].field_77994_a == 0) {
                this.itemStacks[i] = null;
            }
            return itemstack;
        }
        return null;
    }

    public void dropContents() {
        World world = this.field_145850_b;
        for (ItemStack stack : this.itemStacks) {
            if (stack == null) continue;
            float f = this.random.nextFloat() * 0.8f + 0.1f;
            float f1 = this.random.nextFloat() * 0.8f + 0.1f;
            float f2 = this.random.nextFloat() * 0.8f + 0.1f;
            while (stack.field_77994_a > 0) {
                int k1 = this.random.nextInt(21) + 10;
                if (k1 > stack.field_77994_a) {
                    k1 = stack.field_77994_a;
                }
                stack.field_77994_a -= k1;
                EntityItem entityitem = new EntityItem(world, (double)((float)this.field_145851_c + f), (double)((float)this.field_145848_d + f1), (double)((float)this.field_145849_e + f2), new ItemStack(stack.func_77973_b(), k1, stack.func_77960_j()));
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)this.random.nextGaussian() * f3;
                entityitem.field_70181_x = (float)this.random.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)this.random.nextGaussian() * f3;
                if (stack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                }
                world.func_72838_d((Entity)entityitem);
            }
        }
    }

    public int getBurnTimeRemainingScaled(int i) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.burnTime * i / this.currentItemBurnTime;
    }

    public int getCookProgressScaled(int i) {
        return this.cookTime * i / 200;
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeCustomNBT(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 3, compound);
    }

    public abstract int func_70297_j_();

    public abstract String func_145825_b();

    public int func_70302_i_() {
        return this.itemStacks.length;
    }

    protected abstract ItemStack getSmeltingResult(ItemStack ... var1);

    public ItemStack func_70301_a(int i) {
        return this.itemStacks[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.itemStacks[i] != null) {
            ItemStack itemstack = this.itemStacks[i];
            this.itemStacks[i] = null;
            return itemstack;
        }
        return null;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i >= this.getOutputSlots()[0] ? false : (i == this.getFuelSlot() ? TileEntityFurnace.func_145954_b((ItemStack)itemstack) : true);
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readCustomNBT(pkt.func_148857_g());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_70295_k_() {
    }

    protected void readCustomNBT(NBTTagCompound data) {
        this.itemStacks = new ItemStack[this.func_70302_i_()];
        this.readItemListFromNBT(data, "Items", this.itemStacks);
        this.burnTime = data.func_74765_d("BurnTime");
        this.cookTime = data.func_74765_d("CookTime");
        this.currentItemBurnTime = TileEntityFurnace.func_145952_a((ItemStack)this.itemStacks[1]);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readCustomNBT(compound);
    }

    protected void readItemListFromNBT(NBTTagCompound data, String name, ItemStack[] stacks) {
        NBTTagList nbttaglist = data.func_150295_c(name, 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.itemStacks.length) continue;
            stacks[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.itemStacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    protected boolean slotsAreEmpty(int[] range) {
        Boolean retVal = false;
        for (int i : range) {
            retVal = retVal | this.itemStacks[i] == null;
        }
        return retVal;
    }

    public void func_145845_h() {
        boolean burning = this.burnTime > 0;
        boolean changed = false;
        if (this.burnTime > 0) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.burnTime == 0 && this.canProcessItem()) {
                changed = this.preProcessItem();
            }
            if (this.isBurning() && this.canProcessItem()) {
                ++this.cookTime;
                if (this.cookTime == 200) {
                    this.cookTime = 0;
                    this.processItem();
                    changed = true;
                }
            } else {
                this.cookTime = 0;
            }
            if (burning != this.burnTime > 0) {
                changed = true;
            }
        }
        if (changed) {
            this.postProcessItem();
        }
    }

    protected boolean preProcessItem() {
        boolean changed = false;
        ItemStack fuelItemStack = this.func_70301_a(this.getFuelSlot());
        this.currentItemBurnTime = this.burnTime = TileEntityFurnace.func_145952_a((ItemStack)fuelItemStack);
        if (this.burnTime > 0 && fuelItemStack != null) {
            --fuelItemStack.field_77994_a;
            if (fuelItemStack.field_77994_a == 0) {
                this.func_70299_a(this.getFuelSlot(), fuelItemStack.func_77973_b().getContainerItem(fuelItemStack));
            }
            changed = true;
        }
        return changed;
    }

    protected void processItem() {
        if (this.canProcessItem()) {
            ItemStack[] inputStack = this.getStacksInSlots(this.getInputSlots());
            ItemStack outputStack = this.getSmeltingResult(inputStack);
            this.outputItem(outputStack);
            this.useMaterialInSlots(this.getInputSlots());
        }
    }

    protected void postProcessItem() {
        this.func_70296_d();
    }

    protected void writeCustomNBT(NBTTagCompound compound) {
        this.writeItemListToNBT(compound, this.itemStacks, "Items");
        compound.func_74777_a("BurnTime", (short)this.burnTime);
        compound.func_74777_a("CookTime", (short)this.cookTime);
    }

    protected void writeItemListToNBT(NBTTagCompound compound, ItemStack[] stacks, String name) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)i);
            stacks[i].func_77955_b(tagCompound);
            nbttaglist.func_74742_a((NBTBase)tagCompound);
        }
        compound.func_74782_a(name, (NBTBase)nbttaglist);
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.writeCustomNBT(compound);
    }

    protected abstract int[] getInputSlots();

    protected abstract int[] getOutputSlots();

    protected boolean useMaterialInSlots(int[] slots) {
        boolean flag = false;
        for (int slot : slots) {
            ItemStack stack = this.func_70301_a(slot);
            if (stack == null) continue;
            --stack.field_77994_a;
            if (stack.field_77994_a <= 0) {
                this.func_70299_a(slot, null);
            }
            flag |= true;
        }
        return flag;
    }

    protected void outputItem(ItemStack itemstack) {
        for (int slot : this.getOutputSlots()) {
            ItemStack stackInSlot = this.func_70301_a(slot);
            if (stackInSlot == null) {
                this.func_70299_a(slot, itemstack.func_77946_l());
                return;
            }
            if (!stackInSlot.func_77969_a(itemstack)) continue;
            stackInSlot.field_77994_a += itemstack.field_77994_a;
            return;
        }
    }

    protected abstract int getFuelSlot();

    protected ItemStack[] getStacksInSlots(int[] inputSlots) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int slot : inputSlots) {
            stacks.add(this.func_70301_a(slot));
        }
        return stacks.toArray(new ItemStack[0]);
    }

    protected ItemStack getSmeltingResultFromSlots(int[] slots) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int slot : slots) {
            stacks.add(this.func_70301_a(slot));
        }
        return this.getSmeltingResult(stacks.toArray(new ItemStack[0]));
    }

    protected boolean hasMaterialAndRoom(ItemStack ... itemStacks) {
        ItemStack itemstack = this.getSmeltingResultFromSlots(this.getInputSlots());
        if (itemStacks.length != 0) {
            itemstack = this.getSmeltingResult(itemStacks);
        }
        if (itemstack == null) {
            return false;
        }
        if (this.slotsAreEmpty(this.getOutputSlots())) {
            return true;
        }
        return this.canAcceptStackRange(this.getOutputSlots(), itemstack);
    }

    protected boolean canProcessItem() {
        if (!this.hasInput()) {
            return false;
        }
        return this.hasMaterialAndRoom(new ItemStack[0]);
    }

    protected boolean hasInput() {
        for (int slot : this.getInputSlots()) {
            if (this.func_70301_a(slot) != null) continue;
            return false;
        }
        return true;
    }
}

