/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.metallurgycore.guiwidgets;

import com.teammetallurgy.metallurgycore.guiwidgets.RenderEntityBlock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class FluidRender {
    private static final ResourceLocation BLOCK_TEXTURE = TextureMap.field_110575_b;
    public static final int DISPLAY_STAGES = 73;
    private static Map<Fluid, int[]> flowingRenderCache = new HashMap<Fluid, int[]>();
    private static final RenderEntityBlock.RenderInfo liquidBlock = new RenderEntityBlock.RenderInfo();
    private static Map<Fluid, int[]> stillRenderCache = new HashMap<Fluid, int[]>();

    public static int[] getFluidDisplayLists(FluidStack fluidStack, World world, boolean flowing) {
        if (fluidStack == null) {
            return null;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return null;
        }
        Map<Fluid, int[]> cache = flowing ? flowingRenderCache : stillRenderCache;
        int[] diplayLists = cache.get(fluid);
        if (diplayLists != null) {
            return diplayLists;
        }
        diplayLists = new int[73];
        if (fluid.getBlock() != null) {
            FluidRender.liquidBlock.baseBlock = fluid.getBlock();
            FluidRender.liquidBlock.texture = FluidRender.getFluidTexture(fluidStack, flowing);
        } else {
            FluidRender.liquidBlock.baseBlock = Blocks.field_150355_j;
            FluidRender.liquidBlock.texture = FluidRender.getFluidTexture(fluidStack, flowing);
        }
        cache.put(fluid, diplayLists);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2884);
        for (int s = 0; s < 73; ++s) {
            diplayLists[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)diplayLists[s], (int)4864);
            FluidRender.liquidBlock.minX = 0.01f;
            FluidRender.liquidBlock.minY = 0.0;
            FluidRender.liquidBlock.minZ = 0.01f;
            FluidRender.liquidBlock.maxX = 0.99f;
            FluidRender.liquidBlock.maxY = (float)s / 73.0f;
            FluidRender.liquidBlock.maxZ = 0.99f;
            RenderEntityBlock.INSTANCE.renderBlock(liquidBlock, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2896);
        return diplayLists;
    }

    public static ResourceLocation getFluidSheet(Fluid liquid) {
        return BLOCK_TEXTURE;
    }

    public static ResourceLocation getFluidSheet(FluidStack liquid) {
        if (liquid == null) {
            return BLOCK_TEXTURE;
        }
        return FluidRender.getFluidSheet(liquid.getFluid());
    }

    public static IIcon getFluidTexture(Fluid fluid, boolean flowing) {
        IIcon icon;
        if (fluid == null) {
            return null;
        }
        IIcon iIcon = icon = flowing ? fluid.getFlowingIcon() : fluid.getStillIcon();
        if (icon == null) {
            icon = ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        return icon;
    }

    public static IIcon getFluidTexture(FluidStack fluidStack, boolean flowing) {
        if (fluidStack == null) {
            return null;
        }
        return FluidRender.getFluidTexture(fluidStack.getFluid(), flowing);
    }

    public static void setColorForFluidStack(FluidStack fluidstack) {
        if (fluidstack == null) {
            return;
        }
        int color = fluidstack.getFluid().getColor(fluidstack);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
    }
}

