/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.metallurgy.metals;

import com.google.gson.Gson;
import com.teammetallurgy.metallurgy.Utils;
import com.teammetallurgy.metallurgy.armor.ItemMetallurgyArmor;
import com.teammetallurgy.metallurgy.metals.ItemMetalBlock;
import com.teammetallurgy.metallurgy.metals.Metal;
import com.teammetallurgy.metallurgy.metals.MetalBlock;
import com.teammetallurgy.metallurgy.metals.MetalItem;
import com.teammetallurgy.metallurgy.tools.Axe;
import com.teammetallurgy.metallurgy.tools.Hoe;
import com.teammetallurgy.metallurgy.tools.Pickaxe;
import com.teammetallurgy.metallurgy.tools.Shovel;
import com.teammetallurgy.metallurgy.tools.Sword;
import com.teammetallurgy.metallurgy.world.WorldGenMetals;
import com.teammetallurgy.metallurgycore.handlers.ConfigHandler;
import com.teammetallurgy.metallurgycore.handlers.LogHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.oredict.OreDictionary;

public class MetalSet {
    private String name;
    private Metal[] metals = null;
    private String setTag;
    private MetalBlock defaultOre;
    private MetalBlock defaultBlock;
    private MetalBlock defaultBricks;
    private MetalItem defaultDust;
    private MetalItem defaultDrops;
    private HashMap<String, ItemStack> oreStacks = new HashMap();
    private HashMap<String, ItemStack> blockStacks = new HashMap();
    private HashMap<String, ItemStack> brickStacks = new HashMap();
    private HashMap<String, ItemStack> ingotStacks = new HashMap();
    private HashMap<String, ItemStack> dustStacks = new HashMap();
    private HashMap<String, ItemStack> dropStacks = new HashMap();
    private HashMap<String, ItemStack> axeStacks = new HashMap();
    private HashMap<String, ItemStack> hoeStacks = new HashMap();
    private HashMap<String, ItemStack> pickaxeStacks = new HashMap();
    private HashMap<String, ItemStack> shovelStacks = new HashMap();
    private HashMap<String, ItemStack> swordStacks = new HashMap();
    private HashMap<String, ItemStack> helmetStacks = new HashMap();
    private HashMap<String, ItemStack> chestplateStacks = new HashMap();
    private HashMap<String, ItemStack> leggingsStacks = new HashMap();
    private HashMap<String, ItemStack> bootsStacks = new HashMap();

    public MetalSet(String setName) {
        this.name = setName;
        this.setTag = this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
        this.initDefaults();
    }

    private MetalBlock createBlock(MetalBlock metalBlock, int meta, int harvestLvl, String metalTag, String identifier) {
        metalBlock.setHarvestLevel("pickaxe", harvestLvl, meta);
        if (meta == 0) {
            GameRegistry.registerBlock((Block)metalBlock, ItemMetalBlock.class, (String)(this.name + "." + identifier));
        }
        OreDictionary.registerOre((String)(identifier + metalTag), (ItemStack)new ItemStack((Block)metalBlock, 1, meta));
        return metalBlock;
    }

    private MetalItem createItem(MetalItem metalItem, int meta, String metalTag, String identifier) {
        if (meta == 0) {
            GameRegistry.registerItem((Item)metalItem, (String)(this.name + "." + identifier));
        }
        OreDictionary.registerOre((String)(identifier + metalTag), (ItemStack)new ItemStack((Item)metalItem, 1, meta));
        return metalItem;
    }

    public ItemStack getAxe(String metal) {
        return this.axeStacks.get(metal);
    }

    public ItemStack getBlock(String metal) {
        return this.blockStacks.get(metal);
    }

    public ItemStack getBoots(String metal) {
        return this.bootsStacks.get(metal);
    }

    public ItemStack getBrick(String metal) {
        return this.brickStacks.get(metal);
    }

    public ItemStack getChestplate(String metal) {
        return this.chestplateStacks.get(metal);
    }

    public ItemStack getDrop(String metal) {
        return this.dropStacks.get(metal);
    }

    public ItemStack getDust(String metal) {
        return this.dustStacks.get(metal);
    }

    public ItemStack getHelmet(String metal) {
        return this.helmetStacks.get(metal);
    }

    public ItemStack getHoe(String metal) {
        return this.hoeStacks.get(metal);
    }

    public ItemStack getIngot(String metal) {
        return this.ingotStacks.get(metal);
    }

    public ItemStack getLeggings(String metal) {
        return this.leggingsStacks.get(metal);
    }

    public ItemStack getOre(String metal) {
        return this.oreStacks.get(metal);
    }

    public ItemStack getPickaxe(String metal) {
        return this.pickaxeStacks.get(metal);
    }

    public ItemStack getShovel(String metal) {
        return this.shovelStacks.get(metal);
    }

    public ItemStack getSword(String metal) {
        return this.swordStacks.get(metal);
    }

    private void initDefaults() {
        String postfix = this.name.toLowerCase();
        postfix = postfix.replace(" ", ".");
        this.defaultOre = new MetalBlock(postfix + ".ore");
        this.defaultBlock = new MetalBlock(postfix + ".block");
        this.defaultBricks = new MetalBlock(postfix + ".brick");
        this.defaultDust = new MetalItem(postfix + ".dust");
        this.defaultDrops = new MetalItem(postfix + ".item");
    }

    public void load(InputStream inputStream) {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(inputStream, "UTF-8");
        }
        catch (IOException e) {
            LogHandler.log((String)e.getLocalizedMessage());
        }
        for (Metal metal : this.metals = (Metal[])new Gson().fromJson((Reader)reader, Metal[].class)) {
            String identifier;
            if (metal.type == Metal.MetalType.Default) continue;
            MetalBlock ore = null;
            MetalBlock block = null;
            MetalBlock brick = null;
            MetalItem dust = null;
            MetalItem ingot = null;
            MetalItem item = null;
            String texture = metal.getName().replace(" ", "_");
            texture = "Metallurgy:" + this.name + "/" + texture.toLowerCase();
            String tag = metal.getName().replace(" ", "");
            String configTag = tag.substring(0, 1).toUpperCase() + tag.substring(1);
            int metaId = metal.meta;
            if (metal.type != Metal.MetalType.Drop) {
                identifier = "dust";
                dust = this.createItem(this.defaultDust, metaId, tag, identifier);
                dust.addSubItem(metaId, metal.getName(), 0, texture + "_" + identifier);
                this.dustStacks.put(tag, new ItemStack((Item)dust, 1, metaId));
            }
            if (metal.type != Metal.MetalType.Drop) {
                identifier = "ingot";
                ingot = new MetalItem(configTag + "." + identifier);
                ingot.addSubItem(0, metal.getName(), 1, texture + "_" + identifier);
                OreDictionary.registerOre((String)(identifier + tag), (ItemStack)new ItemStack((Item)ingot, 1, 0));
                String registryName = metal.getName().toLowerCase();
                registryName = registryName.replace(" ", ".");
                registryName = registryName + "." + identifier;
                GameRegistry.registerItem((Item)ingot, (String)registryName);
                this.ingotStacks.put(tag, new ItemStack((Item)ingot));
            }
            if (metal.type == Metal.MetalType.Drop) {
                identifier = "item";
                item = this.createItem(this.defaultDrops, metaId, tag, identifier);
                String itemName = metal.dropName;
                String itemTexture = metal.dropName.replace(" ", "_");
                itemTexture = "Metallurgy:" + this.name + "/" + itemTexture.toLowerCase();
                if (itemName.compareTo("") == 0) {
                    itemName = metal.getName();
                    itemTexture = texture;
                }
                item.addSubItem(metaId, itemName, 2, itemTexture);
                this.dropStacks.put(tag, new ItemStack((Item)item, 1, metaId));
            }
            if (metal.type != Metal.MetalType.Alloy) {
                identifier = "ore";
                if (metal.type != Metal.MetalType.Respawn) {
                    ore = this.createBlock(this.defaultOre, metaId, metal.blockLvl, tag, identifier);
                    item = this.defaultDrops;
                    if (metal.type == Metal.MetalType.Drop) {
                        ore.addSubBlock(metaId, metal.getName(), 0, texture + "_" + identifier, item);
                    } else {
                        ore.addSubBlock(metaId, metal.getName(), 0, texture + "_" + identifier);
                    }
                    if (metal.haveParticles()) {
                        int type = metal.getParticleType();
                        int[] colors = metal.getParticleColors();
                        ore.setSubBlockParticles(metaId, type, colors[0], colors[1], colors[2]);
                    }
                    this.oreStacks.put(tag, new ItemStack((Block)ore, 1, metaId));
                }
                if (ConfigHandler.generates((String)tag)) {
                    String dims = ConfigHandler.getOreGenerationDimInfo((String)configTag, (String)metal.dimensions);
                    int[] genInfo = ConfigHandler.getOreGenerationInformation((String)configTag, (int[])metal.generation);
                    WorldGenMetals worldGen = new WorldGenMetals(ore, metaId, genInfo, dims);
                    GameRegistry.registerWorldGenerator((IWorldGenerator)worldGen, (int)5);
                }
            }
            if (metal.type != Metal.MetalType.Drop && metal.type != Metal.MetalType.Respawn) {
                identifier = "block";
                block = this.createBlock(this.defaultBlock, metaId, metal.blockLvl, tag, identifier);
                block.addSubBlock(metaId, metal.getName(), 1, texture + "_" + identifier);
                this.blockStacks.put(tag, new ItemStack((Block)block, 1, metaId));
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)block, 1, metaId), (Object[])new Object[]{"iii", "iii", "iii", Character.valueOf('i'), ingot});
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)ingot, 9), (Object[])new Object[]{new ItemStack((Block)block, 1, metaId)});
            }
            if (metal.type != Metal.MetalType.Drop && metal.type != Metal.MetalType.Respawn) {
                identifier = "brick";
                brick = this.createBlock(this.defaultBricks, metaId, metal.blockLvl, tag, identifier);
                brick.addSubBlock(metaId, metal.getName(), 2, texture + "_" + identifier);
                this.brickStacks.put(metal.getName(), new ItemStack((Block)brick, 1, metaId));
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)brick, 1, metaId), (Object[])new Object[]{"ii", "ii", Character.valueOf('i'), ingot});
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)ingot, 4), (Object[])new Object[]{new ItemStack((Block)brick, 1, metaId)});
            }
            if (metal.alloyRecipe != null && metal.alloyRecipe.length == 2) {
                String ore1 = metal.alloyRecipe[0];
                String ore2 = metal.alloyRecipe[1];
                ore1.replace(" ", "");
                ore2.replace(" ", "");
                ore1 = "dust" + ore1;
                ore2 = "dust" + ore2;
                Utils.alloys.put(tag, new String[]{ore1, ore2});
                Utils.requireAlloyer.put(tag, metal.isAlloyerRequired());
            }
            if (ingot != null && metal.haveTools()) {
                String statsName = metal.getName().toUpperCase();
                statsName = statsName.replace(" ", "_");
                int harvestLevel = metal.getToolHarvestLevel();
                int maxUses = metal.getToolDurability();
                int efficiency = metal.getToolEncantabilty();
                int damage = metal.getToolDamage();
                int enchantability = metal.getToolEncantabilty();
                Item.ToolMaterial toolMaterial = EnumHelper.addToolMaterial((String)statsName, (int)harvestLevel, (int)maxUses, (float)efficiency, (float)damage, (int)enchantability);
                toolMaterial.customCraftingMaterial = ingot;
                String toolUName = metal.getName().toLowerCase();
                toolUName = toolUName.replace(" ", ".");
                String axeTexture = texture + "_" + "axe";
                String axeUName = toolUName + ".axe";
                Axe axe = new Axe(toolMaterial, axeUName, axeTexture);
                axe.setHarvestLevel("axe", harvestLevel);
                GameRegistry.registerItem((Item)axe, (String)axeUName);
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)axe), (Object[])new Object[]{"iii", "is ", " s ", Character.valueOf('i'), ingot, Character.valueOf('s'), Items.field_151055_y});
                this.axeStacks.put(tag, new ItemStack((Item)axe));
                String hoeTexture = texture + "_" + "hoe";
                String hoeUName = toolUName + ".hoe";
                Hoe hoe = new Hoe(toolMaterial, hoeUName, hoeTexture);
                hoe.setHarvestLevel("hoe", harvestLevel);
                GameRegistry.registerItem((Item)hoe, (String)hoeUName);
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)hoe), (Object[])new Object[]{"ii ", " s ", " s ", Character.valueOf('i'), ingot, Character.valueOf('s'), Items.field_151055_y});
                this.hoeStacks.put(tag, new ItemStack((Item)hoe));
                String pickaxeTexture = texture + "_" + "pick";
                String pickaxeUName = toolUName + ".pickaxe";
                Pickaxe pickaxe = new Pickaxe(toolMaterial, pickaxeUName, pickaxeTexture);
                pickaxe.setHarvestLevel("pickaxe", harvestLevel);
                GameRegistry.registerItem((Item)pickaxe, (String)pickaxeUName);
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)pickaxe), (Object[])new Object[]{"iii", " s ", " s ", Character.valueOf('i'), ingot, Character.valueOf('s'), Items.field_151055_y});
                this.pickaxeStacks.put(tag, new ItemStack((Item)pickaxe));
                String shovelTexture = texture + "_" + "shovel";
                String shovelUName = toolUName + ".shovel";
                Shovel shovel = new Shovel(toolMaterial, shovelUName, shovelTexture);
                shovel.setHarvestLevel("shovel", harvestLevel);
                GameRegistry.registerItem((Item)shovel, (String)shovelUName);
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)shovel), (Object[])new Object[]{"i", "s", "s", Character.valueOf('i'), ingot, Character.valueOf('s'), Items.field_151055_y});
                this.shovelStacks.put(tag, new ItemStack((Item)shovel));
                String swordTexture = texture + "_" + "sword";
                String swordUName = toolUName + ".sword";
                Sword sword = new Sword(toolMaterial, swordUName, swordTexture);
                if (metal.haveEntityEffects()) {
                    int effectId = metal.getEffectId();
                    int effectDura = metal.getEffectDuration();
                    int effectAmp = metal.getEffectAmplifier();
                    int effectRec = metal.getEffectReceiver();
                    sword.addEffect(effectId, effectDura, effectAmp, effectRec);
                }
                GameRegistry.registerItem((Item)sword, (String)swordUName);
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)sword), (Object[])new Object[]{"i", "i", "s", Character.valueOf('i'), ingot, Character.valueOf('s'), Items.field_151055_y});
                this.swordStacks.put(tag, new ItemStack((Item)sword));
            }
            if (ingot == null || !metal.haveArmor()) continue;
            String modelTexture = metal.getName().replace(" ", "_").toLowerCase();
            modelTexture = this.name.toLowerCase() + "/" + modelTexture;
            String armorUName = metal.getName().toLowerCase();
            armorUName = armorUName.replace(" ", ".");
            armorUName = "Metallurgy".toLowerCase() + "." + armorUName;
            int mutiplier = metal.getArmorMultiplier();
            int[] damageReduction = metal.getArmorDamageReduction();
            int enchantablilty = metal.getArmorEnchantability();
            ItemArmor.ArmorMaterial armorMaterial = EnumHelper.addArmorMaterial((String)armorUName, (int)mutiplier, (int[])damageReduction, (int)enchantablilty);
            armorMaterial.customCraftingMaterial = ingot;
            int renderIndex = 3;
            String helmetIconTexture = texture + "_helmet";
            String helmetUName = armorUName + ".helmet";
            ItemMetallurgyArmor helmet = new ItemMetallurgyArmor(armorMaterial, renderIndex, 0, modelTexture);
            helmet = (ItemMetallurgyArmor)helmet.func_77655_b(helmetUName);
            helmet = (ItemMetallurgyArmor)helmet.func_111206_d(helmetIconTexture);
            GameRegistry.registerItem((Item)helmet, (String)helmetUName);
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)helmet), (Object[])new Object[]{"iii", "i i", Character.valueOf('i'), ingot});
            this.helmetStacks.put(tag, new ItemStack((Item)helmet));
            String chestplateIconTexture = texture + "_chest";
            String chestplateUName = armorUName + ".chestplate";
            ItemMetallurgyArmor chestplate = new ItemMetallurgyArmor(armorMaterial, renderIndex, 1, modelTexture);
            chestplate = (ItemMetallurgyArmor)chestplate.func_77655_b(chestplateUName);
            chestplate = (ItemMetallurgyArmor)chestplate.func_111206_d(chestplateIconTexture);
            GameRegistry.registerItem((Item)chestplate, (String)chestplateUName);
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)chestplate), (Object[])new Object[]{"i i", "iii", "iii", Character.valueOf('i'), ingot});
            this.chestplateStacks.put(tag, new ItemStack((Item)chestplate));
            String leggingsIconTexture = texture + "_legs";
            String leggingsUName = armorUName + ".leggings";
            ItemMetallurgyArmor leggings = new ItemMetallurgyArmor(armorMaterial, renderIndex, 2, modelTexture);
            leggings = (ItemMetallurgyArmor)leggings.func_77655_b(leggingsUName);
            leggings = (ItemMetallurgyArmor)leggings.func_111206_d(leggingsIconTexture);
            GameRegistry.registerItem((Item)leggings, (String)leggingsUName);
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)leggings), (Object[])new Object[]{"iii", "i i", "i i", Character.valueOf('i'), ingot});
            this.leggingsStacks.put(tag, new ItemStack((Item)leggings));
            String bootsIconTexture = texture + "_boots";
            String bootsUName = armorUName + ".boots";
            ItemMetallurgyArmor boots = new ItemMetallurgyArmor(armorMaterial, renderIndex, 3, modelTexture);
            boots = (ItemMetallurgyArmor)boots.func_77655_b(bootsUName);
            boots = (ItemMetallurgyArmor)boots.func_111206_d(bootsIconTexture);
            GameRegistry.registerItem((Item)boots, (String)bootsUName);
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)boots), (Object[])new Object[]{"i i", "i i", Character.valueOf('i'), ingot});
            this.bootsStacks.put(tag, new ItemStack((Item)boots));
        }
    }
}

