/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.metallurgy.metals;

import com.teammetallurgy.metallurgy.Metallurgy;
import com.teammetallurgy.metallurgy.handlers.ParticleHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class MetalBlock
extends Block {
    private HashMap<Integer, String> names = new HashMap();
    private HashMap<Integer, Integer> blockTypes = new HashMap();
    private HashMap<Integer, Item> drops = new HashMap();
    private HashMap<Integer, String> textures = new HashMap();
    private HashMap<Integer, IIcon> icons = new HashMap();
    private HashMap<Integer, int[]> particles = new HashMap();

    public MetalBlock(String postfix) {
        super(Material.field_151576_e);
        this.init(postfix);
    }

    public void addSubBlock(int meta, String name, int blockType, String texture) {
        this.addSubBlock(meta, name, blockType, texture, null);
    }

    public void addSubBlock(int meta, String name, int blockType, String texture, Item drop) {
        this.names.put(meta, name);
        if (blockType < 0 || blockType > 2) {
            blockType = 0;
        }
        this.blockTypes.put(meta, blockType);
        this.textures.put(meta, texture);
        this.drops.put(meta, drop);
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (this.icons.containsKey(meta)) {
            return this.icons.get(meta);
        }
        return this.field_149761_L;
    }

    public Item func_149650_a(int meta, Random par2Random, int par3) {
        Item item = Item.func_150898_a((Block)this);
        if (this.drops.get(meta) != null) {
            item = this.drops.get(meta);
        }
        return item;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (Map.Entry<Integer, String> name : this.names.entrySet()) {
            list.add(new ItemStack(item, 1, name.getKey().intValue()));
        }
    }

    public String getUnlocalizedName(int meta) {
        if (this.names.get(meta) != null) {
            String unlocalizedName = this.names.get(meta);
            unlocalizedName = unlocalizedName.replace(" ", ".").toLowerCase();
            String blockType = "";
            switch (this.blockTypes.get(meta)) {
                case 0: {
                    blockType = ".ore";
                    break;
                }
                case 1: {
                    blockType = ".block";
                    break;
                }
                case 2: {
                    blockType = ".brick";
                }
            }
            String prefix = "tile." + "Metallurgy".toLowerCase() + ".";
            return prefix + unlocalizedName + blockType;
        }
        return this.func_149739_a();
    }

    private void init(String posfix) {
        this.func_149658_d("Metallurgy:metal_block_default");
        this.func_149663_c("metal.block." + posfix);
        this.func_149647_a((CreativeTabs)Metallurgy.instance.creativeTabBlocks);
        this.func_149711_c(3.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int blockX, int blockY, int blockZ, Random rand) {
        int meta = world.func_72805_g(blockX, blockY, blockZ);
        if (!this.particles.containsKey(meta)) {
            return;
        }
        int[] particle = this.particles.get(meta);
        ParticleHandler.renderOreParticle(world, blockX, blockY, blockZ, rand, particle);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a(this.func_149641_N());
        for (Map.Entry<Integer, String> texture : this.textures.entrySet()) {
            int meta = texture.getKey();
            String textureName = texture.getValue();
            IIcon icon = register.func_94245_a(textureName);
            this.icons.put(meta, icon);
        }
    }

    public void setSubBlockParticles(int meta, int type, int red, int green, int blue) {
        int[] settings = new int[]{type, red, green, blue};
        this.particles.put(meta, settings);
    }
}

