/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.metallurgycore.handlers;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    private static Configuration configuration;

    public static boolean generates(String name) {
        boolean b = configuration.get("Generators", name, true).getBoolean(true);
        ConfigHandler.saveChanges();
        return b;
    }

    @Deprecated
    public static int getBlock(String blockName, int defaultid) {
        return defaultid;
    }

    @Deprecated
    public static int getBlock(String category, String blockName, int defaultid) {
        return defaultid;
    }

    private static boolean getBoolean(String categories, String key, boolean defaultValue) {
        boolean b = configuration.get(categories, key, defaultValue).getBoolean(defaultValue);
        ConfigHandler.saveChanges();
        return b;
    }

    @Deprecated
    public static int getItem(String itemName, int defaultid) {
        return defaultid;
    }

    @Deprecated
    public static int getItem(String category, String itemName, Integer defaultid) {
        return defaultid;
    }

    private static String getName(String categories, String key, String defaultValue) {
        String string = configuration.get(categories, key, defaultValue).toString();
        ConfigHandler.saveChanges();
        return string;
    }

    public static String getOreGenerationDimInfo(String oreTag, String defaultDimensions) {
        String dimInfo = configuration.get("Generators." + oreTag, "dimensions", defaultDimensions).getString();
        return dimInfo;
    }

    public static int[] getOreGenerationInformation(String oreTag, int[] defaultInfo) {
        int veinsPerChunk = configuration.get("Generators." + oreTag, "veins_per_chunk", defaultInfo[0]).getInt(defaultInfo[0]);
        int oresPreVein = configuration.get("Generators." + oreTag, "ores_per_vein", defaultInfo[1]).getInt(defaultInfo[1]);
        int minYLevel = configuration.get("Generators." + oreTag, "min_Y_level", defaultInfo[2]).getInt(defaultInfo[2]);
        int maxYLevel = configuration.get("Generators." + oreTag, "max_Y_level", defaultInfo[3]).getInt(defaultInfo[3]);
        int chunkChance = configuration.get("Generators." + oreTag, "chunk_chance", defaultInfo[4]).getInt(defaultInfo[4]);
        int[] generationInfo = new int[]{veinsPerChunk, oresPreVein, minYLevel, maxYLevel, chunkChance};
        return generationInfo;
    }

    public static boolean itemEnabled(String itemName) {
        boolean b = configuration.get("Items", itemName, true).getBoolean(true);
        ConfigHandler.saveChanges();
        return b;
    }

    public static boolean regen() {
        return ConfigHandler.getBoolean("World_Regen", "regenOres", false);
    }

    public static String regenKey() {
        return ConfigHandler.getName("World_Regen", "regen_key", "DEFAULT");
    }

    private static void saveChanges() {
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static boolean setEnabled(String setName) {
        boolean b = configuration.get("Sets", setName, true).getBoolean(true);
        ConfigHandler.saveChanges();
        return b;
    }

    public static void setFile(File file) {
        configuration = new Configuration(file);
        configuration.load();
        ConfigHandler.saveChanges();
    }
}

