/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.metallurgy.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.teammetallurgy.metallurgy.machines.crusher.GUICrusher;
import com.teammetallurgy.metallurgy.recipes.CrusherRecipes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class CrusherHandler
extends TemplateRecipeHandler {
    public String getGuiTexture() {
        return "metallurgy:textures/gui/nei_crusher.png";
    }

    public String getRecipeName() {
        return "Crusher Recipe";
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GUICrusher.class;
    }

    public void loadCraftingRecipes(ItemStack result) {
        HashMap<ItemStack, ItemStack> recipes = CrusherRecipes.getInstance().getInput(result);
        if (recipes != null && !recipes.isEmpty()) {
            for (Map.Entry<ItemStack, ItemStack> recipe : recipes.entrySet()) {
                NEICrusherRecipe neiRecipe = new NEICrusherRecipe(recipe.getKey(), recipe.getValue());
                this.arecipes.add(neiRecipe);
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ItemStack result = CrusherRecipes.getInstance().getCrushingResult(ingredient);
        if (result != null) {
            NEICrusherRecipe neiRecipe = new NEICrusherRecipe(ingredient, result);
            this.arecipes.add(neiRecipe);
        }
    }

    private class NEICrusherRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;

        public NEICrusherRecipe(ItemStack input, ItemStack craftingResult) {
            super((TemplateRecipeHandler)CrusherHandler.this);
            this.result = new PositionedStack((Object)craftingResult, 75, 48);
            this.ingredients = new ArrayList();
            this.setIngredients(input, craftingResult);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(CrusherHandler.this.cycleticks / 20, this.ingredients);
        }

        private void setIngredients(ItemStack input, ItemStack output) {
            PositionedStack stack = new PositionedStack((Object)input, 75, 3);
            stack.setMaxSize(1);
            this.ingredients.add(stack);
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

