/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.metallurgy.metals;

public class Metal {
    private String name;
    public MetalType type;
    public int meta;
    public int abstractorXp;
    public int blockLvl;
    public String[] alloyRecipe;
    public boolean requireAlloyer;
    public String dropName;
    public int[] dropRate;
    public int[] equipment;
    public int[] entityEffect;
    public int[] particleEffect;
    public int[] dugeonLoot;
    public int[] generation;
    public String dimensions;

    public String getName() {
        return this.name;
    }

    public int getToolDamage() {
        if (this.haveTools()) {
            return this.equipment[2];
        }
        return -1;
    }

    public int getToolDurability() {
        if (this.haveTools()) {
            return this.equipment[1];
        }
        return -1;
    }

    public int getToolEfficiency() {
        if (this.haveTools()) {
            return this.equipment[3];
        }
        return -1;
    }

    public int getToolEncantabilty() {
        if (this.haveTools()) {
            return this.equipment[4];
        }
        return -1;
    }

    public int getToolHarvestLevel() {
        if (this.haveTools()) {
            return this.equipment[0];
        }
        return -1;
    }

    public boolean haveTools() {
        return this.equipment != null && this.equipment.length >= 5;
    }

    public boolean haveArmor() {
        return this.equipment != null && this.equipment.length >= 10;
    }

    public int getArmorMultiplier() {
        if (this.haveArmor()) {
            return this.equipment[9];
        }
        return -1;
    }

    public int[] getArmorDamageReduction() {
        if (this.haveArmor()) {
            int[] damageReduction = new int[]{this.equipment[5], this.equipment[6], this.equipment[7], this.equipment[8]};
            return damageReduction;
        }
        return null;
    }

    public int getArmorEnchantability() {
        if (this.haveArmor()) {
            return this.equipment[4];
        }
        return -1;
    }

    public boolean haveEntityEffects() {
        return this.entityEffect != null && this.entityEffect.length == 4;
    }

    public int getEffectId() {
        if (this.haveEntityEffects()) {
            return this.entityEffect[0];
        }
        return -1;
    }

    public int getEffectDuration() {
        if (this.haveEntityEffects()) {
            return this.entityEffect[1];
        }
        return -1;
    }

    public int getEffectAmplifier() {
        if (this.haveEntityEffects()) {
            return this.entityEffect[2];
        }
        return -1;
    }

    public int getEffectReceiver() {
        if (this.haveEntityEffects()) {
            return this.entityEffect[3];
        }
        return -1;
    }

    public boolean haveParticles() {
        return this.particleEffect != null && this.particleEffect.length >= 4;
    }

    public int getParticleType() {
        if (this.haveParticles()) {
            return this.particleEffect[0];
        }
        return -1;
    }

    public int[] getParticleColors() {
        if (this.haveParticles()) {
            int[] colors = new int[]{this.particleEffect[1], this.particleEffect[2], this.particleEffect[3]};
            return colors;
        }
        return null;
    }

    public boolean isAlloyerRequired() {
        return this.requireAlloyer;
    }

    public static enum MetalType {
        Respawn,
        Ore,
        Catalyst,
        Alloy,
        Drop,
        Default;

    }
}

