/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.metallurgy.machines.forge;

import com.teammetallurgy.metallurgycore.machines.TileEntityMetallurgySided;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityForge
extends TileEntityMetallurgySided
implements IFluidHandler {
    FluidTank tank = new FluidTank(10000);

    public TileEntityForge() {
        super(2, new int[]{0}, new int[]{0}, new int[]{1});
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return FluidRegistry.LAVA.equals(fluid);
    }

    protected boolean hasMaterialAndRoom(ItemStack ... itemStacks) {
        if (this.tank.getFluidAmount() <= 0) {
            return false;
        }
        return super.hasMaterialAndRoom(itemStacks);
    }

    protected boolean preProcessItem() {
        FluidStack drain = this.tank.drain(100, false);
        if (drain.amount == 100) {
            this.tank.drain(drain.amount, true);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        FluidEvent.FluidDrainingEvent fluidDrainingEvent = new FluidEvent.FluidDrainingEvent(resource, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, (IFluidTank)this.tank);
        FluidEvent.fireEvent((FluidEvent)fluidDrainingEvent);
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.tank.drain(maxDrain, doDrain);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        FluidEvent.FluidFillingEvent fluidFillingEvent = new FluidEvent.FluidFillingEvent(resource, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, (IFluidTank)this.tank);
        FluidEvent.fireEvent((FluidEvent)fluidFillingEvent);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.tank.fill(resource, doFill);
    }

    public int func_70297_j_() {
        return 64;
    }

    public String func_145825_b() {
        return "container.forge";
    }

    protected ItemStack getSmeltingResult(ItemStack ... itemStack) {
        return FurnaceRecipes.func_77602_a().func_151395_a(itemStack[0]);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public boolean isBurning() {
        return this.tank.getFluidAmount() > 0;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i != 1;
    }

    protected void readCustomNBT(NBTTagCompound data) {
        super.readCustomNBT(data);
        this.tank = this.tank.readFromNBT(data);
    }

    protected void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        this.tank.writeToNBT(compound);
    }

    protected int getFuelSlot() {
        return 1;
    }

    protected int[] getInputSlots() {
        return new int[]{0};
    }

    protected int[] getOutputSlots() {
        return new int[]{1};
    }
}

