/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.metallurgy;

import com.google.common.io.Resources;
import com.teammetallurgy.metallurgy.Metallurgy;
import com.teammetallurgy.metallurgy.machines.alloyer.BlockAlloyer;
import com.teammetallurgy.metallurgy.machines.alloyer.TileEntityAlloyer;
import com.teammetallurgy.metallurgy.machines.crusher.BlockCrusher;
import com.teammetallurgy.metallurgy.machines.crusher.TileEntityCrusher;
import com.teammetallurgy.metallurgy.machines.forge.BlockForge;
import com.teammetallurgy.metallurgy.machines.forge.TileEntityForge;
import com.teammetallurgy.metallurgy.machines.frame.BlockFrame;
import com.teammetallurgy.metallurgy.metals.MetalSet;
import com.teammetallurgy.metallurgy.metals.VanillaMetals;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BlockList {
    private static Block machineFrame;
    private static Block crusher;
    private static Block alloyer;
    private static Block forge;
    private static Map<String, MetalSet> setList;

    public static MetalSet getSet(String name) {
        return setList.get(name);
    }

    public static void init() {
        String blockName = "machine.frame";
        machineFrame = new BlockFrame().func_149663_c(blockName);
        BlockList.registerBlock(machineFrame, blockName);
        blockName = "crusher";
        crusher = new BlockCrusher().func_149663_c(blockName);
        BlockList.registerBlockWithTileEntity(crusher, TileEntityCrusher.class, blockName);
        blockName = "alloyer";
        alloyer = new BlockAlloyer().func_149663_c(blockName);
        BlockList.registerBlockWithTileEntity(alloyer, TileEntityAlloyer.class, blockName);
        blockName = "forge";
        forge = new BlockForge().func_149663_c(blockName);
        BlockList.registerBlockWithTileEntity(forge, TileEntityForge.class, blockName);
        BlockList.initMetalSets();
        VanillaMetals.initBlocks();
    }

    private static void initMetalSets() {
        String[] sets;
        File directory = new File(Metallurgy.instance.modsPath());
        File[] listFiles = directory.listFiles();
        ArrayList<String> zipDirs = new ArrayList<String>();
        for (File file : listFiles) {
            if (!file.getName().contains(".zip") || !file.getName().startsWith("Metallurgy-Addon-")) continue;
            try {
                zipDirs.add(file.getCanonicalPath());
            }
            catch (IOException e) {}
            break;
        }
        for (String zipDir : zipDirs) {
            try {
                BlockList.readPackZip(zipDir);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (String set : sets = new String[]{"base", "ender", "fantasy", "nether", "precious", "utility"}) {
            String path = "assets/metallurgy/data/";
            URL resource = Resources.getResource((String)(path + set + ".json"));
            try {
                BlockList.injectMetalSet(set, resource.openStream());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public static void initRecipies() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(machineFrame), new Object[]{"ici", "cic", "ici", Character.valueOf('c'), "ingotCopper", Character.valueOf('i'), Items.field_151042_j}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(crusher), new Object[]{"ccc", "imi", "ifi", Character.valueOf('c'), "ingotCopper", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('m'), new ItemStack(machineFrame), Character.valueOf('f'), Blocks.field_150460_al}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(alloyer), new Object[]{"aaa", "dmd", "dfd", Character.valueOf('a'), "ingotAngmallen", Character.valueOf('d'), "ingotDamascusSteel", Character.valueOf('m'), new ItemStack(machineFrame), Character.valueOf('f'), Blocks.field_150460_al}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(forge), new Object[]{"iii", "sms", "sfs", Character.valueOf('i'), "ingotIgnatius", Character.valueOf('s'), "ingotShadowSteel", Character.valueOf('m'), new ItemStack(machineFrame), Character.valueOf('f'), Blocks.field_150460_al}));
    }

    private static void injectMetalSet(String name, InputStream stream) throws IOException {
        MetalSet metalSet = new MetalSet(name);
        metalSet.load(stream);
        setList.put(name, metalSet);
    }

    private static void readPackZip(String zipDir) throws IOException {
        ZipFile zipFile = new ZipFile(zipDir);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry nextElement = entries.nextElement();
            String name = nextElement.getName();
            if (nextElement.isDirectory() || !name.contains(".json")) continue;
            Metallurgy.proxy.injectZipAsResource(zipDir);
            InputStream stream = zipFile.getInputStream(nextElement);
            BlockList.injectMetalSet(name.substring(name.lastIndexOf("/") + 1, name.lastIndexOf(".")), stream);
        }
        zipFile.close();
    }

    private static void registerBlock(Block block, String name) {
        GameRegistry.registerBlock((Block)block, (String)("Metallurgy:" + name));
    }

    private static void registerBlockWithTileEntity(Block block, Class<? extends TileEntity> teClass, String blockName) {
        BlockList.registerBlock(block, blockName);
        BlockList.registerTileEntity(teClass, blockName);
    }

    private static void registerTileEntity(Class<? extends TileEntity> clazz, String blockName) {
        GameRegistry.registerTileEntity(clazz, (String)("Metallurgy:" + blockName));
    }

    public static Block getAlloyer() {
        return alloyer;
    }

    public static Block getMachineFrame() {
        return machineFrame;
    }

    public static Block getCrusher() {
        return crusher;
    }

    public static Block getForge() {
        return forge;
    }

    static {
        setList = new HashMap<String, MetalSet>();
    }
}

