/*
 * Decompiled with CFR 0.152.
 */
import elliandetector.EllianDetector;
import elliandetector.EllianHelpMessages;
import elliandetector.Material;
import org.lwjgl.input.Keyboard;

public class EllianGuiMaterialEditorScreen
extends EllianGUIScreenInterface {
    private EllianGuiTextField blockId;
    private EllianGuiTextField blockIdSub;
    private EllianGuiSimpleButton cancelButton;
    private EllianDetector detector;
    private Material material;
    private Material materialBackup;
    private EllianGuiTextField nameTextField;
    private EllianGuiSimpleButton okButton;
    private EllianGuiMaterialScreen parent;
    private EllianGuiScrollbar[] rgb;

    private static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public EllianGuiMaterialEditorScreen(EllianDetector detector, EllianGuiMaterialScreen guimaterialscreen, Material material) {
        this(detector, material);
        this.detector = detector;
        this.parent = guimaterialscreen;
    }

    public EllianGuiMaterialEditorScreen(EllianDetector detector, Material material1) {
        this.material = material1;
        this.detector = detector;
        this.materialBackup = material1 != null ? new Material(material1) : null;
        String s = material1 == null ? "" : material1.getName();
        this.nameTextField = new EllianGuiTextField(s);
        this.nameTextField.setInputType(0);
        this.nameTextField.active();
        this.blockId = new EllianGuiTextField();
        if (this.material != null) {
            this.blockId = new EllianGuiTextField(Integer.toString(this.material.getBlockId()));
        }
        this.blockId.setInputType(1);
        this.blockIdSub = new EllianGuiTextField();
        if (this.material != null && this.material.getSubType() != 0) {
            this.blockIdSub = new EllianGuiTextField(Integer.toString(this.material.getSubType()));
        }
        this.blockIdSub.setInputType(1);
        this.nameTextField.setPrev(this.blockIdSub);
        this.nameTextField.setNext(this.blockId);
        this.blockId.setNext(this.blockIdSub);
        this.blockId.setPrev(this.nameTextField);
        this.blockIdSub.setNext(this.nameTextField);
        this.blockIdSub.setPrev(this.blockId);
        this.rgb = new EllianGuiScrollbar[3];
        int l = 0;
        while (l < 3) {
            EllianGuiScrollbar guiscrollbar = new EllianGuiScrollbar(0, 0, 0, 118, 10);
            guiscrollbar.setMinimum(0.0f);
            guiscrollbar.setMaximum(255.0f);
            guiscrollbar.setVisibleAmount(0.0f);
            guiscrollbar.orientation = 1;
            this.rgb[l] = guiscrollbar;
            ++l;
        }
        this.rgb[0].setValue((float)(material1 != null ? (double)material1.getRed() : Math.random()) * 255.0f);
        this.rgb[1].setValue((float)(material1 != null ? (double)material1.getGreen() : Math.random()) * 255.0f);
        this.rgb[2].setValue((float)(material1 != null ? (double)material1.getBlue() : Math.random()) * 255.0f);
    }

    protected void a(bca ct) {
        if (ct == this.okButton) {
            this.accept();
            return;
        }
        if (ct == this.cancelButton) {
            this.cancel();
            return;
        }
        if (ct instanceof EllianGUIHelpButton) {
            this.mine.a((bds)new EllianGuiHelpScreen(this, ((EllianGUIHelpButton)ct).getHelpMessage()));
        }
    }

    protected void a(char c, int i) {
        if (i == 1) {
            this.cancel();
            return;
        }
        if (i == 28 && EllianGuiTextField.getActive() == this.blockId) {
            this.blockId.norm();
            this.accept();
            return;
        }
        EllianGuiTextField.keyType(this.mine, c, i);
    }

    public void a(int i, int j, float floa) {
        String s = "Ellian's Material Detector Add Material";
        int j1 = EllianGUIFontRenderer.ELLIANGUIFONTRENDERER.a(s);
        int k1 = this.width - j1 >> 1;
        int l1 = this.width + j1 >> 1;
        EllianGuiMaterialEditorScreen.a((int)(k1 - 2), (int)(this.height / 2 - 71), (int)(l1 + 2), (int)(this.height / 2 - 57), (int)-1610612736);
        this.a(EllianGUIFontRenderer.ELLIANGUIFONTRENDERER, s, this.width / 2, this.height / 2 - 68, -1);
        EllianGuiMaterialEditorScreen.a((int)((this.width - 150) / 2 - 2), (int)(this.height / 2 - 50), (int)((this.width + 150) / 2 + 2), (int)(this.height / 2 + 52), (int)-1610612736);
        this.a(EllianGUIFontRenderer.ELLIANGUIFONTRENDERER, "Material Name", this.width >> 1, this.height / 2 - 49, -1);
        this.a(EllianGUIFontRenderer.ELLIANGUIFONTRENDERER, "Block Id", this.width >> 1, this.height / 2 - 29, -1);
        this.a(EllianGUIFontRenderer.ELLIANGUIFONTRENDERER, "Sub Id", this.width >> 1, this.height / 2 - 8, -1);
        this.a(EllianGUIFontRenderer.ELLIANGUIFONTRENDERER, "Block Color", this.width >> 1, this.height / 2 + 11, -1);
        if (this.material != null) {
            this.material.setRed(this.rgb[0].getValue() / 255.0f);
            this.material.setGreen(this.rgb[1].getValue() / 255.0f);
            this.material.setBlue(this.rgb[2].getValue() / 255.0f);
        }
        int i2 = (int)this.rgb[0].getValue() & 0xFF;
        int j2 = (int)this.rgb[1].getValue() & 0xFF;
        int k2 = (int)this.rgb[2].getValue() & 0xFF;
        int l2 = 0xFF000000 | i2 << 16 | j2 << 8 | k2;
        this.a(EllianGUIFontRenderer.ELLIANGUIFONTRENDERER, String.format("R:%03d", i2), this.width / 2 - 15, this.height / 2 + 21, -2139062144);
        this.a(EllianGUIFontRenderer.ELLIANGUIFONTRENDERER, String.format("G:%03d", j2), this.width / 2 - 15, this.height / 2 + 31, -2139062144);
        this.a(EllianGUIFontRenderer.ELLIANGUIFONTRENDERER, String.format("B:%03d", k2), this.width / 2 - 15, this.height / 2 + 41, -2139062144);
        EllianGuiMaterialEditorScreen.a((int)(this.width + 90 >> 1), (int)(this.height / 2 + 20), (int)(this.width + 150 >> 1), (int)(this.height / 2 + 50), (int)l2);
        super.a(i, j, floa);
    }

    private void accept() {
        if (this.material != null) {
            this.material.setName(this.nameTextField.j);
            this.material.setBlockId(EllianGuiMaterialEditorScreen.parseInt(this.blockId.j));
            this.material.setSubType(EllianGuiMaterialEditorScreen.parseInt(this.blockIdSub.j));
            this.material.setRed(this.rgb[0].getValue() / 255.0f);
            this.material.setGreen(this.rgb[1].getValue() / 255.0f);
            this.material.setBlue(this.rgb[2].getValue() / 255.0f);
            this.parent.updateMaterial(this.material);
        } else {
            String s = this.nameTextField.j;
            int _i = EllianGuiMaterialEditorScreen.parseInt(this.blockId.j);
            if (s.indexOf(" ") < 0 && _i != 0) {
                float _f = this.rgb[0].getValue() / 255.0f;
                float f1 = this.rgb[1].getValue() / 255.0f;
                float f2 = this.rgb[2].getValue() / 255.0f;
                int _j = EllianGuiMaterialEditorScreen.parseInt(this.blockIdSub.j);
                this.material = new Material(s, true, _i, _j, _f, f1, f2);
                this.parent.addMaterial(this.material);
            }
        }
        this.mine.a((bds)this.parent);
    }

    public void c() {
        Keyboard.enableRepeatEvents((boolean)false);
        super.c();
    }

    private void cancel() {
        if (this.material != null) {
            this.material.set(this.materialBackup);
        }
        this.mine.a((bds)this.parent);
    }

    public void r_() {
        this.initialise();
        Keyboard.enableRepeatEvents((boolean)true);
        int _i = 0;
        while (_i < 3) {
            this.rgb[_i].h = this.width - 150 >> 1;
            this.rgb[_i].i = this.height / 2 + 20 + _i * 10;
            this.buttons.add(this.rgb[_i]);
            ++_i;
        }
        this.nameTextField.setBounds(this.width - 150 >> 1, this.height / 2 - 40, 150, 9);
        this.blockId.setBounds(this.width - 150 >> 1, this.height / 2 - 20, 150, 9);
        this.blockIdSub.setBounds(this.width - 150 >> 1, this.height / 2 + 1, 150, 9);
        this.buttons.add(this.nameTextField);
        this.buttons.add(this.blockId);
        this.buttons.add(this.blockIdSub);
        this.okButton = new EllianGuiSimpleButton(0, this.width / 2 - 65, this.height / 2 + 58, 60, 14, "OK");
        this.cancelButton = new EllianGuiSimpleButton(1, this.width / 2 + 5, this.height / 2 + 58, 60, 14, "Cancel");
        this.buttons.add(this.okButton);
        this.buttons.add(this.cancelButton);
        this.buttons.add(new EllianGUIHelpButton(0, this.width / 2 + 99, this.height / 2 - 70, 12, 12, "?", EllianHelpMessages.Messages.MATERIALEDITOR));
    }
}

