/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.preset;

import java.util.HashMap;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.RenderParameters;
import net.malisis.core.renderer.element.Vertex;
import net.minecraftforge.common.ForgeDirection;

public class FaceData {
    private static ForgeDirection TOP = ForgeDirection.UP;
    private static ForgeDirection BOTTOM = ForgeDirection.DOWN;
    private static ForgeDirection NORTH = ForgeDirection.NORTH;
    private static ForgeDirection SOUTH = ForgeDirection.SOUTH;
    private static ForgeDirection EAST = ForgeDirection.EAST;
    private static ForgeDirection WEST = ForgeDirection.WEST;
    private static HashMap<String, int[]> aom = new HashMap();

    public static void load() {
        FaceData.buildDirectionMatrix();
        RenderParameters rp = new RenderParameters();
        rp.direction = rp.textureSide = BOTTOM;
        rp.colorFactor = Float.valueOf(0.5f);
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.Bottom, (ForgeDirection)rp.direction);
        Face.Bottom.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = TOP;
        rp.colorFactor = Float.valueOf(1.0f);
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.Top, (ForgeDirection)rp.direction);
        Face.Top.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = WEST;
        rp.colorFactor = Float.valueOf(0.6f);
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.West, (ForgeDirection)rp.direction);
        Face.West.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = NORTH;
        rp.colorFactor = Float.valueOf(0.8f);
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.North, (ForgeDirection)rp.direction);
        Face.North.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = EAST;
        rp.colorFactor = Float.valueOf(0.6f);
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.East, (ForgeDirection)rp.direction);
        Face.East.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = SOUTH;
        rp.colorFactor = Float.valueOf(0.8f);
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.South, (ForgeDirection)rp.direction);
        Face.South.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = NORTH;
        rp.colorFactor = Float.valueOf(0.7f);
        rp.aoMatrix = new int[][][]{new int[][]{FaceData.aom("Top"), FaceData.aom("TopEast"), FaceData.aom("TopNorthEast"), FaceData.aom("NorthEast")}, new int[][]{FaceData.aom("Bottom"), FaceData.aom("BottomEast"), FaceData.aom("BottomNorthEast"), FaceData.aom("NorthEast")}, new int[][]{FaceData.aom("Bottom"), FaceData.aom("BottomSouth"), FaceData.aom("BottomSouthWest"), FaceData.aom("SouthWest")}, new int[][]{FaceData.aom("Top"), FaceData.aom("TopSouth"), FaceData.aom("TopSouthWest"), FaceData.aom("SouthWest")}};
        Face.NorthWest.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = EAST;
        rp.colorFactor = Float.valueOf(0.7f);
        rp.aoMatrix = new int[][][]{new int[][]{FaceData.aom("Top"), FaceData.aom("TopSouth"), FaceData.aom("TopSouthEast"), FaceData.aom("SouthEast")}, new int[][]{FaceData.aom("Bottom"), FaceData.aom("BottomSouth"), FaceData.aom("BottomSouthEast"), FaceData.aom("SouthEast")}, new int[][]{FaceData.aom("Bottom"), FaceData.aom("BottomWest"), FaceData.aom("BottomNorthWest"), FaceData.aom("NorthWest")}, new int[][]{FaceData.aom("Top"), FaceData.aom("TopWest"), FaceData.aom("TopNorthWest"), FaceData.aom("NorthWest")}};
        Face.NorthEast.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = WEST;
        rp.colorFactor = Float.valueOf(0.7f);
        rp.aoMatrix = new int[][][]{new int[][]{FaceData.aom("Top"), FaceData.aom("TopNorth"), FaceData.aom("TopNorthWest"), FaceData.aom("NorthWest")}, new int[][]{FaceData.aom("Bottom"), FaceData.aom("BottomNorth"), FaceData.aom("BottomNorthWest"), FaceData.aom("NorthWest")}, new int[][]{FaceData.aom("Bottom"), FaceData.aom("BottomEast"), FaceData.aom("BottomSouthEast"), FaceData.aom("SouthEast")}, new int[][]{FaceData.aom("Top"), FaceData.aom("TopEast"), FaceData.aom("TopSouthEast"), FaceData.aom("SouthEast")}};
        Face.SouthWest.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = SOUTH;
        rp.colorFactor = Float.valueOf(0.7f);
        rp.aoMatrix = new int[][][]{new int[][]{FaceData.aom("Top"), FaceData.aom("TopWest"), FaceData.aom("TopSouthWest"), FaceData.aom("SouthWest")}, new int[][]{FaceData.aom("Bottom"), FaceData.aom("BottomWest"), FaceData.aom("BottomSouthWest"), FaceData.aom("SouthWest")}, new int[][]{FaceData.aom("Bottom"), FaceData.aom("BottomNorth"), FaceData.aom("BottomNorthEast"), FaceData.aom("NorthEast")}, new int[][]{FaceData.aom("Top"), FaceData.aom("TopNorth"), FaceData.aom("TopNortEastWest"), FaceData.aom("NorthEast")}};
        Face.SouthEast.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = TOP;
        rp.colorFactor = Float.valueOf(0.9f);
        rp.aoMatrix = new int[][][]{new int[][]{FaceData.aom("TopSouth"), FaceData.aom("TopSouthEast"), FaceData.aom("TopEast"), FaceData.aom("East")}, new int[][]{FaceData.aom("East"), FaceData.aom("NorthEast"), FaceData.aom("BottomNorthEast"), FaceData.aom("BottomNorth")}, new int[][]{FaceData.aom("BottomNorth"), FaceData.aom("BottomNorthWest"), FaceData.aom("NorthWest"), FaceData.aom("West")}, new int[][]{FaceData.aom("West"), FaceData.aom("TopWest"), FaceData.aom("TopSouthWest"), FaceData.aom("TopSouth")}};
        Face.TopNorth.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = TOP;
        rp.colorFactor = Float.valueOf(0.8f);
        rp.aoMatrix = new int[][][]{new int[][]{FaceData.aom("TopWest"), FaceData.aom("TopSouthWest"), FaceData.aom("TopSouth"), FaceData.aom("South")}, new int[][]{FaceData.aom("South"), FaceData.aom("SouthEast"), FaceData.aom("BottomSouthEast"), FaceData.aom("BottomEast")}, new int[][]{FaceData.aom("BottomEast"), FaceData.aom("BottomNorthEast"), FaceData.aom("NorthEast"), FaceData.aom("East")}, new int[][]{FaceData.aom("North"), FaceData.aom("TopNorth"), FaceData.aom("TopNorthWest"), FaceData.aom("TopWest")}};
        Face.TopEast.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = TOP;
        rp.colorFactor = Float.valueOf(0.9f);
        rp.aoMatrix = new int[][][]{new int[][]{FaceData.aom("TopNorth"), FaceData.aom("TopNorthWest"), FaceData.aom("TopWest"), FaceData.aom("West")}, new int[][]{FaceData.aom("West"), FaceData.aom("SouthWest"), FaceData.aom("BottomSouthWest"), FaceData.aom("BottomSouth")}, new int[][]{FaceData.aom("BottomSouth"), FaceData.aom("BottomSouthEast"), FaceData.aom("SouthEast"), FaceData.aom("East")}, new int[][]{FaceData.aom("East"), FaceData.aom("TopEast"), FaceData.aom("TopNorthEast"), FaceData.aom("TopNorth")}};
        Face.TopSouth.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = TOP;
        rp.colorFactor = Float.valueOf(0.8f);
        rp.aoMatrix = new int[][][]{new int[][]{FaceData.aom("TopEast"), FaceData.aom("TopNorthEast"), FaceData.aom("TopNorth"), FaceData.aom("North")}, new int[][]{FaceData.aom("North"), FaceData.aom("NorthWest"), FaceData.aom("BottomNorthWest"), FaceData.aom("BottomWest")}, new int[][]{FaceData.aom("BottomWest"), FaceData.aom("BottomSouthWest"), FaceData.aom("SouthWest"), FaceData.aom("South")}, new int[][]{FaceData.aom("South"), FaceData.aom("TopSouth"), FaceData.aom("TopSouthEast"), FaceData.aom("TopEast")}};
        Face.TopWest.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = TOP;
        rp.colorFactor = Float.valueOf(0.8f);
        rp.uvFactor = new float[][]{{0.5f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {0.5f, 0.0f}};
        rp.aoMatrix = new int[][][]{new int[][]{FaceData.aom("TopNorthWest"), FaceData.aom("TopNorth"), FaceData.aom("TopWest")}, new int[][]{FaceData.aom("West"), FaceData.aom("SouthWest"), FaceData.aom("Bottom"), FaceData.aom("BottomSouth")}, new int[][]{FaceData.aom("North"), FaceData.aom("NorthEast"), FaceData.aom("Bottom"), FaceData.aom("BottomEast")}, new int[][]{FaceData.aom("TopNorthWest"), FaceData.aom("TopNorth"), FaceData.aom("TopWest")}};
        Face.TopSouthEast.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = TOP;
        rp.colorFactor = Float.valueOf(0.8f);
        rp.uvFactor = new float[][]{{0.5f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {0.5f, 0.0f}};
        rp.aoMatrix = new int[][][]{new int[][]{FaceData.aom("TopNorthEast"), FaceData.aom("TopNorth"), FaceData.aom("TopEast")}, new int[][]{FaceData.aom("North"), FaceData.aom("NorthWest"), FaceData.aom("Bottom"), FaceData.aom("BottomWest")}, new int[][]{FaceData.aom("East"), FaceData.aom("SouthEast"), FaceData.aom("Bottom"), FaceData.aom("BottomSouth")}, new int[][]{FaceData.aom("TopNorthEast"), FaceData.aom("TopNorth"), FaceData.aom("TopEast")}};
        Face.TopSouthWest.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = TOP;
        rp.colorFactor = Float.valueOf(0.8f);
        rp.uvFactor = new float[][]{{0.5f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {0.5f, 0.0f}};
        rp.aoMatrix = new int[][][]{new int[][]{FaceData.aom("TopSouthEast"), FaceData.aom("TopSouth"), FaceData.aom("TopEast")}, new int[][]{FaceData.aom("West"), FaceData.aom("NorthWest"), FaceData.aom("Bottom"), FaceData.aom("BottomNorth")}, new int[][]{FaceData.aom("South"), FaceData.aom("SouthWest"), FaceData.aom("Bottom"), FaceData.aom("BottomWest")}, new int[][]{FaceData.aom("TopSouthEast"), FaceData.aom("TopSouth"), FaceData.aom("TopEast")}};
        Face.TopNorthWest.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = TOP;
        rp.colorFactor = Float.valueOf(0.8f);
        rp.uvFactor = new float[4][2];
        rp.uvFactor = new float[][]{{0.5f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {0.5f, 0.0f}};
        rp.aoMatrix = new int[][][]{new int[][]{FaceData.aom("TopSouthWest"), FaceData.aom("TopSouth"), FaceData.aom("TopWest")}, new int[][]{FaceData.aom("South"), FaceData.aom("SouthEast"), FaceData.aom("Bottom"), FaceData.aom("BottomEast")}, new int[][]{FaceData.aom("West"), FaceData.aom("NorthWest"), FaceData.aom("Bottom"), FaceData.aom("BottomNorth")}, new int[][]{FaceData.aom("TopSouthWest"), FaceData.aom("TopSouth"), FaceData.aom("TopWest")}};
        Face.TopNorthEast.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = TOP;
        rp.colorFactor = Float.valueOf(0.8f);
        rp.uvFactor = new float[][]{{0.0f, 0.0f}, {0.5f, 1.0f}, {0.5f, 1.0f}, {1.0f, 0.0f}};
        rp.aoMatrix = new int[][][]{new int[][]{FaceData.aom("TopWest"), FaceData.aom("TopSouthWest"), FaceData.aom("TopSouth"), FaceData.aom("South")}, new int[][]{FaceData.aom("BottomSouth"), FaceData.aom("SouthEast"), FaceData.aom("BottomEast")}, new int[][]{FaceData.aom("BottomSouth"), FaceData.aom("SouthEast"), FaceData.aom("BottomEast")}, new int[][]{FaceData.aom("TopNorth"), FaceData.aom("TopNorthEast"), FaceData.aom("TopEast"), FaceData.aom("East")}};
        Face.InvTopSouthEast.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = TOP;
        rp.colorFactor = Float.valueOf(0.8f);
        rp.uvFactor = new float[][]{{0.0f, 0.0f}, {0.5f, 1.0f}, {0.5f, 1.0f}, {1.0f, 0.0f}};
        rp.aoMatrix = new int[][][]{new int[][]{FaceData.aom("TopNorth"), FaceData.aom("TopNorthWest"), FaceData.aom("TopWest"), FaceData.aom("West")}, new int[][]{FaceData.aom("BottomSouth"), FaceData.aom("SouthWest"), FaceData.aom("BottomWest")}, new int[][]{FaceData.aom("BottomSouth"), FaceData.aom("SouthWest"), FaceData.aom("BottomWest")}, new int[][]{FaceData.aom("TopEast"), FaceData.aom("TopSouthEast"), FaceData.aom("TopSouth"), FaceData.aom("South")}};
        Face.InvTopSouthWest.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = TOP;
        rp.colorFactor = Float.valueOf(0.8f);
        rp.uvFactor = new float[][]{{0.0f, 0.0f}, {0.5f, 1.0f}, {0.5f, 1.0f}, {1.0f, 0.0f}};
        rp.aoMatrix = new int[][][]{new int[][]{FaceData.aom("TopWest"), FaceData.aom("TopNorthWest"), FaceData.aom("East")}, new int[][]{FaceData.aom("BottomNorth"), FaceData.aom("NorthWest"), FaceData.aom("BottomWest")}, new int[][]{FaceData.aom("BottomNorth"), FaceData.aom("NorthWest"), FaceData.aom("BottomWest")}, new int[][]{FaceData.aom("TopSouth"), FaceData.aom("TopSouthWest"), FaceData.aom("West")}};
        Face.InvTopNorthWest.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = TOP;
        rp.colorFactor = Float.valueOf(0.8f);
        rp.uvFactor = new float[][]{{0.0f, 0.0f}, {0.5f, 1.0f}, {0.5f, 1.0f}, {1.0f, 0.0f}};
        rp.aoMatrix = new int[][][]{new int[][]{FaceData.aom("TopSouth"), FaceData.aom("TopSouthEast"), FaceData.aom("East")}, new int[][]{FaceData.aom("BottomWest"), FaceData.aom("BottomNortWest"), FaceData.aom("BottomNorth")}, new int[][]{FaceData.aom("BottomWest"), FaceData.aom("BottomNortWest"), FaceData.aom("BottomNorth")}, new int[][]{FaceData.aom("TopWest"), FaceData.aom("TopNorthWest"), FaceData.aom("North")}};
        Face.InvTopNorthEast.setParams(rp);
        rp = new RenderParameters();
        rp.textureSide = TOP;
        rp.direction = WEST;
        rp.colorFactor = Float.valueOf(0.6f);
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.South, (ForgeDirection)rp.direction);
        Face.TriangleWestTopSouth.setParams(rp);
        rp = new RenderParameters();
        rp.textureSide = TOP;
        rp.direction = EAST;
        rp.colorFactor = Float.valueOf(0.6f);
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.South, (ForgeDirection)rp.direction);
        Face.TriangleEastTopSouth.setParams(rp);
        rp = new RenderParameters();
        rp.textureSide = TOP;
        rp.direction = WEST;
        rp.colorFactor = Float.valueOf(0.6f);
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.South, (ForgeDirection)rp.direction);
        Face.TriangleWestTopNorth.setParams(rp);
        rp = new RenderParameters();
        rp.textureSide = TOP;
        rp.direction = EAST;
        rp.colorFactor = Float.valueOf(0.6f);
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.South, (ForgeDirection)rp.direction);
        Face.TriangleEastTopNorth.setParams(rp);
        rp = new RenderParameters();
        rp.textureSide = TOP;
        rp.direction = NORTH;
        rp.colorFactor = Float.valueOf(0.8f);
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.South, (ForgeDirection)rp.direction);
        Face.TriangleNorthTopWest.setParams(rp);
        rp = new RenderParameters();
        rp.textureSide = TOP;
        rp.direction = SOUTH;
        rp.colorFactor = Float.valueOf(0.8f);
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.South, (ForgeDirection)rp.direction);
        Face.TriangleSouthTopWest.setParams(rp);
        rp = new RenderParameters();
        rp.textureSide = TOP;
        rp.direction = NORTH;
        rp.colorFactor = Float.valueOf(0.8f);
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.South, (ForgeDirection)rp.direction);
        Face.TriangleNorthTopEast.setParams(rp);
        rp = new RenderParameters();
        rp.textureSide = TOP;
        rp.direction = SOUTH;
        rp.colorFactor = Float.valueOf(0.8f);
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.South, (ForgeDirection)rp.direction);
        Face.TriangleSouthTopEast.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = TOP;
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.TriangleTopSouthWest, (ForgeDirection)rp.direction);
        Face.TriangleTopSouthWest.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = TOP;
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.TriangleTopSouthEast, (ForgeDirection)rp.direction);
        Face.TriangleTopSouthEast.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = TOP;
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.TriangleTopNorthWest, (ForgeDirection)rp.direction);
        Face.TriangleTopNorthWest.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = TOP;
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.TriangleTopNorthEast, (ForgeDirection)rp.direction);
        Face.TriangleTopNorthEast.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = BOTTOM;
        rp.colorFactor = Float.valueOf(0.5f);
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.TriangleBottomSouthEast, (ForgeDirection)rp.direction);
        Face.TriangleBottomSouthEast.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = BOTTOM;
        rp.colorFactor = Float.valueOf(0.5f);
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.TriangleBottomSouthWest, (ForgeDirection)rp.direction);
        Face.TriangleBottomSouthWest.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = BOTTOM;
        rp.colorFactor = Float.valueOf(0.5f);
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.TriangleBottomNorthWest, (ForgeDirection)rp.direction);
        Face.TriangleBottomNorthWest.setParams(rp);
        rp = new RenderParameters();
        rp.direction = rp.textureSide = BOTTOM;
        rp.colorFactor = Float.valueOf(0.5f);
        rp.aoMatrix = FaceData.calculateAoMatrix(Face.TriangleBottomNorthEast, (ForgeDirection)rp.direction);
        Face.TriangleBottomNorthEast.setParams(rp);
    }

    public static int[] aom(String s) {
        int[] nArray;
        int[] a = aom.get(s);
        if (a == null) {
            int[] nArray2 = new int[3];
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray = nArray2;
            nArray2[2] = 0;
        } else {
            nArray = a;
        }
        return nArray;
    }

    private static void buildDirectionMatrix() {
        int[] a;
        for (int x : a = new int[]{-1, 0, 1}) {
            for (int y : a) {
                for (int z : a) {
                    aom.put(FaceData.dirToString(x, y, z), new int[]{x, y, z});
                }
            }
        }
    }

    private static String dirToString(int x, int y, int z) {
        String s = "";
        s = s + (y == 0 ? "" : (y == 1 ? "Top" : "Bottom"));
        s = s + (z == 0 ? "" : (z == 1 ? "South" : "North"));
        s = s + (x == 0 ? "" : (x == 1 ? "East" : "West"));
        return s;
    }

    public static int[][][] calculateAoMatrix(Face face, ForgeDirection offset) {
        Vertex[] vertexes = face.getVertexes();
        int[][][] aoMatrix = new int[vertexes.length][3][3];
        for (int i = 0; i < vertexes.length; ++i) {
            aoMatrix[i] = FaceData.vertexAoMatrix(vertexes[i], offset);
        }
        return aoMatrix;
    }

    private static int[][] vertexAoMatrix(Vertex vertex, ForgeDirection offset) {
        int[][] a = new int[3][3];
        if (offset == ForgeDirection.WEST || offset == ForgeDirection.EAST) {
            int n = offset.offsetX;
            a[2][0] = n;
            a[1][0] = n;
            a[0][0] = n;
            int[] nArray = a[1];
            nArray[1] = nArray[1] + (vertex.getIntY() * 2 - 1);
            int[] nArray2 = a[2];
            nArray2[1] = nArray2[1] + (vertex.getIntY() * 2 - 1);
            int[] nArray3 = a[0];
            nArray3[2] = nArray3[2] + (vertex.getIntZ() * 2 - 1);
            int[] nArray4 = a[1];
            nArray4[2] = nArray4[2] + (vertex.getIntZ() * 2 - 1);
        } else if (offset == ForgeDirection.UP || offset == ForgeDirection.DOWN) {
            int n = offset.offsetY;
            a[2][1] = n;
            a[1][1] = n;
            a[0][1] = n;
            int[] nArray = a[1];
            nArray[0] = nArray[0] + (vertex.getIntX() * 2 - 1);
            int[] nArray5 = a[2];
            nArray5[0] = nArray5[0] + (vertex.getIntX() * 2 - 1);
            int[] nArray6 = a[0];
            nArray6[2] = nArray6[2] + (vertex.getIntZ() * 2 - 1);
            int[] nArray7 = a[1];
            nArray7[2] = nArray7[2] + (vertex.getIntZ() * 2 - 1);
        } else if (offset == ForgeDirection.NORTH || offset == ForgeDirection.SOUTH) {
            int n = offset.offsetZ;
            a[2][2] = n;
            a[1][2] = n;
            a[0][2] = n;
            int[] nArray = a[1];
            nArray[0] = nArray[0] + (vertex.getIntX() * 2 - 1);
            int[] nArray8 = a[2];
            nArray8[0] = nArray8[0] + (vertex.getIntX() * 2 - 1);
            int[] nArray9 = a[0];
            nArray9[1] = nArray9[1] + (vertex.getIntY() * 2 - 1);
            int[] nArray10 = a[1];
            nArray10[1] = nArray10[1] + (vertex.getIntY() * 2 - 1);
        }
        return a;
    }
}

