/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.element;

import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderParameters {
    public static RenderParameters defaultParameters = new RenderParameters();
    public Boolean renderAllFaces;
    public Boolean useBlockBounds;
    public double[][] renderBounds;
    public Boolean vertexPositionRelativeToRenderBounds;
    public Boolean useCustomTexture;
    public IIcon icon;
    public Boolean useTexture;
    public Boolean interpolateUV;
    public Boolean calculateAOColor;
    public Boolean calculateBrightness;
    public Boolean usePerVertexColor;
    public Boolean usePerVertexAlpha;
    public Boolean useBlockBrightness;
    public Boolean useNormals;
    public Integer colorMultiplier;
    public Float colorFactor;
    public Boolean dynLights;
    public Integer brightness;
    public Integer alpha;
    public ForgeDirection direction;
    public ForgeDirection textureSide;
    public int[][][] aoMatrix;
    public float[][] uvFactor;
    public Boolean flipU;
    public Boolean flipV;

    public RenderParameters() {
    }

    public RenderParameters(RenderParameters params) {
        if (params == null) {
            params = defaultParameters;
        }
        this.renderAllFaces = params.renderAllFaces;
        this.useBlockBounds = params.useBlockBounds;
        this.vertexPositionRelativeToRenderBounds = params.vertexPositionRelativeToRenderBounds;
        this.useCustomTexture = params.useCustomTexture;
        this.icon = params.icon;
        this.useTexture = params.useTexture;
        this.interpolateUV = params.interpolateUV;
        this.calculateAOColor = params.calculateAOColor;
        this.calculateBrightness = params.calculateBrightness;
        this.usePerVertexColor = params.usePerVertexColor;
        this.usePerVertexAlpha = params.usePerVertexAlpha;
        this.useBlockBrightness = params.useBlockBrightness;
        this.useNormals = params.useNormals;
        this.colorMultiplier = params.colorMultiplier;
        this.colorFactor = params.colorFactor;
        this.dynLights = params.dynLights;
        this.brightness = params.brightness;
        this.alpha = params.alpha;
        this.direction = params.direction;
        this.textureSide = params.textureSide;
        this.aoMatrix = params.aoMatrix;
        this.flipU = params.flipU;
        this.flipV = params.flipV;
        if (params.uvFactor != null) {
            this.uvFactor = new float[params.uvFactor.length][];
            for (int i = 0; i < this.uvFactor.length; ++i) {
                if (params.uvFactor[i] == null) continue;
                this.uvFactor[i] = (float[])params.uvFactor[i].clone();
            }
        }
        if (params.renderBounds != null) {
            this.renderBounds = new double[2][];
            this.renderBounds[0] = (double[])params.renderBounds[0].clone();
            this.renderBounds[1] = (double[])params.renderBounds[1].clone();
        }
    }

    public static RenderParameters merge(RenderParameters rp1, RenderParameters rp2) {
        if (rp2 == null) {
            return new RenderParameters(rp1);
        }
        if (rp2 == defaultParameters) {
            return RenderParameters.setDefault();
        }
        RenderParameters newRp = RenderParameters.merge(defaultParameters, rp1);
        if (rp2.renderAllFaces != null) {
            newRp.renderAllFaces = rp2.renderAllFaces;
        }
        if (rp2.useBlockBounds != null) {
            newRp.useBlockBounds = rp2.useBlockBounds;
        }
        if (rp2.vertexPositionRelativeToRenderBounds != null) {
            newRp.vertexPositionRelativeToRenderBounds = rp2.vertexPositionRelativeToRenderBounds;
        }
        if (rp2.useCustomTexture != null) {
            newRp.useCustomTexture = rp2.useCustomTexture;
        }
        if (rp2.icon != null) {
            newRp.icon = rp2.icon;
        }
        if (rp2.useTexture != null) {
            newRp.useTexture = rp2.useTexture;
        }
        if (rp2.interpolateUV != null) {
            newRp.interpolateUV = rp2.interpolateUV;
        }
        if (rp2.calculateAOColor != null) {
            newRp.calculateAOColor = rp2.calculateAOColor;
        }
        if (rp2.calculateBrightness != null) {
            newRp.calculateBrightness = rp2.calculateBrightness;
        }
        if (rp2.usePerVertexColor != null) {
            newRp.usePerVertexColor = rp2.usePerVertexColor;
        }
        if (rp2.usePerVertexAlpha != null) {
            newRp.usePerVertexAlpha = rp2.usePerVertexAlpha;
        }
        if (rp2.dynLights != null) {
            newRp.dynLights = rp2.dynLights;
        }
        if (rp2.useBlockBrightness != null) {
            newRp.useBlockBrightness = rp2.useBlockBrightness;
        }
        if (rp2.useNormals != null) {
            newRp.useNormals = rp2.useNormals;
        }
        if (rp2.colorMultiplier != null) {
            newRp.colorMultiplier = rp2.colorMultiplier;
        }
        if (rp2.colorFactor != null) {
            newRp.colorFactor = rp2.colorFactor;
        }
        if (rp2.brightness != null) {
            newRp.brightness = rp2.brightness;
        }
        if (rp2.alpha != null) {
            newRp.alpha = rp2.alpha;
        }
        if (rp2.direction != null) {
            newRp.direction = rp2.direction;
        }
        if (rp2.textureSide != null) {
            newRp.textureSide = rp2.textureSide;
        }
        if (rp2.aoMatrix != null) {
            newRp.aoMatrix = rp2.aoMatrix;
        }
        if (rp2.flipU != null) {
            newRp.flipU = rp2.flipU;
        }
        if (rp2.flipV != null) {
            newRp.flipV = rp2.flipV;
        }
        if (rp2.uvFactor != null) {
            newRp.uvFactor = new float[rp2.uvFactor.length][];
            for (int i = 0; i < newRp.uvFactor.length; ++i) {
                if (rp2.uvFactor[i] == null) continue;
                newRp.uvFactor[i] = (float[])rp2.uvFactor[i].clone();
            }
        }
        if (rp2.renderBounds != null) {
            newRp.renderBounds = new double[2][];
            newRp.renderBounds[0] = (double[])rp2.renderBounds[0].clone();
            newRp.renderBounds[1] = (double[])rp2.renderBounds[1].clone();
        }
        return newRp;
    }

    public static RenderParameters setDefault() {
        return new RenderParameters(defaultParameters);
    }

    static {
        RenderParameters.defaultParameters.renderAllFaces = false;
        RenderParameters.defaultParameters.useBlockBounds = true;
        RenderParameters.defaultParameters.renderBounds = new double[][]{{0.0, 0.0, 0.0}, {1.0, 1.0, 1.0}};
        RenderParameters.defaultParameters.vertexPositionRelativeToRenderBounds = true;
        RenderParameters.defaultParameters.useCustomTexture = false;
        RenderParameters.defaultParameters.useTexture = true;
        RenderParameters.defaultParameters.interpolateUV = true;
        RenderParameters.defaultParameters.calculateAOColor = true;
        RenderParameters.defaultParameters.calculateBrightness = true;
        RenderParameters.defaultParameters.usePerVertexColor = false;
        RenderParameters.defaultParameters.usePerVertexAlpha = false;
        RenderParameters.defaultParameters.useBlockBrightness = true;
        RenderParameters.defaultParameters.useNormals = false;
        RenderParameters.defaultParameters.colorMultiplier = 0xFFFFFF;
        RenderParameters.defaultParameters.colorFactor = Float.valueOf(1.0f);
        RenderParameters.defaultParameters.dynLights = true;
        RenderParameters.defaultParameters.brightness = 0xF00000;
        RenderParameters.defaultParameters.alpha = 255;
        RenderParameters.defaultParameters.uvFactor = new float[][]{{0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}};
        RenderParameters.defaultParameters.flipU = false;
        RenderParameters.defaultParameters.flipV = false;
    }
}

