/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.demo.test;

import java.util.ArrayList;
import net.malisis.core.demo.stargate.StargateBlock;
import net.malisis.core.demo.stargate.StargateTileEntity;
import net.malisis.core.demo.test.TestBlock;
import net.malisis.core.renderer.BaseRenderer;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.animation.Rotation;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.RenderParameters;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.preset.FacePreset;
import net.malisis.core.renderer.preset.ShapePreset;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TestRenderer
extends BaseRenderer {
    public static int renderId;
    public static ResourceLocation rlPlatform;
    int slices = 5;
    float sliceHeight = 1.0f / (float)this.slices;
    int deployTimer = StargateBlock.deployTimer;
    int openTimer = (int)((float)this.deployTimer * 0.3f);
    int rotationTimer = (int)((float)this.deployTimer * 0.3f);
    int archTimer = (int)((float)this.deployTimer * 0.5f);
    int fadeTimer = (int)((float)this.deployTimer * 0.2f);
    AnimationRenderer ar = new AnimationRenderer(this);

    public TestRenderer() {
        this.createOpeningAnimation();
        this.createUnrollingAnimation();
        this.createArchAnimation();
        this.createFloatingAnimation();
    }

    private void createOpeningAnimation() {
        int ot = this.openTimer / this.slices;
        for (int i = 1; i < this.slices; ++i) {
            int t = ot * i;
            Shape sW = ShapePreset.Cube().setBounds(0.0f, 0.0f, 0.0f, 0.5f, this.sliceHeight, 1.0f);
            sW.translate(0.0f, this.sliceHeight * (float)i, 0.0f);
            this.ar.translate(-0.5f * (float)i, 0.0f, 0.0f).forTicks(t).translate(0.0f, -this.sliceHeight * (float)i, 0.0f).forTicks(t, ot).animate("openW" + i, sW);
            Shape sE = new Shape(sW).translate(0.5f, 0.0f, 0.0f);
            this.ar.translate(0.5f * (float)i, 0.0f, 0.0f).forTicks(t).translate(0.0f, -this.sliceHeight * (float)i, 0.0f).forTicks(t, ot).animate("openE" + i, sE);
        }
    }

    private void createUnrollingAnimation() {
        this.ar.globalDelay(this.openTimer);
        RenderParameters rp = new RenderParameters();
        rp.useBlockBrightness = false;
        int rt = this.rotationTimer * 2 / 5;
        int delay = rt / 2;
        float y = -0.5f + this.sliceHeight / 2.0f;
        ArrayList<Animation> north = new ArrayList<Animation>();
        ArrayList<Animation> south = new ArrayList<Animation>();
        for (int row = 0; row < 4; ++row) {
            Shape[] shapesNorth = new Shape[this.slices];
            Shape[] shapesSouth = new Shape[this.slices];
            for (int i = 0; i < this.slices; ++i) {
                Shape sN = ShapePreset.Cube().setBounds(0.0f, 0.0f, 0.0f, 1.0f, this.sliceHeight, 0.5f);
                sN.translate(-2 + i, 0.0f, 0.0f);
                shapesNorth[i] = sN;
                Shape sS = new Shape(sN);
                sS.translate(0.0f, 0.0f, 0.5f);
                shapesSouth[i] = sS;
            }
            north.add(new Rotation(-180.0f, 1.0f, 0.0f, 0.0f, 0.0f, y, -0.5f).forTicks(rt, 0));
            south.add(new Rotation(180.0f, 1.0f, 0.0f, 0.0f, 0.0f, y, 0.0f).forTicks(rt, 0));
            if (row > 0) {
                north.add(new Rotation(-180.0f, 1.0f, 0.0f, 0.0f, 0.0f, y, 0.0f).forTicks(rt, delay));
                south.add(new Rotation(180.0f, 1.0f, 0.0f, 0.0f, 0.0f, y, -0.5f).forTicks(rt, delay));
            }
            if (row > 1) {
                north.add(new Rotation(-180.0f, 1.0f, 0.0f, 0.0f, 0.0f, y, -0.5f).forTicks(rt, delay * 2));
                south.add(new Rotation(180.0f, 1.0f, 0.0f, 0.0f, 0.0f, y, 0.0f).forTicks(rt, delay * 2));
            }
            if (row > 2) {
                north.add(new Rotation(-180.0f, 1.0f, 0.0f, 0.0f, 0.0f, y, 0.0f).forTicks(rt, delay * 3));
                south.add(new Rotation(180.0f, 1.0f, 0.0f, 0.0f, 0.0f, y, -0.5f).forTicks(rt, delay * 3));
            }
            for (Animation anim : north) {
                this.ar.add(anim);
            }
            this.ar.animate("unrollingN" + row, shapesNorth, rp);
            for (Animation anim : south) {
                this.ar.add(anim);
            }
            this.ar.animate("unrollingS" + row, shapesSouth, rp);
            north.clear();
            south.clear();
        }
    }

    private void createArchAnimation() {
        this.ar.globalDelay(this.openTimer);
        RenderParameters rpFace = new RenderParameters();
        rpFace.calculateAOColor = false;
        rpFace.calculateBrightness = false;
        rpFace.useBlockBrightness = false;
        rpFace.brightness = 32;
        rpFace.icon = Blocks.field_150484_ah.func_149691_a(0, 0);
        Shape base = ShapePreset.Cube();
        base.setParameters(FacePreset.Bottom(), rpFace, true);
        base.translate(0.0f, 3.0f, 0.0f);
        base.shrink(FacePreset.Bottom(), 0.69f);
        base.shrink(FacePreset.Top(), 0.87f);
        int totalArch = 13;
        float angle = 10.0f;
        int at = this.archTimer / totalArch;
        RenderParameters rp = new RenderParameters();
        rp.renderAllFaces = true;
        for (int i = 0; i < totalArch; ++i) {
            float archAngle = 130.0f - (angle * (float)i + angle / 2.0f);
            int delay = (totalArch - i) * at;
            Shape sW = new Shape(base);
            sW.rotate(130.0f, 0.0f, 0.0f, 1.0f, 0.0f, -2.2f, 0.0f);
            Shape sE = new Shape(base);
            sE.rotate(-130.0f, 0.0f, 0.0f, 1.0f, 0.0f, -2.2f, 0.0f);
            this.ar.rotate(-archAngle, 0.0f, 0.0f, 1.0f, 0.0f, -2.2f, 0.0f).forTicks(at, delay).scaleFrom(0.5f, 0.3f, 0.2f).scaleTo(0.5f, 0.5f, 0.3f).forTicks(at / 2, delay + at).animate("archW" + i, sW, rp);
            this.ar.rotate(archAngle, 0.0f, 0.0f, 1.0f, 0.0f, -2.2f, 0.0f).forTicks(at, delay).scaleFrom(0.5f, 0.3f, 0.2f).scaleTo(0.5f, 0.5f, 0.3f).forTicks(at, delay + at).animate("archE" + i, sE, rp);
        }
    }

    private void createFloatingAnimation() {
        this.ar.globalDelay(this.openTimer + this.rotationTimer + this.archTimer);
        RenderParameters rp = new RenderParameters();
        rp.icon = Blocks.field_150340_R.func_149691_a(0, 0);
        rp.useBlockBrightness = false;
        rp.brightness = 0xF000F0;
        rp.alpha = 175;
        Shape s = ShapePreset.Cube();
        s.scale(0.2f);
        s.applyMatrix();
        s.translate(-1.0f, 1.5f, 0.0f);
        this.ar.rotate(360.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f).forTicks(50).loop(-1).translate(0.0f, 1.0f, 0.0f).forTicks(20).loop(-1, 0, 20).sinusoidal().translate(0.0f, -1.0f, 0.0f).forTicks(20).loop(-1, 20, 0).sinusoidal().rotate(360.0f, 1.0f, 0.0f, 0.0f).forTicks(50).loop(-1).animate("floating", s, rp);
    }

    @Override
    public void render() {
        if (this.block instanceof TestBlock) {
            if (this.typeRender == 1) {
                this.renderTestBlock();
            } else {
                this.drawShape(ShapePreset.Cube());
            }
        }
        if (this.block instanceof StargateBlock) {
            if (this.typeRender == 4) {
                this.renderStargateTileEntity();
            } else if (this.typeRender == 1) {
                this.renderStargateBlock();
            } else if (this.typeRender == 2) {
                RenderParameters rp = RenderParameters.setDefault();
                rp.colorMultiplier = 0x6666AA;
                this.drawShape(ShapePreset.Cube());
            }
        }
    }

    private void renderStargateTileEntity() {
        StargateTileEntity te = (StargateTileEntity)this.tileEntity;
        int alpha = 255;
        boolean drawTopFace = false;
        this.ar.setTime(te.placedTimer);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        if (this.blockMetadata == 0) {
            this.drawShape(ShapePreset.Cube().setBounds(0.0f, 0.0f, 0.0f, 1.0f, this.sliceHeight, 1.0f));
            this.ar.renderAllBut("floating");
            float comp = Math.min((this.ar.getElapsedTime() - (float)this.deployTimer + (float)this.fadeTimer) / (float)this.fadeTimer, 1.0f);
            if (comp > 0.0f) {
                alpha = (int)(255.0f * comp);
                drawTopFace = true;
            }
        }
        if (this.blockMetadata == 1 || drawTopFace) {
            if (this.blockMetadata == 1) {
                this.ar.render("floating");
            }
            this.next();
            Shape topFace = new Shape(new Face[]{FacePreset.Top()});
            topFace.translate(0.0f, -0.499f + this.sliceHeight / 2.0f, 0.0f);
            topFace.scale(5.0f, this.sliceHeight, 5.0f);
            this.func_147499_a(rlPlatform);
            RenderParameters rp = RenderParameters.setDefault();
            rp.useCustomTexture = true;
            rp.alpha = alpha;
            this.drawShape(topFace, rp);
        }
    }

    private void renderStargateTileEntity2() {
        boolean drawTopFace = false;
        int alpha = 255;
        if (this.blockMetadata == 0) {
            float comp;
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glAlphaFunc((int)516, (float)0.0f);
            StargateTileEntity te = (StargateTileEntity)this.tileEntity;
            int openTimer = 10;
            int downTimer = 10;
            int rotationTimer = 10;
            int delay = rotationTimer / 2;
            int expandTimer = rotationTimer + 3 * delay;
            int fadeTimer = 20;
            int archTimer = 30;
            int maxTimer = openTimer + downTimer + expandTimer + fadeTimer + archTimer + 20;
            float elapsedTime = (float)(this.getWorldTime() - te.placedTimer) + this.partialTick;
            boolean drawShapes2 = false;
            if (elapsedTime > (float)maxTimer) {
                Minecraft.func_71410_x().field_71441_e.func_72921_c(this.x, this.y, this.z, 1, 3);
            }
            if (elapsedTime < (float)(openTimer + downTimer + expandTimer)) {
                int i;
                Shape[] shapes = new Shape[2 * this.slices - 1];
                Shape[] shapes2 = new Shape[8 * this.slices];
                shapes[0] = ShapePreset.Cube().setBounds(0.0f, 0.0f, 0.0f, 1.0f, this.sliceHeight, 1.0f);
                for (i = 1; i < shapes.length; ++i) {
                    Shape s = ShapePreset.Cube().setBounds(0.0f, 0.0f, 0.0f, 0.5f, this.sliceHeight, 1.0f);
                    s.translate(0.5f * (float)(i % 2), this.sliceHeight * (float)Math.ceil((float)i / 2.0f), 0.0f);
                    shapes[i] = s;
                }
                comp = Math.min(elapsedTime / (float)openTimer, 1.0f);
                for (i = 1; i < shapes.length; ++i) {
                    int dir = i % 2 == 0 ? -1 : 1;
                    float factor = (float)Math.ceil((float)i / 2.0f);
                    shapes[i].translate(comp * (float)dir * factor / 2.0f, 0.0f, 0.0f);
                }
                if (elapsedTime > (float)openTimer) {
                    comp = Math.min((elapsedTime - (float)openTimer) / (float)downTimer, 1.0f);
                    for (i = 1; i < shapes.length; ++i) {
                        shapes[i].translate(0.0f, -this.sliceHeight * comp * (float)Math.ceil((float)i / 2.0f), 0.0f);
                    }
                }
                if (elapsedTime > (float)(openTimer + downTimer)) {
                    drawShapes2 = true;
                    for (i = 0; i < shapes2.length; ++i) {
                        Shape s = ShapePreset.Cube().setBounds(0.0f, 0.0f, 0.0f, 1.0f, this.sliceHeight, 0.5f);
                        s.translate(-2.0f + (float)Math.floor((float)i / 8.0f), 0.0f, 0.5f * (float)(i % 2));
                        shapes2[i] = s;
                    }
                    comp = Math.min((elapsedTime - (float)openTimer - (float)downTimer) / (float)expandTimer, 1.0f);
                    float y = -0.5f + this.sliceHeight / 2.0f;
                    for (int i2 = 0; i2 < shapes2.length; ++i2) {
                        boolean first = i2 % 8 < 2;
                        boolean second = i2 % 8 < 4;
                        boolean third = i2 % 8 < 6;
                        boolean even = i2 % 2 == 0;
                        float angle = even ? -180.0f : 180.0f;
                        float comp1 = Math.min((elapsedTime - (float)openTimer - (float)downTimer) / (float)rotationTimer, 1.0f);
                        float comp2 = Math.min((elapsedTime - (float)openTimer - (float)downTimer - (float)delay) / (float)rotationTimer, 1.0f);
                        float comp3 = Math.min((elapsedTime - (float)openTimer - (float)downTimer - (float)(delay * 2)) / (float)rotationTimer, 1.0f);
                        float comp4 = Math.min((elapsedTime - (float)openTimer - (float)downTimer - (float)(delay * 3)) / (float)rotationTimer, 1.0f);
                        if (first) {
                            shapes2[i2].rotateAroundX(angle * comp1, y, even ? -0.5f : 0.0f);
                            continue;
                        }
                        if (second && comp2 > 0.0f) {
                            shapes2[i2].rotateAroundX(angle * comp1, y, even ? -0.5f : 0.0f);
                            shapes2[i2].rotateAroundX(angle * comp2, y, even ? 0.0f : -0.5f);
                            continue;
                        }
                        if (third && comp3 > 0.0f) {
                            shapes2[i2].rotateAroundX(angle * comp1, y, even ? -0.5f : 0.0f);
                            shapes2[i2].rotateAroundX(angle * comp2, y, even ? 0.0f : -0.5f);
                            shapes2[i2].rotateAroundX(angle * comp3, y, even ? -0.5f : 0.0f);
                            continue;
                        }
                        if (!(comp4 > 0.0f)) continue;
                        shapes2[i2].rotateAroundX(angle * comp1, y, even ? -0.5f : 0.0f);
                        shapes2[i2].rotateAroundX(angle * comp2, y, even ? 0.0f : -0.5f);
                        shapes2[i2].rotateAroundX(angle * comp3, y, even ? -0.5f : 0.0f);
                        shapes2[i2].rotateAroundX(angle * comp4, y, even ? 0.0f : -0.5f);
                    }
                }
                for (Shape s : shapes) {
                    this.drawShape(s);
                }
                RenderParameters rp = RenderParameters.setDefault();
                rp.useBlockBrightness = false;
                if (drawShapes2) {
                    for (Shape s : shapes2) {
                        if (s == null) continue;
                        this.drawShape(s, rp);
                    }
                }
            }
            if (elapsedTime > (float)(openTimer + downTimer + expandTimer)) {
                Shape platform = ShapePreset.Cube();
                platform.translate(0.0f, -0.5f + this.sliceHeight / 2.0f, 0.0f);
                platform.scale(5.0f, this.sliceHeight, 5.0f);
                this.drawShape(platform);
                comp = Math.min((elapsedTime - (float)openTimer - (float)downTimer - (float)expandTimer) / (float)archTimer, 1.0f);
                RenderParameters rp = RenderParameters.setDefault();
                rp.renderAllFaces = true;
                Shape base = ShapePreset.Cube();
                RenderParameters rpFace = new RenderParameters();
                rpFace.calculateAOColor = false;
                rpFace.calculateBrightness = false;
                rpFace.useBlockBrightness = false;
                rpFace.brightness = 32;
                rpFace.icon = Blocks.field_150484_ah.func_149691_a(0, 0);
                base.setParameters(FacePreset.Bottom(), rpFace, true);
                base.shrink(FacePreset.Bottom(), 0.69f);
                base.shrink(FacePreset.Top(), 0.87f);
                int totalArch = 12;
                float angle = -240.0f;
                int offset = (int)((-angle - 180.0f) / 2.0f);
                int nbArch = (int)(comp * (float)totalArch);
                for (int i = 0; i <= nbArch; ++i) {
                    Shape s = new Shape(base);
                    s.pivotZ(90.0f);
                    s.translate(0.0f, 0.5f, 0.0f);
                    s.rotateAroundZ(angle / (float)totalArch * (float)i + (float)offset);
                    s.translate(-2.2f, 0.0f, 0.0f);
                    s.scale(0.5f, 1.0f, 0.5f);
                    this.drawShape(s, rp);
                }
            }
            if (elapsedTime > (float)(openTimer + downTimer + expandTimer + archTimer + 10)) {
                comp = Math.min((elapsedTime - (float)openTimer - (float)downTimer - (float)expandTimer - (float)archTimer - 10.0f) / (float)fadeTimer, 1.0f);
                alpha = (int)(255.0f * comp);
                this.next();
                drawTopFace = true;
            }
        }
        if (this.blockMetadata == 1 || drawTopFace) {
            Shape topFace = new Shape(new Face[]{FacePreset.Top()});
            topFace.translate(0.0f, -0.499f + this.sliceHeight / 2.0f, 0.0f);
            topFace.scale(5.0f, this.sliceHeight, 5.0f);
            this.func_147499_a(rlPlatform);
            RenderParameters rp = RenderParameters.setDefault();
            rp.useCustomTexture = true;
            rp.alpha = alpha;
            this.drawShape(topFace, rp);
        }
    }

    private long getWorldTime() {
        return Minecraft.func_71410_x().field_71441_e.func_82737_E();
    }

    private void renderStargateBlock() {
        if (this.blockMetadata != 1) {
            return;
        }
        RenderParameters rpFace = new RenderParameters();
        rpFace.calculateAOColor = false;
        rpFace.calculateBrightness = false;
        rpFace.brightness = 0xF000F0;
        rpFace.useBlockBrightness = false;
        rpFace.icon = Blocks.field_150353_l.func_149691_a(0, 0);
        rpFace.colorFactor = Float.valueOf(1.0f);
        Shape platform = ShapePreset.Cube();
        platform.setParameters(FacePreset.Top(), rpFace, true);
        platform.translate(0.0f, -0.5f + this.sliceHeight / 2.0f, 0.0f);
        platform.scale(5.0f, this.sliceHeight, 5.0f);
        this.drawShape(platform);
        Shape base = ShapePreset.Cube();
        rpFace.icon = Blocks.field_150484_ah.func_149691_a(0, 0);
        base.setParameters(FacePreset.Bottom(), rpFace, true);
        base.translate(0.0f, 1.0f, 0.0f);
        base.shrink(FacePreset.Bottom(), 0.69f);
        base.shrink(FacePreset.Top(), 0.87f);
        int totalArch = 13;
        float angle = 10.0f;
        RenderParameters rp = new RenderParameters();
        rp.renderAllFaces = true;
        for (int i = 0; i < totalArch; ++i) {
            float archAngle = angle * (float)i + angle / 2.0f;
            Shape s1 = new Shape(base);
            s1.rotateAroundZ(archAngle);
            s1.translate(0.0f, 2.2f, 0.0f);
            s1.scale(0.5f, 0.5f, 0.3f);
            Shape s2 = new Shape(base);
            s2.rotateAroundZ(-archAngle);
            s2.translate(0.0f, 2.2f, 0.0f);
            s2.scale(0.5f, 0.5f, 0.3f);
            this.drawShape(s1, rp);
            this.drawShape(s2, rp);
        }
    }

    private void renderTestBlock() {
        RenderParameters rp = RenderParameters.setDefault();
        int color = 255;
        rp.renderAllFaces = true;
        Shape base = ShapePreset.Cube();
        base.shrink(FacePreset.Bottom(), 0.69f);
        base.shrink(FacePreset.Top(), 0.87f);
        int totalArch = 12;
        float angle = -240.0f;
        int offset = (int)((-angle - 180.0f) / 2.0f);
        for (int i = 0; i <= totalArch; ++i) {
            Shape s = new Shape(base);
            color = (int)((double)color * 0.9);
            rp.colorMultiplier = (color << 16) + (color << 8) + color;
            s.pivotZ(90.0f);
            s.translate(0.0f, 1.0f, 0.0f);
            s.rotateAroundZ(angle / (float)totalArch * (float)i + (float)offset);
            s.translate(-2.2f, 0.0f, 0.0f);
            s.scale(0.5f, 1.0f, 0.5f);
            this.drawShape(s, rp);
        }
    }

    @Override
    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    static {
        rlPlatform = new ResourceLocation("malisiscore", "textures/blocks/sgplatform.png");
    }
}

