/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.renderer;

import java.util.Arrays;
import net.malisis.core.client.gui.renderer.Drawable;
import net.malisis.core.client.gui.util.Size;
import net.malisis.core.client.gui.util.shape.Point;
import net.malisis.core.client.gui.util.shape.Rectangle;
import net.malisis.core.util.RenderHelper;
import net.minecraft.util.ResourceLocation;

public class DynamicTexture
implements Drawable {
    private final ResourceLocation resource;
    private final int textureWidth;
    private final int textureHeight;
    private final float scaleU;
    private final float scaleV;
    private final Rectangle[] corners;
    private final Rectangle[] sides;
    private final Rectangle content;
    private Size size;

    public DynamicTexture(ResourceLocation resource, int width, int height, Rectangle topLeftCorner, Rectangle topSide, Rectangle content) {
        this(resource, 256, 256, width, height, topLeftCorner, topSide, content);
    }

    public DynamicTexture(ResourceLocation resource, int textureWidth, int textureHeight, int width, int height, Rectangle topLeftCorner, Rectangle topSide, Rectangle content) {
        this(resource, textureWidth, textureHeight, width, height, new Rectangle[]{topLeftCorner, Rectangle.translate(topLeftCorner, topLeftCorner.getWidth() + topSide.getWidth(), 0), Rectangle.translate(topLeftCorner, 0, topLeftCorner.getHeight() + topSide.getWidth()), Rectangle.translate(topLeftCorner, topLeftCorner.getWidth() + topSide.getWidth(), topLeftCorner.getHeight() + topSide.getWidth())}, new Rectangle[]{topSide, Rectangle.translate(topSide, 0, content.getHeight() + topSide.getHeight()), Rectangle.translate(topSide, -topLeftCorner.getWidth(), topSide.getHeight()).resize(topSide.getHeight(), topSide.getWidth()), Rectangle.translate(topSide, topSide.getWidth(), topSide.getHeight()).resize(topSide.getHeight(), topSide.getWidth())}, content);
    }

    public DynamicTexture(ResourceLocation resource, int textureWidth, int textureHeight, int width, int height, Rectangle[] corners, Rectangle[] sides, Rectangle content) {
        if (corners.length != 4) {
            throw new IllegalArgumentException("You have to specify 4 corner rectangles!");
        }
        if (sides.length != 4) {
            throw new IllegalArgumentException("You have to specify 4 side rectangles.");
        }
        this.resource = resource;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.corners = corners;
        this.sides = sides;
        this.content = content;
        this.scaleU = 1.0f / (float)textureWidth;
        this.scaleV = 1.0f / (float)textureHeight;
        this.size = new Size(width, height);
    }

    public DynamicTexture(ResourceLocation resource, int width, int height, Rectangle[] corners, Rectangle[] sides, Rectangle content) {
        this(resource, 256, 256, width, height, corners, sides, content);
    }

    @Override
    public void draw(int x, int y) {
        Rectangle rect;
        RenderHelper.bindTexture(this.resource);
        Rectangle tlC = this.corners[Corners.TOP_LEFT.ordinal()];
        Rectangle brC = this.corners[Corners.BOTTOM_RIGHT.ordinal()];
        for (Corners corners : Corners.values()) {
            rect = this.corners[corners.ordinal()];
            int tileX = x + corners.getOffX(rect, this.size.width);
            int tileY = y + corners.getOffY(rect, this.size.height);
            float uMin = this.getScaledU(rect.getStart());
            float vMin = this.getScaledV(rect.getStart());
            float uMax = this.getScaledU(rect.getEnd());
            float vMax = this.getScaledV(rect.getEnd());
            RenderHelper.drawRectangleStretched(tileX, tileY, uMin, vMin, rect.getWidth(), rect.getHeight(), uMax, vMax, 0);
        }
        for (Enum enum_ : Sides.values()) {
            rect = this.sides[enum_.ordinal()];
            Rectangle firstCorner = this.corners[((Sides)enum_).firstCorner.ordinal()];
            Rectangle secondCorner = this.corners[((Sides)enum_).secondCorner.ordinal()];
            int tileX = x + ((Sides)enum_).getOffX(this.size.width, rect, firstCorner, secondCorner);
            int tileY = y + ((Sides)enum_).getOffY(this.size.height, rect, firstCorner, secondCorner);
            float uMin = this.getScaledU(rect.getStart());
            float vMin = this.getScaledV(rect.getStart());
            int tileWidth = ((Sides)enum_).getWidth(this.size.width, rect, firstCorner, secondCorner);
            int tileHeight = ((Sides)enum_).getHeight(this.size.height, rect, firstCorner, secondCorner);
            float uMax = this.getScaledU(rect.getEnd());
            float vMax = this.getScaledV(rect.getEnd());
            RenderHelper.drawRectangleStretched(tileX, tileY, uMin, vMin, tileWidth, tileHeight, uMax, vMax, 0);
        }
        RenderHelper.drawRectangleStretched(x + tlC.getWidth(), y + tlC.getHeight(), (float)this.content.getStart().x * this.scaleU, (float)this.content.getStart().y * this.scaleV, this.size.width - (tlC.getWidth() + brC.getWidth()), this.size.height - (tlC.getHeight() + brC.getHeight()), (float)this.content.getEnd().x * this.scaleU, (float)this.content.getEnd().y * this.scaleV, 0);
    }

    private float getScaledU(Point p) {
        return (float)p.x * this.scaleU;
    }

    private float getScaledV(Point p) {
        return (float)p.y * this.scaleV;
    }

    public Size getSize() {
        return this.size;
    }

    @Override
    public void setSize(Size size) {
        this.size = size;
    }

    @Override
    public void setSize(int width, int height) {
        this.setSize(new Size(width, height));
    }

    public String toString() {
        return this.getClass().getName() + "[ resource=" + this.resource + ", corners=" + Arrays.asList(this.corners) + ", sides=" + Arrays.asList(this.sides) + ", content=" + this.content + " ]";
    }

    public static enum Sides {
        TOP(false, Corners.TOP_LEFT, Corners.TOP_RIGHT){

            @Override
            public int getOffX(int width, Rectangle side, Rectangle firstCorner, Rectangle secondCorner) {
                return firstCorner.getWidth();
            }

            @Override
            public int getOffY(int height, Rectangle side, Rectangle firstCorner, Rectangle secondCorner) {
                return 0;
            }
        }
        ,
        BOTTOM(false, Corners.BOTTOM_LEFT, Corners.BOTTOM_RIGHT){

            @Override
            public int getOffX(int width, Rectangle side, Rectangle firstCorner, Rectangle secondCorner) {
                return firstCorner.getWidth();
            }

            @Override
            public int getOffY(int height, Rectangle side, Rectangle firstCorner, Rectangle secondCorner) {
                return height - side.getHeight();
            }
        }
        ,
        LEFT(true, Corners.TOP_LEFT, Corners.BOTTOM_LEFT){

            @Override
            public int getOffX(int width, Rectangle side, Rectangle firstCorner, Rectangle secondCorner) {
                return 0;
            }

            @Override
            public int getOffY(int height, Rectangle side, Rectangle firstCorner, Rectangle secondCorner) {
                return firstCorner.getHeight();
            }
        }
        ,
        RIGHT(true, Corners.TOP_RIGHT, Corners.BOTTOM_RIGHT){

            @Override
            public int getOffX(int width, Rectangle side, Rectangle firstCorner, Rectangle secondCorner) {
                return width - side.getWidth();
            }

            @Override
            public int getOffY(int height, Rectangle side, Rectangle firstCorner, Rectangle secondCorner) {
                return firstCorner.getHeight();
            }
        };

        public final boolean isVertical;
        public final Corners firstCorner;
        public final Corners secondCorner;

        private Sides(boolean isVertical, Corners firstCorner, Corners secondCorner) {
            this.isVertical = isVertical;
            this.firstCorner = firstCorner;
            this.secondCorner = secondCorner;
        }

        public int getWidth(int width, Rectangle side, Rectangle firstCorner, Rectangle secondCorner) {
            if (this.isVertical) {
                return side.getWidth();
            }
            return width - (firstCorner.getWidth() + secondCorner.getWidth());
        }

        public int getHeight(int height, Rectangle side, Rectangle firstCorner, Rectangle secondCorner) {
            if (!this.isVertical) {
                return side.getHeight();
            }
            return height - (firstCorner.getHeight() + secondCorner.getHeight());
        }

        public abstract int getOffX(int var1, Rectangle var2, Rectangle var3, Rectangle var4);

        public abstract int getOffY(int var1, Rectangle var2, Rectangle var3, Rectangle var4);
    }

    public static enum Corners {
        TOP_LEFT{

            @Override
            public int getOffX(Rectangle rect, int width) {
                return 0;
            }

            @Override
            public int getOffY(Rectangle rect, int height) {
                return 0;
            }
        }
        ,
        TOP_RIGHT{

            @Override
            public int getOffX(Rectangle rect, int width) {
                return width - rect.getWidth();
            }

            @Override
            public int getOffY(Rectangle rect, int height) {
                return 0;
            }
        }
        ,
        BOTTOM_LEFT{

            @Override
            public int getOffX(Rectangle rect, int width) {
                return 0;
            }

            @Override
            public int getOffY(Rectangle rect, int height) {
                return height - rect.getHeight();
            }
        }
        ,
        BOTTOM_RIGHT{

            @Override
            public int getOffX(Rectangle rect, int width) {
                return width - rect.getWidth();
            }

            @Override
            public int getOffY(Rectangle rect, int height) {
                return height - rect.getHeight();
            }
        };


        public abstract int getOffX(Rectangle var1, int var2);

        public abstract int getOffY(Rectangle var1, int var2);
    }
}

