/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.entity;

import net.malisis.doors.block.Door;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;

public class DoorTileEntity
extends TileEntity {
    public Door field_145854_h;
    public boolean moving = false;
    public boolean draw = false;
    public int state = 0;
    public float hingeOffsetX;
    public float hingeOffsetZ;
    public float angle;
    public int timer = 0;

    public void startAnimation(int state) {
        if (this.moving && state == this.state) {
            return;
        }
        this.getBlockType();
        this.func_145832_p();
        if (!this.moving) {
            this.timer = state == 3 ? 0 : 4;
        }
        this.moving = true;
        this.state = state;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1));
    }

    public void setSlidingDoorPosition(float partialTick) {
        float s;
        boolean reversed;
        int dir = this.func_145832_p() & 3;
        boolean bl = reversed = (this.func_145832_p() & 0x10) != 0;
        if (this.state == 1) {
            partialTick = -partialTick;
        }
        if ((s = ((float)this.timer + partialTick) / 4.0f) > 1.0f) {
            s = 1.0f;
        }
        if (s < 0.0f) {
            s = 0.0f;
        }
        this.hingeOffsetX = 0.0f;
        this.hingeOffsetZ = 0.0f;
        if (dir == 1 && reversed || dir == 3 && !reversed) {
            this.hingeOffsetX = -s;
        }
        if (dir == 1 && !reversed || dir == 3 && reversed) {
            this.hingeOffsetX = s;
        }
        if (dir == 0 && !reversed || dir == 2 && reversed) {
            this.hingeOffsetZ = -s;
        }
        if (dir == 0 && reversed || dir == 2 && !reversed) {
            this.hingeOffsetZ = s;
        }
        this.hingeOffsetX *= 0.8125f;
        this.hingeOffsetZ *= 0.8125f;
    }

    public void setRegularDoorPosition(float partialTick) {
        this.setDoorAngle(partialTick);
        this.setHingeOffset(partialTick);
    }

    private void setDoorAngle(float partialTick) {
        float a;
        if (this.state == 1) {
            partialTick = -partialTick;
        }
        if ((a = ((float)this.timer + partialTick) / 4.0f) > 1.0f) {
            a = 1.0f;
        }
        if (a < 0.0f) {
            a = 0.0f;
        }
        if ((this.field_145847_g & 0x10) != 0) {
            a *= -1.0f;
        }
        this.angle = 90.0f * a;
    }

    public void setHingeOffset(float partialTick) {
        int dir = this.func_145832_p() & 3;
        boolean reversed = (this.func_145832_p() & 0x10) != 0;
        float f = 0.90625f;
        this.hingeOffsetX = 0.09375f;
        this.hingeOffsetZ = 0.09375f;
        if (dir == 3) {
            this.hingeOffsetZ = f;
            if (reversed) {
                this.hingeOffsetX = f;
            }
        }
        if (dir == 1 && !reversed) {
            this.hingeOffsetX = f;
        }
        if (dir == 0 && reversed) {
            this.hingeOffsetZ = f;
        }
        if (dir == 2) {
            this.hingeOffsetX = f;
            if (!reversed) {
                this.hingeOffsetZ = f;
            }
        }
    }

    public float brightnessFactor() {
        int dir = this.func_145832_p() & 3;
        float f = 0.2f * ((float)this.timer / 4.0f);
        f = dir == 3 || dir == 1 ? 0.8f - f : 0.6f + f;
        return f;
    }

    public void func_145845_h() {
        if (!this.moving) {
            return;
        }
        this.timer = this.state == 3 ? ++this.timer : --this.timer;
        if (this.timer > 4 || this.timer < 0) {
            this.moving = false;
            if (this.getBlockType() != null && !this.field_145850_b.field_72995_K) {
                this.field_145854_h.setDoorState(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.state == 1 ? 0 : 2);
            }
        }
    }

    public Door getBlockType() {
        if (this.field_145854_h == null) {
            this.field_145854_h = (Door)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.field_145854_h;
    }

    public int func_145832_p() {
        return this.getBlockMetadata(false);
    }

    public int getBlockMetadata(boolean top) {
        if (this.getBlockType() != null && this.field_145847_g == -1) {
            this.field_145847_g = this.field_145854_h.getFullMetadata((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) & 0xFFFFFFFB;
        }
        if (top) {
            this.field_145847_g |= 8;
        }
        return this.field_145847_g & 0xFFFFFFFB;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.timer = nbt.func_74762_e("timer");
        this.moving = nbt.func_74767_n("moving");
        this.state = nbt.func_74762_e("state");
        if (this.field_145850_b != null) {
            this.field_145854_h = (Door)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145847_g = this.field_145854_h.getFullMetadata((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("timer", this.timer);
        nbt.func_74757_a("moving", this.moving);
        nbt.func_74768_a("state", this.state);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

