/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;

public class RenderHelper {
    public static void bindTexture(String path) {
        RenderHelper.bindTexture(new ResourceLocation(path));
    }

    public static void bindTexture(ResourceLocation path) {
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(path);
    }

    public static int getColorFromRGB(int r, int g, int b) {
        return 0xFF0000 & r << 16 | 0xFF00 & g << 8 | 0xFF & b;
    }

    public static int getColorFromRGB(Color color) {
        return 0xFF0000 & color.getRed() << 16 | 0xFF00 & color.getGreen() << 8 | 0xFF & color.getBlue();
    }

    public static int getStringWidth(String text) {
        return RenderHelper.getMC().field_71466_p.func_78256_a(text);
    }

    public static Minecraft getMC() {
        return FMLClientHandler.instance().getClient();
    }

    public static void drawString(String text, int x, int y, int color, boolean drawShadow, int zLevel) {
        GL11.glDisable((int)2929);
        GL11.glDisable((int)32826);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)zLevel);
        RenderHelper.getMC().field_71466_p.func_85187_a(text, x, y, color, drawShadow);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-zLevel));
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
    }

    public static void drawSplitString(String text, int x, int y, int color, boolean drawShadow) {
        String[] splits = text.split("<br>");
        for (int i = 0; i < splits.length; ++i) {
            RenderHelper.getMC().field_71466_p.func_85187_a(splits[i], x, y + i * 10, color, drawShadow);
        }
    }

    public static void drawLine(int color, int startX, int startY, int endX, int endY, float width, int zLevel) {
        RenderHelper.drawLine(color, 1.0f, startX, startY, endX, endY, width, zLevel);
    }

    public static void drawLine(int color, float alpha, int startX, int startY, int endX, int endY, float width, int zLevel) {
        Color rgb = RenderHelper.getRGBFromColor(color);
        rgb.setAlpha((int)(alpha * 255.0f));
        RenderHelper.drawLine(rgb, startX, startY, endX, endY, width, zLevel);
    }

    public static Color getRGBFromColor(int color) {
        return new Color((0xFF0000 & color) >> 16, (0xFF00 & color) >> 8, 0xFF & color);
    }

    public static void drawLine(Color color, int startX, int startY, int endX, int endY, float width, int zLevel) {
        float colorMod = 0.003921569f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)(colorMod * (float)color.getRed()), (float)(colorMod * (float)color.getGreen()), (float)(colorMod * (float)color.getBlue()), (float)(colorMod * (float)color.getAlpha()));
        GL11.glLineWidth((float)width);
        GL11.glBegin((int)1);
        GL11.glVertex3f((float)startX, (float)startY, (float)zLevel);
        GL11.glVertex3f((float)endX, (float)endY, (float)zLevel);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
    }

    public static void drawRectangle(int color, int x, int y, int width, int height, int zLevel) {
        RenderHelper.drawRectangle(color, 1.0f, x, y, width, height, zLevel);
    }

    public static void drawRectangle(int color, float alpha, int x, int y, int width, int height, int zLevel) {
        Color rgb = RenderHelper.getRGBFromColor(color);
        rgb.setAlpha((int)(alpha * 255.0f));
        RenderHelper.drawRectangle(rgb, x, y, width, height, zLevel);
    }

    public static void drawRectangle(Color color, int x, int y, int width, int height, int zLevel) {
        float colorMod = 0.003921569f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)(colorMod * (float)color.getRed()), (float)(colorMod * (float)color.getGreen()), (float)(colorMod * (float)color.getBlue()), (float)(colorMod * (float)color.getAlpha()));
        RenderHelper.drawRectangle(x, y, 0, 0, width, height, zLevel);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
    }

    public static void drawRectangle(ResourceLocation texture, int x, int y, float u, float v, int width, int height, int zLevel) {
        RenderHelper.bindTexture(texture);
        float scaleU = 0.00390625f;
        float scaleV = 0.00390625f;
        if (u % 1.0f != 0.0f) {
            scaleU = 1.0f;
        }
        if (v % 1.0f != 0.0f) {
            scaleV = 1.0f;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), (double)zLevel, (double)(u * scaleU), (double)((v + (float)height) * scaleV));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)zLevel, (double)((u + (float)width) * scaleU), (double)((v + (float)height) * scaleV));
        tessellator.func_78374_a((double)(x + width), (double)y, (double)zLevel, (double)((u + (float)width) * scaleU), (double)(v * scaleV));
        tessellator.func_78374_a((double)x, (double)y, (double)zLevel, (double)(u * scaleU), (double)(v * scaleV));
        tessellator.func_78381_a();
    }

    public static void drawRectangleStretched(ResourceLocation texture, int x, int y, float u, float v, int width, int height, float uOff, float vOff, int zLevel) {
        RenderHelper.drawRectangleStretched(texture, x, y, u, v, width, height, u + uOff, v + vOff, true, zLevel);
    }

    public static void drawRectangleStretched(ResourceLocation texture, int x, int y, float u, float v, int width, int height, float uMax, float vMax, boolean max, int zLevel) {
        if (max) {
            RenderHelper.bindTexture(texture);
            RenderHelper.drawRectangleStretched(x, y, u, v, width, height, uMax, vMax, zLevel);
        } else {
            RenderHelper.drawRectangleStretched(texture, x, y, u, v, width, height, uMax, vMax, zLevel);
        }
    }

    public static void drawRectangleStretched(int x, int y, float u, float v, int width, int height, float uMax, float vMax, int zLevel) {
        float scaleU = 0.00390625f;
        float scaleV = 0.00390625f;
        if (u % 1.0f != 0.0f || uMax % 1.0f != 0.0f) {
            scaleU = 1.0f;
        }
        if (v % 1.0f != 0.0f || vMax % 1.0f != 0.0f) {
            scaleV = 1.0f;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), (double)zLevel, (double)(u * scaleU), (double)(vMax * scaleV));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)zLevel, (double)(uMax * scaleU), (double)(vMax * scaleV));
        tessellator.func_78374_a((double)(x + width), (double)y, (double)zLevel, (double)(uMax * scaleU), (double)(v * scaleV));
        tessellator.func_78374_a((double)x, (double)y, (double)zLevel, (double)(u * scaleU), (double)(v * scaleV));
        tessellator.func_78381_a();
    }

    public static void drawRectangleRepeated(ResourceLocation texture, int x, int y, float u, float v, float uvWidth, float uvHeight, int width, int height, int zLevel) {
        RenderHelper.drawRectangleRepeated(texture, x, y, u, v, uvWidth, uvHeight, width, height, (int)uvWidth, (int)uvHeight, zLevel);
    }

    public static void drawRectangleRepeated(ResourceLocation texture, int x, int y, float u, float v, float uMax, float vMax, int width, int height, int tileWidth, int tileHeight, int zLevel) {
        float uvHeight = v - vMax;
        int numX = (int)Math.ceil((float)width / (float)tileWidth);
        int numY = (int)Math.ceil((float)height / (float)tileHeight);
        for (int y2 = 0; y2 < numY; ++y2) {
            for (int x2 = 0; x2 < numX; ++x2) {
                int w = tileWidth;
                int h = tileHeight;
                float tileMaxU = uMax;
                float tileMaxV = vMax;
                float tileV = v;
                int tileX = w * x2;
                int tileY = h * y2 + h;
                if (tileWidth > width) {
                    w = width;
                    tileMaxU -= 0.00390625f * (float)w / (float)tileWidth;
                    tileX = w * x2;
                } else if (x2 == numX - 1 && tileWidth > width - x2 * tileWidth) {
                    w = width - x2 * tileWidth;
                    tileMaxU -= 0.00390625f * (float)w / (float)tileWidth;
                    tileX = tileWidth * x2;
                }
                if (tileHeight > height) {
                    h = height;
                    tileMaxV -= 0.00390625f * (float)h / (float)tileHeight;
                    tileY = h * y2 + h;
                } else if (y2 == numY - 1 && tileHeight > height - (y2 - 1) * tileHeight) {
                    h = height - (y2 - 1) * tileHeight;
                    tileV += uvHeight - 0.00390625f * (float)h / (float)tileHeight;
                    tileY = tileHeight * y2 + h;
                }
                RenderHelper.drawRectangleStretched(texture, x + tileX, y + height - tileY, u, tileV, w, h, tileMaxU, tileMaxV, true, zLevel);
            }
        }
    }

    public static void drawRectangleXRepeated(ResourceLocation texture, int x, int y, float u, float v, float uvWidth, float uvHeight, int width, int height, int zLevel) {
        boolean flipX;
        RenderHelper.bindTexture(texture);
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        if (u % 1.0f != 0.0f) {
            f = 1.0f;
        }
        if (v % 1.0f != 0.0f) {
            f1 = 1.0f;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        boolean bl = flipX = width < 0;
        if (flipX) {
            width *= -1;
        }
        int numX = (int)Math.ceil((float)width / uvWidth);
        for (int x2 = 0; x2 < numX; ++x2) {
            float xOffset = (float)x2 * uvWidth;
            if (flipX) {
                xOffset = (float)width - (float)(x2 + 1) * uvWidth;
            }
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)((float)x + xOffset), (double)(y + height), (double)zLevel, (double)(u * f), (double)((v + uvHeight) * f1));
            tessellator.func_78374_a((double)((float)x + uvWidth + xOffset), (double)(y + height), (double)zLevel, (double)((u + uvWidth) * f), (double)((v + uvHeight) * f1));
            tessellator.func_78374_a((double)((float)x + uvWidth + xOffset), (double)y, (double)zLevel, (double)((u + uvWidth) * f), (double)(v * f1));
            tessellator.func_78374_a((double)((float)x + xOffset), (double)y, (double)zLevel, (double)(u * f), (double)(v * f1));
            tessellator.func_78381_a();
        }
    }

    public static void drawRectangleYRepeated(ResourceLocation texture, int x, int y, float u, float v, float uvWidth, float uvHeight, int width, int height, int zLevel) {
        boolean flipY;
        RenderHelper.bindTexture(texture);
        float scaleU = 0.00390625f;
        float scaleV = 0.00390625f;
        if (u % 1.0f != 0.0f) {
            scaleU = 1.0f;
        }
        if (v % 1.0f != 0.0f) {
            scaleV = 1.0f;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        boolean bl = flipY = height < 0;
        if (flipY) {
            height *= -1;
        }
        int numY = (int)Math.ceil((float)height / uvHeight);
        for (int y2 = 0; y2 < numY; ++y2) {
            float yOffset = (float)y2 * uvHeight;
            if (flipY) {
                yOffset = (float)height - (float)(y2 + 1) * uvHeight;
            }
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)x, (double)((float)y + uvHeight + yOffset), (double)zLevel, (double)(u * scaleU), (double)((v + uvHeight) * scaleV));
            tessellator.func_78374_a((double)(x + width), (double)((float)y + uvHeight + yOffset), (double)zLevel, (double)((u + uvWidth) * scaleU), (double)((v + uvHeight) * scaleV));
            tessellator.func_78374_a((double)(x + width), (double)((float)y + yOffset), (double)zLevel, (double)((u + uvWidth) * scaleU), (double)(v * scaleV));
            tessellator.func_78374_a((double)x, (double)((float)y + yOffset), (double)zLevel, (double)(u * scaleU), (double)(v * scaleV));
            tessellator.func_78381_a();
        }
    }

    public static int computeGuiScale() {
        Minecraft mc = Minecraft.func_71410_x();
        int scaleFactor = 1;
        int k = mc.field_71474_y.field_74335_Z;
        if (k == 0) {
            k = 1000;
        }
        while (scaleFactor < k && mc.field_71443_c / (scaleFactor + 1) >= 320 && mc.field_71440_d / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        return scaleFactor;
    }
}

