/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.element;

import java.util.HashMap;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.RenderParameters;
import net.malisis.core.renderer.element.Vertex;
import net.minecraft.util.AxisAlignedBB;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public class Shape {
    protected Face[] faces;
    protected Matrix4f selfRotationMatrix;
    protected Matrix4f transformMatrix;

    public Shape(Face[] faces) {
        this.faces = new Face[faces.length];
        for (int i = 0; i < faces.length; ++i) {
            this.faces[i] = new Face(faces[i]);
        }
    }

    public Shape(Shape s) {
        this(s.faces);
        this.copyMatrix(s);
    }

    public Face[] getFaces() {
        return this.faces;
    }

    private Matrix4f matrix() {
        if (this.transformMatrix == null) {
            this.transformMatrix = new Matrix4f();
            this.transformMatrix.translate(new Vector3f(0.5f, 0.5f, 0.5f));
        }
        return this.transformMatrix;
    }

    private Matrix4f rotationMatrix() {
        if (this.selfRotationMatrix == null) {
            this.selfRotationMatrix = new Matrix4f();
            this.selfRotationMatrix.translate(new Vector3f(0.5f, 0.5f, 0.5f));
        }
        return this.selfRotationMatrix;
    }

    public Shape setParameters(Face face, RenderParameters params, boolean merge) {
        for (Face f : this.faces) {
            if (f.name() != face.name()) continue;
            if (merge) {
                params = RenderParameters.merge(f.getParameters(), params);
            }
            f.setParameters(params);
        }
        return this;
    }

    public Shape setBounds(float x, float y, float z, float X, float Y, float Z) {
        for (Face f : this.faces) {
            for (Vertex v : f.getVertexes()) {
                String name = v.name();
                if (name.contains("West")) {
                    v.setX(x);
                }
                if (name.contains("East")) {
                    v.setX(X);
                }
                if (name.contains("Bottom")) {
                    v.setY(y);
                }
                if (name.contains("Top")) {
                    v.setY(Y);
                }
                if (name.contains("North")) {
                    v.setZ(z);
                }
                if (!name.contains("South")) continue;
                v.setZ(Z);
            }
        }
        return this;
    }

    public Shape limit(AxisAlignedBB aabb) {
        return this.limit(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    public Shape limit(double x, double y, double z, double X, double Y, double Z) {
        for (Face f : this.faces) {
            for (Vertex v : f.getVertexes()) {
                v.setX(Vertex.clamp(v.getX(), x, X));
                v.setY(Vertex.clamp(v.getY(), y, Y));
                v.setZ(Vertex.clamp(v.getZ(), z, Z));
            }
        }
        return this;
    }

    public Shape translate(float x, float y, float z) {
        this.matrix().translate(new Vector3f(x, y, z));
        return this;
    }

    public Shape scale(float f) {
        return this.scale(f, f, f);
    }

    public Shape scale(float x, float y, float z) {
        this.matrix().scale(new Vector3f(x, y, z));
        return this;
    }

    public Shape rotate(float angle, float x, float y, float z) {
        return this.rotate(angle, x, y, z, 0.0f, 0.0f, 0.0f);
    }

    public Shape rotate(float angle, float x, float y, float z, float offsetX, float offsetY, float offsetZ) {
        this.translate(offsetX, offsetY, offsetZ);
        this.matrix().rotate((float)Math.toRadians(angle), new Vector3f(x, y, z));
        this.translate(offsetX, -offsetY, -offsetZ);
        return this;
    }

    public Shape rotateAroundX(float angle) {
        return this.rotate(angle, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Shape rotateAroundX(float angle, float y, float z) {
        return this.rotate(angle, 1.0f, 0.0f, 0.0f, 0.0f, y, z);
    }

    public Shape rotateAroundY(float angle) {
        return this.rotate(angle, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Shape rotateAroundY(float angle, float x, float z) {
        return this.rotate(angle, 0.0f, 1.0f, 0.0f, x, 0.0f, z);
    }

    public Shape rotateAroundZ(float angle) {
        return this.rotate(angle, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f);
    }

    public Shape rotateAroundZ(float angle, float x, float y) {
        return this.rotate(angle, 0.0f, 0.0f, 1.0f, x, y, 0.0f);
    }

    public Shape pivot(float angle, float x, float y, float z) {
        this.rotationMatrix().rotate((float)Math.toRadians(angle), new Vector3f(x, y, z));
        return this;
    }

    public Shape pivotX(float angle) {
        return this.pivot(angle, 1.0f, 0.0f, 0.0f);
    }

    public Shape pivotY(float angle) {
        return this.pivot(angle, 0.0f, 1.0f, 0.0f);
    }

    public Shape pivotZ(float angle) {
        return this.pivot(angle, 0.0f, 0.0f, 1.0f);
    }

    public Shape copyMatrix(Shape shape) {
        if (shape.transformMatrix != null) {
            this.transformMatrix = new Matrix4f(shape.transformMatrix);
        }
        return this;
    }

    public Shape applyMatrix() {
        if (this.transformMatrix == null && this.selfRotationMatrix == null) {
            return this;
        }
        if (this.transformMatrix != null) {
            this.transformMatrix.translate(new Vector3f(-0.5f, -0.5f, -0.5f));
        }
        if (this.selfRotationMatrix != null) {
            this.selfRotationMatrix.translate(new Vector3f(-0.5f, -0.5f, -0.5f));
        }
        for (Face f : this.faces) {
            for (Vertex v : f.getVertexes()) {
                if (this.selfRotationMatrix != null) {
                    v.applyMatrix(this.selfRotationMatrix);
                }
                if (this.transformMatrix == null) continue;
                v.applyMatrix(this.transformMatrix);
            }
        }
        this.transformMatrix = null;
        this.selfRotationMatrix = null;
        return this;
    }

    public Shape shrink(Face face, float factor) {
        for (Face f : this.faces) {
            if (f.name() != face.name()) continue;
            face = f;
        }
        HashMap<String, Vertex> vertexNames = new HashMap<String, Vertex>();
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (Vertex v : face.getVertexes()) {
            vertexNames.put(v.name(), v);
            x += v.getX() / 4.0;
            y += v.getY() / 4.0;
            z += v.getZ() / 4.0;
        }
        face.scale(factor, x, y, z);
        for (Face f : this.faces) {
            for (Vertex v : f.getVertexes()) {
                Vertex tmpV = (Vertex)vertexNames.get(v.name());
                if (tmpV == null) continue;
                v.set(tmpV.getX(), tmpV.getY(), tmpV.getZ());
            }
        }
        return this;
    }
}

